/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.partialbean.impl.interception;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.interceptor.InterceptorBinding;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;
import org.apache.deltaspike.partialbean.impl.interception.ManualInvocationContext;
import org.apache.deltaspike.partialbean.impl.interception.ProceedOriginalMethodException;

@Typed
public class ManualInvocationHandler
implements InvocationHandler {
    private static final ManualInvocationHandler INSTANCE = new ManualInvocationHandler();

    public static <T> Object staticInvoke(T proxy, Method method, Object[] parameters) throws Throwable {
        return INSTANCE.invoke(proxy, method, parameters);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] parameters) throws Throwable {
        List interceptors = this.resolveInterceptors(proxy, method);
        if (interceptors != null && interceptors.size() > 0) {
            ManualInvocationContext invocationContext = new ManualInvocationContext(this, interceptors, proxy, method, parameters, null);
            return invocationContext.proceed();
        }
        return this.proceedOriginal(proxy, method, parameters);
    }

    protected Object proceedOriginal(Object proxy, Method method, Object[] parameters) throws Exception {
        throw new ProceedOriginalMethodException();
    }

    protected List<Interceptor<?>> resolveInterceptors(Object instance, Method method) {
        Annotation[] interceptorBindings = this.extractInterceptorBindings(instance, method);
        if (interceptorBindings.length > 0) {
            BeanManager beanManager = BeanManagerProvider.getInstance().getBeanManager();
            return beanManager.resolveInterceptors(InterceptionType.AROUND_INVOKE, interceptorBindings);
        }
        return null;
    }

    protected Annotation[] extractInterceptorBindings(Object instance, Method method) {
        ArrayList<Annotation> bindings = new ArrayList<Annotation>();
        for (Annotation annotation : instance.getClass().getDeclaredAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(InterceptorBinding.class) || bindings.contains(annotation)) continue;
            bindings.add(annotation);
        }
        for (Annotation annotation : method.getDeclaredAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(InterceptorBinding.class) || bindings.contains(annotation)) continue;
            bindings.add(annotation);
        }
        return bindings.toArray(new Annotation[bindings.size()]);
    }
}

