/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.partialbean.impl.proxy;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import javax.enterprise.inject.Typed;
import org.apache.deltaspike.partialbean.impl.asm5.ClassWriter;
import org.apache.deltaspike.partialbean.impl.asm5.Label;
import org.apache.deltaspike.partialbean.impl.asm5.Type;
import org.apache.deltaspike.partialbean.impl.asm5.commons.GeneratorAdapter;
import org.apache.deltaspike.partialbean.impl.asm5.commons.Method;
import org.apache.deltaspike.partialbean.impl.interception.ManualInvocationHandler;
import org.apache.deltaspike.partialbean.impl.interception.ProceedOriginalMethodException;
import org.apache.deltaspike.partialbean.impl.proxy.PartialBeanProxy;

@Typed
public abstract class AsmProxyClassGenerator {
    private static final String FIELDNAME_HANDLER = "__handler";
    private static final Type TYPE_CLASS = Type.getType(Class.class);
    private static final Type TYPE_OBJECT = Type.getType(Object.class);

    private AsmProxyClassGenerator() {
    }

    public static <T> Class<T> generateProxyClass(ClassLoader classLoader, Class<T> targetClass, Class<? extends InvocationHandler> invocationHandlerClass, String suffix, java.lang.reflect.Method[] redirectMethods, java.lang.reflect.Method[] interceptionMethods) {
        String proxyName = targetClass.getCanonicalName() + suffix;
        String classFileName = proxyName.replace('.', '/');
        byte[] proxyBytes = AsmProxyClassGenerator.generateProxyClassBytes(targetClass, invocationHandlerClass, classFileName, redirectMethods, interceptionMethods);
        Class<?> proxyClass = AsmProxyClassGenerator.loadClass(classLoader, proxyName, proxyBytes);
        return proxyClass;
    }

    private static byte[] generateProxyClassBytes(Class<?> targetClass, Class<? extends InvocationHandler> invocationHandlerClass, String proxyName, java.lang.reflect.Method[] redirectMethods, java.lang.reflect.Method[] interceptionMethods) {
        Class<Object> superClass = targetClass;
        String[] interfaces = new String[]{};
        if (targetClass.isInterface()) {
            superClass = Object.class;
            interfaces = new String[]{Type.getInternalName(targetClass)};
        }
        interfaces = Arrays.copyOf(interfaces, interfaces.length + 1);
        interfaces[interfaces.length - 1] = Type.getInternalName(PartialBeanProxy.class);
        Type superType = Type.getType(superClass);
        Type proxyType = Type.getObjectType(proxyName);
        Type invocationHandlerType = Type.getType(invocationHandlerClass);
        ClassWriter cw = new ClassWriter(1);
        cw.visit(50, 33, proxyType.getInternalName(), null, superType.getInternalName(), interfaces);
        for (Annotation annotation : targetClass.getDeclaredAnnotations()) {
            cw.visitAnnotation(Type.getDescriptor(annotation.annotationType()), true).visitEnd();
        }
        AsmProxyClassGenerator.defineInvocationHandlerField(cw, invocationHandlerType);
        AsmProxyClassGenerator.defineConstructor(cw, proxyType, superType);
        AsmProxyClassGenerator.definePartialBeanProxyMethods(cw, proxyType, invocationHandlerType);
        for (java.lang.reflect.Method method : redirectMethods) {
            AsmProxyClassGenerator.defineMethod(cw, method, proxyType, invocationHandlerType, superType, true);
        }
        for (java.lang.reflect.Method method : interceptionMethods) {
            AsmProxyClassGenerator.defineMethod(cw, method, proxyType, invocationHandlerType, superType, false);
        }
        return cw.toByteArray();
    }

    private static void defineInvocationHandlerField(ClassWriter cw, Type invocationHandlerType) {
        cw.visitField(2, FIELDNAME_HANDLER, invocationHandlerType.getDescriptor(), null, null).visitEnd();
    }

    private static void defineConstructor(ClassWriter cw, Type proxyType, Type superType) {
        GeneratorAdapter mg = new GeneratorAdapter(1, new Method("<init>", Type.VOID_TYPE, new Type[0]), null, null, cw);
        mg.visitCode();
        mg.loadThis();
        mg.invokeConstructor(superType, Method.getMethod("void <init> ()"));
        mg.returnValue();
        mg.endMethod();
        mg.visitEnd();
    }

    private static void definePartialBeanProxyMethods(ClassWriter cw, Type proxyType, Type invocationHandlerType) {
        try {
            Method asmMethod = Method.getMethod(PartialBeanProxy.class.getDeclaredMethod("setRedirectInvocationHandler", InvocationHandler.class));
            GeneratorAdapter mg = new GeneratorAdapter(1, asmMethod, null, null, cw);
            mg.visitCode();
            mg.loadThis();
            mg.loadArg(0);
            mg.checkCast(invocationHandlerType);
            mg.putField(proxyType, FIELDNAME_HANDLER, invocationHandlerType);
            mg.returnValue();
            mg.visitMaxs(2, 1);
            mg.visitEnd();
            asmMethod = Method.getMethod(PartialBeanProxy.class.getDeclaredMethod("getRedirectInvocationHandler", new Class[0]));
            mg = new GeneratorAdapter(1, asmMethod, null, null, cw);
            mg.visitCode();
            mg.loadThis();
            mg.getField(proxyType, FIELDNAME_HANDLER, invocationHandlerType);
            mg.returnValue();
            mg.visitMaxs(2, 1);
            mg.visitEnd();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Unable to implement " + PartialBeanProxy.class.getName(), e);
        }
    }

    private static void defineMethod(ClassWriter cw, java.lang.reflect.Method method, Type proxyType, Type invocationHandlerType, Type superType, boolean callInvocationHandler) {
        Type methodType = Type.getType(method);
        Type[] exceptionTypes = AsmProxyClassGenerator.getTypes(method.getExceptionTypes());
        int modifiers = 5 & method.getModifiers();
        Method asmMethod = Method.getMethod(method);
        GeneratorAdapter mg = new GeneratorAdapter(modifiers, asmMethod, null, exceptionTypes, cw);
        for (Annotation annotation : method.getDeclaredAnnotations()) {
            mg.visitAnnotation(Type.getDescriptor(annotation.annotationType()), true).visitEnd();
        }
        mg.visitCode();
        Label tryBlockStart = mg.mark();
        mg.loadThis();
        AsmProxyClassGenerator.loadCurrentMethod(mg, method, methodType);
        AsmProxyClassGenerator.loadArguments(mg, method, methodType);
        mg.invokeStatic(Type.getType(ManualInvocationHandler.class), Method.getMethod("Object staticInvoke(Object, java.lang.reflect.Method, Object[])"));
        mg.unbox(methodType.getReturnType());
        Label tryBlockEnd = mg.mark();
        mg.returnValue();
        boolean throwableCatched = false;
        Label proceedOriginal = mg.mark();
        if (callInvocationHandler) {
            mg.loadThis();
            mg.getField(proxyType, FIELDNAME_HANDLER, invocationHandlerType);
            mg.loadThis();
            AsmProxyClassGenerator.loadCurrentMethod(mg, method, methodType);
            AsmProxyClassGenerator.loadArguments(mg, method, methodType);
            mg.invokeVirtual(invocationHandlerType, Method.getMethod("Object invoke(Object, java.lang.reflect.Method, Object[])"));
            mg.unbox(methodType.getReturnType());
            mg.returnValue();
        } else {
            mg.loadThis();
            mg.loadArgs();
            mg.visitMethodInsn(183, superType.getInternalName(), method.getName(), Type.getMethodDescriptor(method), false);
            mg.returnValue();
        }
        mg.visitTryCatchBlock(tryBlockStart, tryBlockEnd, proceedOriginal, Type.getInternalName(ProceedOriginalMethodException.class));
        if (exceptionTypes.length > 0) {
            Label rethrow = mg.mark();
            mg.visitVarInsn(58, 1);
            mg.visitVarInsn(25, 1);
            mg.throwException();
            for (Type exceptionType : exceptionTypes) {
                if (exceptionType.getClassName().equals(Throwable.class.getName())) {
                    throwableCatched = true;
                }
                mg.visitTryCatchBlock(tryBlockStart, tryBlockEnd, rethrow, exceptionType.getInternalName());
            }
        }
        if (!throwableCatched) {
            Type uteType = Type.getType(UndeclaredThrowableException.class);
            Label wrapAndRethrow = mg.mark();
            mg.visitVarInsn(58, 1);
            mg.newInstance(uteType);
            mg.dup();
            mg.visitVarInsn(25, 1);
            mg.invokeConstructor(uteType, Method.getMethod("void <init>(java.lang.Throwable)"));
            mg.throwException();
            mg.visitTryCatchBlock(tryBlockStart, tryBlockEnd, wrapAndRethrow, Type.getInternalName(Throwable.class));
        }
        mg.endMethod();
        mg.visitMaxs(10, 10);
        mg.visitEnd();
    }

    private static void loadCurrentMethod(GeneratorAdapter mg, java.lang.reflect.Method method, Type methodType) {
        mg.push(Type.getType(method.getDeclaringClass()));
        mg.push(method.getName());
        mg.push(methodType.getArgumentTypes().length);
        mg.newArray(TYPE_CLASS);
        for (int i = 0; i < methodType.getArgumentTypes().length; ++i) {
            mg.dup();
            mg.push(i);
            mg.push(methodType.getArgumentTypes()[i]);
            mg.arrayStore(TYPE_CLASS);
        }
        mg.invokeVirtual(TYPE_CLASS, Method.getMethod("java.lang.reflect.Method getDeclaredMethod(String, Class[])"));
    }

    private static void loadArguments(GeneratorAdapter mg, java.lang.reflect.Method method, Type methodType) {
        mg.push(methodType.getArgumentTypes().length);
        mg.newArray(TYPE_OBJECT);
        for (int i = 0; i < methodType.getArgumentTypes().length; ++i) {
            mg.dup();
            mg.push(i);
            mg.loadArg(i);
            mg.valueOf(methodType.getArgumentTypes()[i]);
            mg.arrayStore(TYPE_OBJECT);
        }
    }

    private static Type[] getTypes(Class<?> ... src) {
        Type[] result = new Type[src.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Type.getType(src[i]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> loadClass(ClassLoader loader, String className, byte[] b) {
        java.lang.reflect.Method method = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
        boolean accessible = method.isAccessible();
        if (!accessible) {
            method.setAccessible(true);
        }
        try {
            Class clazz = (Class)method.invoke((Object)loader, className, b, 0, b.length);
            if (!accessible) {
                method.setAccessible(false);
            }
            return clazz;
        }
        catch (Throwable throwable) {
            try {
                if (!accessible) {
                    method.setAccessible(false);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
            }
        }
    }
}

