/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.partialbean.impl.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.inject.Typed;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.partialbean.impl.proxy.AsmProxyClassGenerator;

@Typed
public abstract class PartialBeanProxyFactory {
    private static final String CLASSNAME_SUFFIX = "$$DSPartialBeanProxy";

    private PartialBeanProxyFactory() {
    }

    public static <T> Class<T> getProxyClass(Class<T> targetClass, Class<? extends InvocationHandler> invocationHandlerClass) {
        Class<T> proxyClass = ClassUtils.tryToLoadClassForName((String)PartialBeanProxyFactory.constructProxyClassName(targetClass), targetClass);
        if (proxyClass == null) {
            proxyClass = PartialBeanProxyFactory.createProxyClass(targetClass.getClassLoader(), targetClass, invocationHandlerClass);
        }
        return proxyClass;
    }

    private static synchronized <T> Class<T> createProxyClass(ClassLoader classLoader, Class<T> targetClass, Class<? extends InvocationHandler> invocationHandlerClass) {
        Class<T> proxyClass = ClassUtils.tryToLoadClassForName((String)PartialBeanProxyFactory.constructProxyClassName(targetClass), targetClass);
        if (proxyClass == null) {
            ArrayList<Method> redirectMethods = new ArrayList<Method>();
            ArrayList<Method> interceptionMethods = new ArrayList<Method>();
            PartialBeanProxyFactory.collectMethods(targetClass, redirectMethods, interceptionMethods);
            proxyClass = AsmProxyClassGenerator.generateProxyClass(classLoader, targetClass, invocationHandlerClass, CLASSNAME_SUFFIX, redirectMethods.toArray(new Method[redirectMethods.size()]), interceptionMethods.toArray(new Method[interceptionMethods.size()]));
        }
        return proxyClass;
    }

    private static String constructProxyClassName(Class<?> clazz) {
        return clazz.getCanonicalName() + CLASSNAME_SUFFIX;
    }

    public static boolean isProxyClass(Class<?> clazz) {
        return clazz.getName().endsWith(CLASSNAME_SUFFIX);
    }

    private static void collectMethods(Class<?> clazz, ArrayList<Method> redirectMethods, ArrayList<Method> interceptionMethods) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : clazz.getDeclaredMethods()) {
            if (PartialBeanProxyFactory.ignoreMethod(method, methods)) continue;
            methods.add(method);
        }
        for (Method method : clazz.getMethods()) {
            if (PartialBeanProxyFactory.ignoreMethod(method, methods)) continue;
            methods.add(method);
        }
        for (Class<?> currentSuperClass = clazz.getSuperclass(); currentSuperClass != null; currentSuperClass = currentSuperClass.getSuperclass()) {
            if (!Modifier.isAbstract(currentSuperClass.getModifiers())) continue;
            for (Method method : currentSuperClass.getDeclaredMethods()) {
                if (PartialBeanProxyFactory.ignoreMethod(method, methods)) continue;
                methods.add(method);
            }
            for (Method method : currentSuperClass.getMethods()) {
                if (PartialBeanProxyFactory.ignoreMethod(method, methods)) continue;
                methods.add(method);
            }
        }
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Iterator methodIterator = methods.iterator();
            while (methodIterator.hasNext()) {
                Method method = (Method)methodIterator.next();
                if (!Modifier.isAbstract(method.getModifiers())) continue;
                try {
                    Method foundMethod = currentClass.getMethod(method.getName(), method.getParameterTypes());
                    if (foundMethod == null || Modifier.isAbstract(foundMethod.getModifiers())) continue;
                    methodIterator.remove();
                }
                catch (Exception e) {}
            }
        }
        for (Method method : methods) {
            if (Modifier.isAbstract(method.getModifiers())) {
                redirectMethods.add(method);
                continue;
            }
            if (!Modifier.isPublic(method.getModifiers()) || Modifier.isFinal(method.getModifiers())) continue;
            interceptionMethods.add(method);
        }
    }

    private static boolean ignoreMethod(Method method, List<Method> methods) {
        if (method.isBridge()) {
            return true;
        }
        if ("finalize".equals(method.getName())) {
            return true;
        }
        if (methods.contains(method)) {
            return true;
        }
        for (Method currentMethod : methods) {
            if (!PartialBeanProxyFactory.hasSameSignature(currentMethod, method)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasSameSignature(Method a, Method b) {
        return a.getName().equals(b.getName()) && a.getReturnType().equals(b.getReturnType()) && Arrays.equals(a.getParameterTypes(), b.getParameterTypes());
    }
}

