/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.table;

import com.mongodb.client.model.Filters;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionDefaultVisitor;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.types.logical.LogicalType;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonString;
import org.bson.BsonType;
import org.bson.BsonUndefined;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.bson.types.Decimal128;

@Experimental
public class MongoFilterPushDownVisitor
extends ExpressionDefaultVisitor<BsonValue> {
    public static final MongoFilterPushDownVisitor INSTANCE = new MongoFilterPushDownVisitor();

    private MongoFilterPushDownVisitor() {
    }

    public BsonDocument visit(CallExpression call) {
        Bson filter = Filters.empty();
        if (BuiltInFunctionDefinitions.EQUALS.equals(call.getFunctionDefinition())) {
            filter = this.renderBinaryComparisonOperator("$eq", call.getResolvedChildren());
        }
        if (BuiltInFunctionDefinitions.LESS_THAN.equals(call.getFunctionDefinition())) {
            filter = this.renderBinaryComparisonOperator("$lt", call.getResolvedChildren());
        }
        if (BuiltInFunctionDefinitions.LESS_THAN_OR_EQUAL.equals(call.getFunctionDefinition())) {
            filter = this.renderBinaryComparisonOperator("$lte", call.getResolvedChildren());
        }
        if (BuiltInFunctionDefinitions.GREATER_THAN.equals(call.getFunctionDefinition())) {
            filter = this.renderBinaryComparisonOperator("$gt", call.getResolvedChildren());
        }
        if (BuiltInFunctionDefinitions.GREATER_THAN_OR_EQUAL.equals(call.getFunctionDefinition())) {
            filter = this.renderBinaryComparisonOperator("$gte", call.getResolvedChildren());
        }
        if (BuiltInFunctionDefinitions.NOT_EQUALS.equals(call.getFunctionDefinition())) {
            filter = this.renderBinaryComparisonOperator("$ne", call.getResolvedChildren());
        }
        if (BuiltInFunctionDefinitions.IS_NULL.equals(call.getFunctionDefinition())) {
            filter = this.renderUnaryComparisonOperator("$eq", (ResolvedExpression)call.getResolvedChildren().get(0), (BsonValue)BsonNull.VALUE);
        }
        if (BuiltInFunctionDefinitions.IS_NOT_NULL.equals(call.getFunctionDefinition())) {
            filter = this.renderUnaryComparisonOperator("$ne", (ResolvedExpression)call.getResolvedChildren().get(0), (BsonValue)BsonNull.VALUE);
        }
        if (BuiltInFunctionDefinitions.OR.equals(call.getFunctionDefinition())) {
            filter = this.renderLogicalOperator("$or", call.getResolvedChildren());
        }
        if (BuiltInFunctionDefinitions.AND.equals(call.getFunctionDefinition())) {
            filter = this.renderLogicalOperator("$and", call.getResolvedChildren());
        }
        return filter.toBsonDocument();
    }

    private Bson renderBinaryComparisonOperator(String operator, List<ResolvedExpression> expressions) {
        Optional<FieldReferenceExpression> fieldReferenceExpr = MongoFilterPushDownVisitor.extractExpression(expressions, FieldReferenceExpression.class);
        Optional<ValueLiteralExpression> fieldValueExpr = MongoFilterPushDownVisitor.extractExpression(expressions, ValueLiteralExpression.class);
        if (!fieldReferenceExpr.isPresent() || !fieldValueExpr.isPresent()) {
            return Filters.empty();
        }
        String fieldName = this.visit(fieldReferenceExpr.get()).getValue();
        BsonValue fieldValue = this.visit(fieldValueExpr.get());
        if (fieldValue.getBsonType() == BsonType.UNDEFINED) {
            return Filters.empty();
        }
        switch (operator) {
            case "$eq": {
                return Filters.eq((String)fieldName, (Object)fieldValue);
            }
            case "$lt": {
                return Filters.lt((String)fieldName, (Object)fieldValue);
            }
            case "$lte": {
                return Filters.lte((String)fieldName, (Object)fieldValue);
            }
            case "$gt": {
                return Filters.gt((String)fieldName, (Object)fieldValue);
            }
            case "$gte": {
                return Filters.gte((String)fieldName, (Object)fieldValue);
            }
            case "$ne": {
                return Filters.ne((String)fieldName, (Object)fieldValue);
            }
        }
        return Filters.empty();
    }

    private Bson renderUnaryComparisonOperator(String operator, ResolvedExpression operand, BsonValue value) {
        if (operand instanceof FieldReferenceExpression) {
            String fieldName = this.visit((FieldReferenceExpression)operand).getValue();
            switch (operator) {
                case "$eq": {
                    return Filters.eq((String)fieldName, (Object)value);
                }
                case "$ne": {
                    return Filters.ne((String)fieldName, (Object)value);
                }
            }
            return Filters.empty();
        }
        return Filters.empty();
    }

    private Bson renderLogicalOperator(String operator, List<ResolvedExpression> operands) {
        Bson[] filters = new Bson[operands.size()];
        for (int i = 0; i < operands.size(); ++i) {
            ResolvedExpression operand = operands.get(i);
            BsonValue filter = (BsonValue)operand.accept((ExpressionVisitor)this);
            if (!filter.isDocument() || filter.asDocument().isEmpty()) {
                return Filters.empty();
            }
            filters[i] = filter.asDocument();
        }
        switch (operator) {
            case "$or": {
                return Filters.or((Bson[])filters);
            }
            case "$and": {
                return Filters.and((Bson[])filters);
            }
        }
        return Filters.empty();
    }

    public BsonValue visit(ValueLiteralExpression litExp) {
        Optional<BsonUndefined> value;
        LogicalType type = litExp.getOutputDataType().getLogicalType();
        switch (type.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                value = litExp.getValueAs(String.class).map(BsonString::new);
                break;
            }
            case BOOLEAN: {
                value = litExp.getValueAs(Boolean.class).map(BsonBoolean::new);
                break;
            }
            case DECIMAL: {
                value = litExp.getValueAs(BigDecimal.class).map(Decimal128::new).map(BsonDecimal128::new);
                break;
            }
            case INTEGER: {
                value = litExp.getValueAs(Integer.class).map(BsonInt32::new);
                break;
            }
            case BIGINT: {
                value = litExp.getValueAs(Long.class).map(BsonInt64::new);
                break;
            }
            case DOUBLE: {
                value = litExp.getValueAs(Double.class).map(BsonDouble::new);
                break;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                value = litExp.getValueAs(LocalDateTime.class).map(Timestamp::valueOf).map(Timestamp::getTime).map(BsonDateTime::new);
                break;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                value = litExp.getValueAs(Instant.class).map(Instant::toEpochMilli).map(BsonDateTime::new);
                break;
            }
            default: {
                value = Optional.of(new BsonUndefined());
            }
        }
        return (BsonValue)value.orElse((BsonUndefined)BsonNull.VALUE);
    }

    public BsonString visit(FieldReferenceExpression fieldReference) {
        return new BsonString(fieldReference.toString());
    }

    protected BsonDocument defaultMethod(Expression expression) {
        return Filters.empty().toBsonDocument();
    }

    private static <T> Optional<T> extractExpression(List<ResolvedExpression> expressions, Class<T> type) {
        for (ResolvedExpression expression : expressions) {
            if (!type.isAssignableFrom(expression.getClass())) continue;
            return Optional.of(type.cast(expression));
        }
        return Optional.empty();
    }
}

