/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.state.AbstractChannelStateHandle;
import org.apache.flink.runtime.state.CompositeStateHandle;
import org.apache.flink.runtime.state.InputChannelStateHandle;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.ResultSubpartitionStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.StateUtil;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorSubtaskState
implements CompositeStateHandle {
    private static final Logger LOG = LoggerFactory.getLogger(OperatorSubtaskState.class);
    private static final long serialVersionUID = -2394696997971923995L;
    @Nonnull
    private final StateObjectCollection<OperatorStateHandle> managedOperatorState;
    @Nonnull
    private final StateObjectCollection<OperatorStateHandle> rawOperatorState;
    @Nonnull
    private final StateObjectCollection<KeyedStateHandle> managedKeyedState;
    @Nonnull
    private final StateObjectCollection<KeyedStateHandle> rawKeyedState;
    @Nonnull
    private final StateObjectCollection<InputChannelStateHandle> inputChannelState;
    @Nonnull
    private final StateObjectCollection<ResultSubpartitionStateHandle> resultSubpartitionState;
    private final long stateSize;

    public OperatorSubtaskState() {
        this(StateObjectCollection.empty(), StateObjectCollection.empty(), StateObjectCollection.empty(), StateObjectCollection.empty(), StateObjectCollection.empty(), StateObjectCollection.empty());
    }

    public OperatorSubtaskState(@Nonnull StateObjectCollection<OperatorStateHandle> managedOperatorState, @Nonnull StateObjectCollection<OperatorStateHandle> rawOperatorState, @Nonnull StateObjectCollection<KeyedStateHandle> managedKeyedState, @Nonnull StateObjectCollection<KeyedStateHandle> rawKeyedState) {
        this(managedOperatorState, rawOperatorState, managedKeyedState, rawKeyedState, StateObjectCollection.empty(), StateObjectCollection.empty());
    }

    public OperatorSubtaskState(@Nonnull StateObjectCollection<OperatorStateHandle> managedOperatorState, @Nonnull StateObjectCollection<OperatorStateHandle> rawOperatorState, @Nonnull StateObjectCollection<KeyedStateHandle> managedKeyedState, @Nonnull StateObjectCollection<KeyedStateHandle> rawKeyedState, @Nonnull StateObjectCollection<InputChannelStateHandle> inputChannelState, @Nonnull StateObjectCollection<ResultSubpartitionStateHandle> resultSubpartitionState) {
        this.managedOperatorState = (StateObjectCollection)Preconditions.checkNotNull(managedOperatorState);
        this.rawOperatorState = (StateObjectCollection)Preconditions.checkNotNull(rawOperatorState);
        this.managedKeyedState = (StateObjectCollection)Preconditions.checkNotNull(managedKeyedState);
        this.rawKeyedState = (StateObjectCollection)Preconditions.checkNotNull(rawKeyedState);
        this.inputChannelState = (StateObjectCollection)Preconditions.checkNotNull(inputChannelState);
        this.resultSubpartitionState = (StateObjectCollection)Preconditions.checkNotNull(resultSubpartitionState);
        long calculateStateSize = managedOperatorState.getStateSize();
        calculateStateSize += rawOperatorState.getStateSize();
        calculateStateSize += managedKeyedState.getStateSize();
        calculateStateSize += rawKeyedState.getStateSize();
        calculateStateSize += inputChannelState.getStateSize();
        this.stateSize = calculateStateSize += resultSubpartitionState.getStateSize();
    }

    public OperatorSubtaskState(@Nullable OperatorStateHandle managedOperatorState, @Nullable OperatorStateHandle rawOperatorState, @Nullable KeyedStateHandle managedKeyedState, @Nullable KeyedStateHandle rawKeyedState, @Nullable StateObjectCollection<InputChannelStateHandle> inputChannelState, @Nullable StateObjectCollection<ResultSubpartitionStateHandle> resultSubpartitionState) {
        this(OperatorSubtaskState.singletonOrEmptyOnNull(managedOperatorState), OperatorSubtaskState.singletonOrEmptyOnNull(rawOperatorState), OperatorSubtaskState.singletonOrEmptyOnNull(managedKeyedState), OperatorSubtaskState.singletonOrEmptyOnNull(rawKeyedState), StateObjectCollection.emptyIfNull(inputChannelState), StateObjectCollection.emptyIfNull(resultSubpartitionState));
    }

    private static <T extends StateObject> StateObjectCollection<T> singletonOrEmptyOnNull(T element) {
        return element != null ? StateObjectCollection.singleton(element) : StateObjectCollection.empty();
    }

    @Nonnull
    public StateObjectCollection<OperatorStateHandle> getManagedOperatorState() {
        return this.managedOperatorState;
    }

    @Nonnull
    public StateObjectCollection<OperatorStateHandle> getRawOperatorState() {
        return this.rawOperatorState;
    }

    @Nonnull
    public StateObjectCollection<KeyedStateHandle> getManagedKeyedState() {
        return this.managedKeyedState;
    }

    @Nonnull
    public StateObjectCollection<KeyedStateHandle> getRawKeyedState() {
        return this.rawKeyedState;
    }

    @Nonnull
    public StateObjectCollection<InputChannelStateHandle> getInputChannelState() {
        return this.inputChannelState;
    }

    @Nonnull
    public StateObjectCollection<ResultSubpartitionStateHandle> getResultSubpartitionState() {
        return this.resultSubpartitionState;
    }

    @Override
    public void discardState() {
        try {
            ArrayList<StateObject> toDispose = new ArrayList<StateObject>(this.managedOperatorState.size() + this.rawOperatorState.size() + this.managedKeyedState.size() + this.rawKeyedState.size() + this.inputChannelState.size() + this.resultSubpartitionState.size());
            toDispose.addAll(this.managedOperatorState);
            toDispose.addAll(this.rawOperatorState);
            toDispose.addAll(this.managedKeyedState);
            toDispose.addAll(this.rawKeyedState);
            toDispose.addAll(AbstractChannelStateHandle.collectUniqueDelegates(this.inputChannelState, this.resultSubpartitionState));
            StateUtil.bestEffortDiscardAllStateObjects(toDispose);
        }
        catch (Exception e) {
            LOG.warn("Error while discarding operator states.", (Throwable)e);
        }
    }

    @Override
    public void registerSharedStates(SharedStateRegistry sharedStateRegistry) {
        OperatorSubtaskState.registerSharedState(sharedStateRegistry, this.managedKeyedState);
        OperatorSubtaskState.registerSharedState(sharedStateRegistry, this.rawKeyedState);
    }

    private static void registerSharedState(SharedStateRegistry sharedStateRegistry, Iterable<KeyedStateHandle> stateHandles) {
        for (KeyedStateHandle stateHandle : stateHandles) {
            if (stateHandle == null) continue;
            stateHandle.registerSharedStates(sharedStateRegistry);
        }
    }

    @Override
    public long getStateSize() {
        return this.stateSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatorSubtaskState that = (OperatorSubtaskState)o;
        if (this.getStateSize() != that.getStateSize()) {
            return false;
        }
        if (!this.getManagedOperatorState().equals(that.getManagedOperatorState())) {
            return false;
        }
        if (!this.getRawOperatorState().equals(that.getRawOperatorState())) {
            return false;
        }
        if (!this.getManagedKeyedState().equals(that.getManagedKeyedState())) {
            return false;
        }
        if (!this.getInputChannelState().equals(that.getInputChannelState())) {
            return false;
        }
        if (!this.getResultSubpartitionState().equals(that.getResultSubpartitionState())) {
            return false;
        }
        return this.getRawKeyedState().equals(that.getRawKeyedState());
    }

    public int hashCode() {
        int result = this.getManagedOperatorState().hashCode();
        result = 31 * result + this.getRawOperatorState().hashCode();
        result = 31 * result + this.getManagedKeyedState().hashCode();
        result = 31 * result + this.getRawKeyedState().hashCode();
        result = 31 * result + this.getInputChannelState().hashCode();
        result = 31 * result + this.getResultSubpartitionState().hashCode();
        result = 31 * result + (int)(this.getStateSize() ^ this.getStateSize() >>> 32);
        return result;
    }

    public String toString() {
        return "SubtaskState{operatorStateFromBackend=" + this.managedOperatorState + ", operatorStateFromStream=" + this.rawOperatorState + ", keyedStateFromBackend=" + this.managedKeyedState + ", keyedStateFromStream=" + this.rawKeyedState + ", inputChannelState=" + this.inputChannelState + ", resultSubpartitionState=" + this.resultSubpartitionState + ", stateSize=" + this.stateSize + '}';
    }

    public boolean hasState() {
        return this.managedOperatorState.hasState() || this.rawOperatorState.hasState() || this.managedKeyedState.hasState() || this.rawKeyedState.hasState() || this.inputChannelState.hasState() || this.resultSubpartitionState.hasState();
    }
}

