/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateSerializer;
import org.apache.flink.runtime.state.AbstractChannelStateHandle;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SupplierWithException;

@NotThreadSafe
class RefCountingFSDataInputStream
extends FSDataInputStream {
    private final SupplierWithException<FSDataInputStream, IOException> streamSupplier;
    private FSDataInputStream stream;
    private final ChannelStateSerializer serializer;
    private int refCount = 0;
    private State state = State.NEW;

    private RefCountingFSDataInputStream(SupplierWithException<FSDataInputStream, IOException> streamSupplier, ChannelStateSerializer serializer) {
        this.streamSupplier = (SupplierWithException)Preconditions.checkNotNull(streamSupplier);
        this.serializer = (ChannelStateSerializer)Preconditions.checkNotNull((Object)serializer);
    }

    void incRef() {
        this.checkNotClosed();
        ++this.refCount;
    }

    void decRef() throws IOException {
        this.checkNotClosed();
        --this.refCount;
        if (this.refCount == 0) {
            this.close();
        }
    }

    public int read() throws IOException {
        this.ensureOpen();
        return this.stream.read();
    }

    public void seek(long pos) throws IOException {
        this.ensureOpen();
        this.stream.seek(pos);
    }

    public long getPos() throws IOException {
        this.ensureOpen();
        return this.stream.getPos();
    }

    public void close() throws IOException {
        this.state = State.CLOSED;
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
    }

    private void ensureOpen() throws IOException {
        this.checkNotClosed();
        if (this.state == State.NEW) {
            this.stream = (FSDataInputStream)Preconditions.checkNotNull((Object)this.streamSupplier.get());
            this.serializer.readHeader((InputStream)this.stream);
            this.state = State.OPENED;
        }
    }

    private void checkNotClosed() {
        Preconditions.checkState((this.state != State.CLOSED ? 1 : 0) != 0, (Object)"stream is closed");
    }

    @NotThreadSafe
    static class RefCountingFSDataInputStreamFactory {
        private final Map<StreamStateHandle, RefCountingFSDataInputStream> streams = new HashMap<StreamStateHandle, RefCountingFSDataInputStream>();
        private final ChannelStateSerializer serializer;

        RefCountingFSDataInputStreamFactory(ChannelStateSerializer serializer) {
            this.serializer = (ChannelStateSerializer)Preconditions.checkNotNull((Object)serializer);
        }

        <T> RefCountingFSDataInputStream getOrCreate(AbstractChannelStateHandle<T> handle) {
            StreamStateHandle streamStateHandle = handle.getDelegate();
            RefCountingFSDataInputStream stream = this.streams.get(streamStateHandle);
            if (stream == null) {
                stream = new RefCountingFSDataInputStream(streamStateHandle::openInputStream, this.serializer);
                this.streams.put(streamStateHandle, stream);
            }
            return stream;
        }

        ChannelStateSerializer getSerializer() {
            return this.serializer;
        }
    }

    private static enum State {
        NEW,
        OPENED,
        CLOSED;

    }
}

