/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.externalresource;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.api.common.externalresource.ExternalResourceDriver;
import org.apache.flink.api.common.externalresource.ExternalResourceDriverFactory;
import org.apache.flink.api.common.externalresource.ExternalResourceInfo;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DelegatingConfiguration;
import org.apache.flink.configuration.ExternalResourceOptions;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.runtime.externalresource.ExternalResourceInfoProvider;
import org.apache.flink.runtime.externalresource.StaticExternalResourceInfoProvider;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalResourceUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalResourceUtils.class);

    private ExternalResourceUtils() {
        throw new UnsupportedOperationException("This class should never be instantiated.");
    }

    private static Set<String> getExternalResourceSet(Configuration config) {
        return new HashSet<String>((Collection)config.get(ExternalResourceOptions.EXTERNAL_RESOURCE_LIST));
    }

    public static Map<String, Long> getExternalResources(Configuration config, String suffix) {
        Set<String> resourceSet = ExternalResourceUtils.getExternalResourceSet(config);
        LOG.info("Enabled external resources: {}", resourceSet);
        if (resourceSet.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Long> externalResourceConfigs = new HashMap<String, Long>();
        for (String resourceName : resourceSet) {
            ConfigOption amountOption = ConfigOptions.key((String)ExternalResourceOptions.getAmountConfigOptionForResource((String)resourceName)).longType().noDefaultValue();
            ConfigOption configKeyOption = ConfigOptions.key((String)ExternalResourceOptions.getSystemConfigKeyConfigOptionForResource((String)resourceName, (String)suffix)).stringType().noDefaultValue();
            String configKey = config.getString(configKeyOption);
            Optional amountOpt = config.getOptional(amountOption);
            if (StringUtils.isNullOrWhitespaceOnly((String)configKey)) {
                LOG.warn("Could not find valid {} for {}. Will ignore that resource.", (Object)configKeyOption.key(), (Object)resourceName);
                continue;
            }
            if (!amountOpt.isPresent()) {
                LOG.warn("The amount of the {} should be configured. Will ignore that resource.", (Object)resourceName);
                continue;
            }
            if ((Long)amountOpt.get() <= 0L) {
                LOG.warn("The amount of the {} should be positive while finding {}. Will ignore that resource.", amountOpt.get(), (Object)resourceName);
                continue;
            }
            if (externalResourceConfigs.put(configKey, (Long)amountOpt.get()) != null) {
                LOG.warn("Duplicate config key {} occurred for external resources, the one named {} with amount {} will overwrite the value.", new Object[]{configKey, resourceName, amountOpt});
                continue;
            }
            LOG.info("Add external resource config for {} with key {} value {}.", new Object[]{resourceName, configKey, amountOpt});
        }
        return externalResourceConfigs;
    }

    public static Map<String, Long> getExternalResourceAmountMap(Configuration config) {
        Set<String> resourceSet = ExternalResourceUtils.getExternalResourceSet(config);
        LOG.info("Enabled external resources: {}", resourceSet);
        if (resourceSet.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Long> externalResourceAmountMap = new HashMap<String, Long>();
        for (String resourceName : resourceSet) {
            ConfigOption amountOption = ConfigOptions.key((String)ExternalResourceOptions.getAmountConfigOptionForResource((String)resourceName)).longType().noDefaultValue();
            Optional amountOpt = config.getOptional(amountOption);
            if (!amountOpt.isPresent()) {
                LOG.warn("The amount of the {} should be configured. Will ignore that resource.", (Object)resourceName);
                continue;
            }
            if ((Long)amountOpt.get() <= 0L) {
                LOG.warn("The amount of the {} should be positive while finding {}. Will ignore that resource.", amountOpt.get(), (Object)resourceName);
                continue;
            }
            externalResourceAmountMap.put(resourceName, (Long)amountOpt.get());
        }
        return externalResourceAmountMap;
    }

    public static Map<String, ExternalResourceDriver> externalResourceDriversFromConfig(Configuration config, PluginManager pluginManager) {
        Set<String> resourceSet = ExternalResourceUtils.getExternalResourceSet(config);
        LOG.info("Enabled external resources: {}", resourceSet);
        if (resourceSet.isEmpty()) {
            return Collections.emptyMap();
        }
        Iterator factoryIterator = pluginManager.load(ExternalResourceDriverFactory.class);
        HashMap externalResourceFactories = new HashMap();
        factoryIterator.forEachRemaining(externalResourceDriverFactory -> externalResourceFactories.put(externalResourceDriverFactory.getClass().getName(), externalResourceDriverFactory));
        HashMap<String, ExternalResourceDriver> externalResourceDrivers = new HashMap<String, ExternalResourceDriver>();
        for (String resourceName : resourceSet) {
            ConfigOption driverClassOption = ConfigOptions.key((String)ExternalResourceOptions.getExternalResourceDriverFactoryConfigOptionForResource((String)resourceName)).stringType().noDefaultValue();
            String driverFactoryClassName = config.getString(driverClassOption);
            if (StringUtils.isNullOrWhitespaceOnly((String)driverFactoryClassName)) {
                LOG.warn("Could not find driver class name for {}. Please make sure {} is configured.", (Object)resourceName, (Object)driverClassOption.key());
                continue;
            }
            ExternalResourceDriverFactory externalResourceDriverFactory2 = (ExternalResourceDriverFactory)externalResourceFactories.get(driverFactoryClassName);
            if (externalResourceDriverFactory2 != null) {
                DelegatingConfiguration delegatingConfiguration = new DelegatingConfiguration(config, ExternalResourceOptions.getExternalResourceParamConfigPrefixForResource((String)resourceName));
                try {
                    externalResourceDrivers.put(resourceName, externalResourceDriverFactory2.createExternalResourceDriver((Configuration)delegatingConfiguration));
                    LOG.info("Add external resources driver for {}.", (Object)resourceName);
                }
                catch (Exception e) {
                    LOG.warn("Could not instantiate driver with factory {} for {}. {}", new Object[]{driverFactoryClassName, resourceName, e});
                }
                continue;
            }
            LOG.warn("Could not find factory class {} for {}.", (Object)driverFactoryClassName, (Object)resourceName);
        }
        return externalResourceDrivers;
    }

    public static ExternalResourceInfoProvider createStaticExternalResourceInfoProvider(Map<String, Long> externalResourceAmountMap, Map<String, ExternalResourceDriver> externalResourceDrivers) {
        HashMap<String, Set<? extends ExternalResourceInfo>> externalResources = new HashMap<String, Set<? extends ExternalResourceInfo>>();
        for (Map.Entry<String, ExternalResourceDriver> externalResourceDriverEntry : externalResourceDrivers.entrySet()) {
            String resourceName = externalResourceDriverEntry.getKey();
            ExternalResourceDriver externalResourceDriver = externalResourceDriverEntry.getValue();
            if (externalResourceAmountMap.containsKey(resourceName)) {
                try {
                    Set externalResourceInfos = externalResourceDriver.retrieveResourceInfo(externalResourceAmountMap.get(resourceName).longValue());
                    externalResources.put(resourceName, externalResourceInfos);
                }
                catch (Exception e) {
                    LOG.warn("Failed to retrieve information of external resource {}.", (Object)resourceName, (Object)e);
                }
                continue;
            }
            LOG.warn("Could not found legal amount configuration for {}.", (Object)resourceName);
        }
        return new StaticExternalResourceInfoProvider(externalResources);
    }
}

