/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.core.plugin.PluginUtils;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.dispatcher.ArchivedExecutionGraphStore;
import org.apache.flink.runtime.entrypoint.ClusterEntrypointException;
import org.apache.flink.runtime.entrypoint.EntrypointClusterConfiguration;
import org.apache.flink.runtime.entrypoint.EntrypointClusterConfigurationParserFactory;
import org.apache.flink.runtime.entrypoint.FlinkParseException;
import org.apache.flink.runtime.entrypoint.component.DispatcherResourceManagerComponent;
import org.apache.flink.runtime.entrypoint.component.DispatcherResourceManagerComponentFactory;
import org.apache.flink.runtime.entrypoint.parser.CommandLineParser;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.metrics.MetricRegistryConfiguration;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.ReporterSetup;
import org.apache.flink.runtime.metrics.util.MetricUtils;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.akka.AkkaRpcServiceUtils;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.SecurityContext;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.runtime.util.Hardware;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.runtime.webmonitor.retriever.impl.RpcMetricQueryServiceRetriever;
import org.apache.flink.util.AutoCloseableAsync;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.ExecutorUtils;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.ShutdownHookUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClusterEntrypoint
implements AutoCloseableAsync,
FatalErrorHandler {
    public static final ConfigOption<String> EXECUTION_MODE = ConfigOptions.key((String)"internal.cluster.execution-mode").defaultValue((Object)ExecutionMode.NORMAL.toString());
    protected static final Logger LOG = LoggerFactory.getLogger(ClusterEntrypoint.class);
    protected static final int STARTUP_FAILURE_RETURN_CODE = 1;
    protected static final int RUNTIME_FAILURE_RETURN_CODE = 2;
    private static final Time INITIALIZATION_SHUTDOWN_TIMEOUT = Time.seconds((long)30L);
    private final Object lock = new Object();
    private final Configuration configuration;
    private final CompletableFuture<ApplicationStatus> terminationFuture;
    private final AtomicBoolean isShutDown = new AtomicBoolean(false);
    @GuardedBy(value="lock")
    private DispatcherResourceManagerComponent<?> clusterComponent;
    @GuardedBy(value="lock")
    private MetricRegistryImpl metricRegistry;
    @GuardedBy(value="lock")
    private HighAvailabilityServices haServices;
    @GuardedBy(value="lock")
    private BlobServer blobServer;
    @GuardedBy(value="lock")
    private HeartbeatServices heartbeatServices;
    @GuardedBy(value="lock")
    private RpcService commonRpcService;
    @GuardedBy(value="lock")
    private ExecutorService ioExecutor;
    private ArchivedExecutionGraphStore archivedExecutionGraphStore;
    private final Thread shutDownHook;

    protected ClusterEntrypoint(Configuration configuration) {
        this.configuration = this.generateClusterConfiguration(configuration);
        this.terminationFuture = new CompletableFuture();
        this.shutDownHook = ShutdownHookUtil.addShutdownHook(this::cleanupDirectories, (String)this.getClass().getSimpleName(), (Logger)LOG);
    }

    public CompletableFuture<ApplicationStatus> getTerminationFuture() {
        return this.terminationFuture;
    }

    public void startCluster() throws ClusterEntrypointException {
        LOG.info("Starting {}.", (Object)this.getClass().getSimpleName());
        try {
            this.configureFileSystems(this.configuration);
            SecurityContext securityContext = this.installSecurityContext(this.configuration);
            securityContext.runSecured(() -> {
                this.runCluster(this.configuration);
                return null;
            });
        }
        catch (Throwable t) {
            Throwable strippedThrowable = ExceptionUtils.stripException((Throwable)t, UndeclaredThrowableException.class);
            try {
                this.shutDownAsync(ApplicationStatus.FAILED, ExceptionUtils.stringifyException((Throwable)strippedThrowable), false).get(INITIALIZATION_SHUTDOWN_TIMEOUT.toMilliseconds(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                strippedThrowable.addSuppressed(e);
            }
            throw new ClusterEntrypointException(String.format("Failed to initialize the cluster entrypoint %s.", this.getClass().getSimpleName()), strippedThrowable);
        }
    }

    private void configureFileSystems(Configuration configuration) {
        LOG.info("Install default filesystem.");
        FileSystem.initialize((Configuration)configuration, (PluginManager)PluginUtils.createPluginManagerFromRootFolder((Configuration)configuration));
    }

    protected SecurityContext installSecurityContext(Configuration configuration) throws Exception {
        LOG.info("Install security context.");
        SecurityUtils.install(new SecurityConfiguration(configuration));
        return SecurityUtils.getInstalledContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCluster(Configuration configuration) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.initializeServices(configuration);
            configuration.setString(JobManagerOptions.ADDRESS, this.commonRpcService.getAddress());
            configuration.setInteger(JobManagerOptions.PORT, this.commonRpcService.getPort());
            DispatcherResourceManagerComponentFactory<?> dispatcherResourceManagerComponentFactory = this.createDispatcherResourceManagerComponentFactory(configuration);
            this.clusterComponent = dispatcherResourceManagerComponentFactory.create(configuration, this.ioExecutor, this.commonRpcService, this.haServices, this.blobServer, this.heartbeatServices, this.metricRegistry, this.archivedExecutionGraphStore, new RpcMetricQueryServiceRetriever(this.metricRegistry.getMetricQueryServiceRpcService()), this);
            this.clusterComponent.getShutDownFuture().whenComplete((applicationStatus, throwable) -> {
                if (throwable != null) {
                    this.shutDownAsync(ApplicationStatus.UNKNOWN, ExceptionUtils.stringifyException((Throwable)throwable), false);
                } else {
                    this.shutDownAsync((ApplicationStatus)((Object)applicationStatus), null, true);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeServices(Configuration configuration) throws Exception {
        LOG.info("Initializing cluster services.");
        Object object = this.lock;
        synchronized (object) {
            String bindAddress = configuration.getString(JobManagerOptions.ADDRESS);
            String portRange = this.getRPCPortRange(configuration);
            this.commonRpcService = this.createRpcService(configuration, bindAddress, portRange);
            configuration.setString(JobManagerOptions.ADDRESS, this.commonRpcService.getAddress());
            configuration.setInteger(JobManagerOptions.PORT, this.commonRpcService.getPort());
            this.ioExecutor = Executors.newFixedThreadPool(Hardware.getNumberCPUCores(), new ExecutorThreadFactory("cluster-io"));
            this.haServices = this.createHaServices(configuration, this.ioExecutor);
            this.blobServer = new BlobServer(configuration, this.haServices.createBlobStore());
            this.blobServer.start();
            this.heartbeatServices = this.createHeartbeatServices(configuration);
            this.metricRegistry = this.createMetricRegistry(configuration);
            RpcService metricQueryServiceRpcService = MetricUtils.startMetricsRpcService(configuration, bindAddress);
            this.metricRegistry.startQueryService(metricQueryServiceRpcService, null);
            this.archivedExecutionGraphStore = this.createSerializableExecutionGraphStore(configuration, this.commonRpcService.getScheduledExecutor());
        }
    }

    @Nonnull
    private RpcService createRpcService(Configuration configuration, String bindAddress, String portRange) throws Exception {
        return AkkaRpcServiceUtils.createRpcService(bindAddress, portRange, configuration);
    }

    protected String getRPCPortRange(Configuration configuration) {
        if (ZooKeeperUtils.isZooKeeperRecoveryMode(configuration)) {
            return configuration.getString(HighAvailabilityOptions.HA_JOB_MANAGER_PORT_RANGE);
        }
        return String.valueOf(configuration.getInteger(JobManagerOptions.PORT));
    }

    protected HighAvailabilityServices createHaServices(Configuration configuration, Executor executor) throws Exception {
        return HighAvailabilityServicesUtils.createHighAvailabilityServices(configuration, executor, HighAvailabilityServicesUtils.AddressResolution.NO_ADDRESS_RESOLUTION);
    }

    protected HeartbeatServices createHeartbeatServices(Configuration configuration) {
        return HeartbeatServices.fromConfiguration(configuration);
    }

    protected MetricRegistryImpl createMetricRegistry(Configuration configuration) {
        return new MetricRegistryImpl(MetricRegistryConfiguration.fromConfiguration(configuration), ReporterSetup.fromConfiguration(configuration));
    }

    public CompletableFuture<Void> closeAsync() {
        return this.shutDownAsync(ApplicationStatus.UNKNOWN, "Cluster entrypoint has been closed externally.", true).thenAccept(ignored -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Void> stopClusterServices(boolean cleanupHaData) {
        long shutdownTimeout = this.configuration.getLong(ClusterOptions.CLUSTER_SERVICES_SHUTDOWN_TIMEOUT);
        Object object = this.lock;
        synchronized (object) {
            Throwable exception = null;
            ArrayList terminationFutures = new ArrayList(3);
            if (this.blobServer != null) {
                try {
                    this.blobServer.close();
                }
                catch (Throwable t) {
                    exception = ExceptionUtils.firstOrSuppressed((Throwable)t, exception);
                }
            }
            if (this.haServices != null) {
                try {
                    if (cleanupHaData) {
                        this.haServices.closeAndCleanupAllData();
                    } else {
                        this.haServices.close();
                    }
                }
                catch (Throwable t) {
                    exception = ExceptionUtils.firstOrSuppressed((Throwable)t, (Throwable)exception);
                }
            }
            if (this.archivedExecutionGraphStore != null) {
                try {
                    this.archivedExecutionGraphStore.close();
                }
                catch (Throwable t) {
                    exception = ExceptionUtils.firstOrSuppressed((Throwable)t, (Throwable)exception);
                }
            }
            if (this.metricRegistry != null) {
                terminationFutures.add(this.metricRegistry.shutdown());
            }
            if (this.ioExecutor != null) {
                terminationFutures.add(ExecutorUtils.nonBlockingShutdown((long)shutdownTimeout, (TimeUnit)TimeUnit.MILLISECONDS, (ExecutorService[])new ExecutorService[]{this.ioExecutor}));
            }
            if (this.commonRpcService != null) {
                terminationFutures.add(this.commonRpcService.stopService());
            }
            if (exception != null) {
                terminationFutures.add(FutureUtils.completedExceptionally(exception));
            }
            return FutureUtils.completeAll(terminationFutures);
        }
    }

    @Override
    public void onFatalError(Throwable exception) {
        LOG.error("Fatal error occurred in the cluster entrypoint.", exception);
        System.exit(2);
    }

    private Configuration generateClusterConfiguration(Configuration configuration) {
        Configuration resultConfiguration = new Configuration((Configuration)Preconditions.checkNotNull((Object)configuration));
        String webTmpDir = configuration.getString(WebOptions.TMP_DIR);
        File uniqueWebTmpDir = new File(webTmpDir, "flink-web-" + UUID.randomUUID());
        resultConfiguration.setString(WebOptions.TMP_DIR, uniqueWebTmpDir.getAbsolutePath());
        return resultConfiguration;
    }

    private CompletableFuture<ApplicationStatus> shutDownAsync(ApplicationStatus applicationStatus, @Nullable String diagnostics, boolean cleanupHaData) {
        if (this.isShutDown.compareAndSet(false, true)) {
            LOG.info("Shutting {} down with application status {}. Diagnostics {}.", new Object[]{this.getClass().getSimpleName(), applicationStatus, diagnostics});
            CompletableFuture<Void> shutDownApplicationFuture = this.closeClusterComponent(applicationStatus, diagnostics);
            CompletableFuture<Void> serviceShutdownFuture = FutureUtils.composeAfterwards(shutDownApplicationFuture, () -> this.stopClusterServices(cleanupHaData));
            CompletableFuture<Void> cleanupDirectoriesFuture = FutureUtils.runAfterwards(serviceShutdownFuture, this::cleanupDirectories);
            cleanupDirectoriesFuture.whenComplete((ignored2, serviceThrowable) -> {
                if (serviceThrowable != null) {
                    this.terminationFuture.completeExceptionally((Throwable)serviceThrowable);
                } else {
                    this.terminationFuture.complete(applicationStatus);
                }
            });
        }
        return this.terminationFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> closeClusterComponent(ApplicationStatus applicationStatus, @Nullable String diagnostics) {
        Object object = this.lock;
        synchronized (object) {
            if (this.clusterComponent != null) {
                return this.clusterComponent.deregisterApplicationAndClose(applicationStatus, diagnostics);
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    private void cleanupDirectories() throws IOException {
        ShutdownHookUtil.removeShutdownHook((Thread)this.shutDownHook, (String)this.getClass().getSimpleName(), (Logger)LOG);
        String webTmpDir = this.configuration.getString(WebOptions.TMP_DIR);
        FileUtils.deleteDirectory((File)new File(webTmpDir));
    }

    protected abstract DispatcherResourceManagerComponentFactory<?> createDispatcherResourceManagerComponentFactory(Configuration var1);

    protected abstract ArchivedExecutionGraphStore createSerializableExecutionGraphStore(Configuration var1, ScheduledExecutor var2) throws IOException;

    protected static EntrypointClusterConfiguration parseArguments(String[] args) throws FlinkParseException {
        CommandLineParser<EntrypointClusterConfiguration> clusterConfigurationParser = new CommandLineParser<EntrypointClusterConfiguration>(new EntrypointClusterConfigurationParserFactory());
        return clusterConfigurationParser.parse(args);
    }

    protected static Configuration loadConfiguration(EntrypointClusterConfiguration entrypointClusterConfiguration) {
        String hostname;
        Configuration dynamicProperties = ConfigurationUtils.createConfiguration((Properties)entrypointClusterConfiguration.getDynamicProperties());
        Configuration configuration = GlobalConfiguration.loadConfiguration((String)entrypointClusterConfiguration.getConfigDir(), (Configuration)dynamicProperties);
        int restPort = entrypointClusterConfiguration.getRestPort();
        if (restPort >= 0) {
            configuration.setInteger(RestOptions.PORT, restPort);
        }
        if ((hostname = entrypointClusterConfiguration.getHostname()) != null) {
            configuration.setString(JobManagerOptions.ADDRESS, hostname);
        }
        return configuration;
    }

    public static void runClusterEntrypoint(ClusterEntrypoint clusterEntrypoint) {
        String clusterEntrypointName = clusterEntrypoint.getClass().getSimpleName();
        try {
            clusterEntrypoint.startCluster();
        }
        catch (ClusterEntrypointException e) {
            LOG.error(String.format("Could not start cluster entrypoint %s.", clusterEntrypointName), (Throwable)((Object)e));
            System.exit(1);
        }
        clusterEntrypoint.getTerminationFuture().whenComplete((applicationStatus, throwable) -> {
            int returnCode = throwable != null ? 2 : applicationStatus.processExitCode();
            LOG.info("Terminating cluster entrypoint process {} with exit code {}.", new Object[]{clusterEntrypointName, returnCode, throwable});
            System.exit(returnCode);
        });
    }

    public static enum ExecutionMode {
        NORMAL,
        DETACHED;

    }
}

