/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.execution.librarycache;

import java.net.URL;
import java.net.URLClassLoader;
import org.apache.flink.util.ChildFirstClassLoader;

public class FlinkUserCodeClassLoaders {
    public static URLClassLoader parentFirst(URL[] urls, ClassLoader parent) {
        return new ParentFirstClassLoader(urls, parent);
    }

    public static URLClassLoader childFirst(URL[] urls, ClassLoader parent, String[] alwaysParentFirstPatterns) {
        return new ChildFirstClassLoader(urls, parent, alwaysParentFirstPatterns);
    }

    public static URLClassLoader create(ResolveOrder resolveOrder, URL[] urls, ClassLoader parent, String[] alwaysParentFirstPatterns) {
        switch (resolveOrder) {
            case CHILD_FIRST: {
                return FlinkUserCodeClassLoaders.childFirst(urls, parent, alwaysParentFirstPatterns);
            }
            case PARENT_FIRST: {
                return FlinkUserCodeClassLoaders.parentFirst(urls, parent);
            }
        }
        throw new IllegalArgumentException("Unknown class resolution order: " + (Object)((Object)resolveOrder));
    }

    static class ParentFirstClassLoader
    extends URLClassLoader {
        ParentFirstClassLoader(URL[] urls) {
            this(urls, FlinkUserCodeClassLoaders.class.getClassLoader());
        }

        ParentFirstClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }
    }

    public static enum ResolveOrder {
        CHILD_FIRST,
        PARENT_FIRST;


        public static ResolveOrder fromString(String resolveOrder) {
            if (resolveOrder.equalsIgnoreCase("parent-first")) {
                return PARENT_FIRST;
            }
            if (resolveOrder.equalsIgnoreCase("child-first")) {
                return CHILD_FIRST;
            }
            throw new IllegalArgumentException("Unknown resolve order: " + resolveOrder);
        }
    }
}

