/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmaster.slotpool.DefaultLocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.EvenlySpreadOutLocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;

public abstract class LocationPreferenceSlotSelectionStrategy
implements SlotSelectionStrategy {
    LocationPreferenceSlotSelectionStrategy() {
    }

    @Override
    public Optional<SlotSelectionStrategy.SlotInfoAndLocality> selectBestSlotForProfile(@Nonnull Collection<SlotSelectionStrategy.SlotInfoAndResources> availableSlots, @Nonnull SlotProfile slotProfile) {
        Collection<TaskManagerLocation> locationPreferences = slotProfile.getPreferredLocations();
        if (availableSlots.isEmpty()) {
            return Optional.empty();
        }
        ResourceProfile resourceProfile = slotProfile.getResourceProfile();
        return locationPreferences.isEmpty() ? this.selectWithoutLocationPreference(availableSlots, resourceProfile) : this.selectWitLocationPreference(availableSlots, locationPreferences, resourceProfile);
    }

    @Nonnull
    private Optional<SlotSelectionStrategy.SlotInfoAndLocality> selectWitLocationPreference(@Nonnull Collection<SlotSelectionStrategy.SlotInfoAndResources> availableSlots, @Nonnull Collection<TaskManagerLocation> locationPreferences, @Nonnull ResourceProfile resourceProfile) {
        HashMap<ResourceID, Integer> preferredResourceIDs = new HashMap<ResourceID, Integer>(locationPreferences.size());
        HashMap<String, Integer> preferredFQHostNames = new HashMap<String, Integer>(locationPreferences.size());
        for (TaskManagerLocation locationPreference : locationPreferences) {
            preferredResourceIDs.merge(locationPreference.getResourceID(), 1, Integer::sum);
            preferredFQHostNames.merge(locationPreference.getFQDNHostname(), 1, Integer::sum);
        }
        SlotSelectionStrategy.SlotInfoAndResources bestCandidate = null;
        Locality bestCandidateLocality = Locality.UNKNOWN;
        double bestCandidateScore = Double.NEGATIVE_INFINITY;
        for (SlotSelectionStrategy.SlotInfoAndResources candidate : availableSlots) {
            int hostLocalWeigh;
            int localWeigh;
            double candidateScore;
            if (!candidate.getRemainingResources().isMatching(resourceProfile) || !((candidateScore = this.calculateCandidateScore(localWeigh = preferredResourceIDs.getOrDefault(candidate.getSlotInfo().getTaskManagerLocation().getResourceID(), 0).intValue(), hostLocalWeigh = preferredFQHostNames.getOrDefault(candidate.getSlotInfo().getTaskManagerLocation().getFQDNHostname(), 0).intValue(), candidate.getTaskExecutorUtilization())) > bestCandidateScore)) continue;
            bestCandidateScore = candidateScore;
            bestCandidate = candidate;
            bestCandidateLocality = localWeigh > 0 ? Locality.LOCAL : (hostLocalWeigh > 0 ? Locality.HOST_LOCAL : Locality.NON_LOCAL);
        }
        return bestCandidate != null ? Optional.of(SlotSelectionStrategy.SlotInfoAndLocality.of(bestCandidate.getSlotInfo(), bestCandidateLocality)) : Optional.empty();
    }

    @Nonnull
    protected abstract Optional<SlotSelectionStrategy.SlotInfoAndLocality> selectWithoutLocationPreference(@Nonnull Collection<SlotSelectionStrategy.SlotInfoAndResources> var1, @Nonnull ResourceProfile var2);

    protected abstract double calculateCandidateScore(int var1, int var2, double var3);

    public static LocationPreferenceSlotSelectionStrategy createDefault() {
        return new DefaultLocationPreferenceSlotSelectionStrategy();
    }

    public static LocationPreferenceSlotSelectionStrategy createEvenlySpreadOut() {
        return new EvenlySpreadOutLocationPreferenceSlotSelectionStrategy();
    }
}

