/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.TransientBlobService;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.rest.RestServerEndpoint;
import org.apache.flink.runtime.rest.RestServerEndpointConfiguration;
import org.apache.flink.runtime.rest.handler.RestHandlerConfiguration;
import org.apache.flink.runtime.rest.handler.RestHandlerSpecification;
import org.apache.flink.runtime.rest.handler.cluster.ClusterConfigHandler;
import org.apache.flink.runtime.rest.handler.cluster.ClusterOverviewHandler;
import org.apache.flink.runtime.rest.handler.cluster.DashboardConfigHandler;
import org.apache.flink.runtime.rest.handler.cluster.ShutdownHandler;
import org.apache.flink.runtime.rest.handler.job.JobAccumulatorsHandler;
import org.apache.flink.runtime.rest.handler.job.JobCancellationHandler;
import org.apache.flink.runtime.rest.handler.job.JobConfigHandler;
import org.apache.flink.runtime.rest.handler.job.JobDetailsHandler;
import org.apache.flink.runtime.rest.handler.job.JobExceptionsHandler;
import org.apache.flink.runtime.rest.handler.job.JobExecutionResultHandler;
import org.apache.flink.runtime.rest.handler.job.JobIdsHandler;
import org.apache.flink.runtime.rest.handler.job.JobPlanHandler;
import org.apache.flink.runtime.rest.handler.job.JobVertexAccumulatorsHandler;
import org.apache.flink.runtime.rest.handler.job.JobVertexBackPressureHandler;
import org.apache.flink.runtime.rest.handler.job.JobVertexDetailsHandler;
import org.apache.flink.runtime.rest.handler.job.JobVertexTaskManagersHandler;
import org.apache.flink.runtime.rest.handler.job.JobsOverviewHandler;
import org.apache.flink.runtime.rest.handler.job.SubtaskCurrentAttemptDetailsHandler;
import org.apache.flink.runtime.rest.handler.job.SubtaskExecutionAttemptAccumulatorsHandler;
import org.apache.flink.runtime.rest.handler.job.SubtaskExecutionAttemptDetailsHandler;
import org.apache.flink.runtime.rest.handler.job.SubtasksAllAccumulatorsHandler;
import org.apache.flink.runtime.rest.handler.job.SubtasksTimesHandler;
import org.apache.flink.runtime.rest.handler.job.checkpoints.CheckpointConfigHandler;
import org.apache.flink.runtime.rest.handler.job.checkpoints.CheckpointStatisticDetailsHandler;
import org.apache.flink.runtime.rest.handler.job.checkpoints.CheckpointStatsCache;
import org.apache.flink.runtime.rest.handler.job.checkpoints.CheckpointingStatisticsHandler;
import org.apache.flink.runtime.rest.handler.job.checkpoints.TaskCheckpointStatisticDetailsHandler;
import org.apache.flink.runtime.rest.handler.job.metrics.AggregatingJobsMetricsHandler;
import org.apache.flink.runtime.rest.handler.job.metrics.AggregatingSubtasksMetricsHandler;
import org.apache.flink.runtime.rest.handler.job.metrics.AggregatingTaskManagersMetricsHandler;
import org.apache.flink.runtime.rest.handler.job.metrics.JobManagerMetricsHandler;
import org.apache.flink.runtime.rest.handler.job.metrics.JobMetricsHandler;
import org.apache.flink.runtime.rest.handler.job.metrics.JobVertexMetricsHandler;
import org.apache.flink.runtime.rest.handler.job.metrics.SubtaskMetricsHandler;
import org.apache.flink.runtime.rest.handler.job.metrics.TaskManagerMetricsHandler;
import org.apache.flink.runtime.rest.handler.job.rescaling.RescalingHandlers;
import org.apache.flink.runtime.rest.handler.job.savepoints.SavepointDisposalHandlers;
import org.apache.flink.runtime.rest.handler.job.savepoints.SavepointHandlers;
import org.apache.flink.runtime.rest.handler.legacy.ConstantTextHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.files.LogFileHandlerSpecification;
import org.apache.flink.runtime.rest.handler.legacy.files.StaticFileServerHandler;
import org.apache.flink.runtime.rest.handler.legacy.files.StdoutFileHandlerSpecification;
import org.apache.flink.runtime.rest.handler.legacy.files.WebContentHandlerSpecification;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.taskmanager.TaskManagerDetailsHandler;
import org.apache.flink.runtime.rest.handler.taskmanager.TaskManagerLogFileHandler;
import org.apache.flink.runtime.rest.handler.taskmanager.TaskManagerStdoutFileHandler;
import org.apache.flink.runtime.rest.handler.taskmanager.TaskManagersHandler;
import org.apache.flink.runtime.rest.messages.ClusterConfigurationInfoHeaders;
import org.apache.flink.runtime.rest.messages.ClusterOverviewHeaders;
import org.apache.flink.runtime.rest.messages.DashboardConfigurationHeaders;
import org.apache.flink.runtime.rest.messages.JobAccumulatorsHeaders;
import org.apache.flink.runtime.rest.messages.JobCancellationHeaders;
import org.apache.flink.runtime.rest.messages.JobConfigHeaders;
import org.apache.flink.runtime.rest.messages.JobExceptionsHeaders;
import org.apache.flink.runtime.rest.messages.JobIdsWithStatusesOverviewHeaders;
import org.apache.flink.runtime.rest.messages.JobPlanHeaders;
import org.apache.flink.runtime.rest.messages.JobVertexAccumulatorsHeaders;
import org.apache.flink.runtime.rest.messages.JobVertexBackPressureHeaders;
import org.apache.flink.runtime.rest.messages.JobVertexDetailsHeaders;
import org.apache.flink.runtime.rest.messages.JobVertexTaskManagersHeaders;
import org.apache.flink.runtime.rest.messages.JobsOverviewHeaders;
import org.apache.flink.runtime.rest.messages.SubtasksAllAccumulatorsHeaders;
import org.apache.flink.runtime.rest.messages.SubtasksTimesHeaders;
import org.apache.flink.runtime.rest.messages.TerminationModeQueryParameter;
import org.apache.flink.runtime.rest.messages.YarnCancelJobTerminationHeaders;
import org.apache.flink.runtime.rest.messages.YarnStopJobTerminationHeaders;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointConfigHeaders;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointStatisticDetailsHeaders;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointingStatisticsHeaders;
import org.apache.flink.runtime.rest.messages.checkpoints.TaskCheckpointStatisticsHeaders;
import org.apache.flink.runtime.rest.messages.cluster.ShutdownHeaders;
import org.apache.flink.runtime.rest.messages.job.JobDetailsHeaders;
import org.apache.flink.runtime.rest.messages.job.SubtaskCurrentAttemptDetailsHeaders;
import org.apache.flink.runtime.rest.messages.job.SubtaskExecutionAttemptAccumulatorsHeaders;
import org.apache.flink.runtime.rest.messages.job.SubtaskExecutionAttemptDetailsHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerDetailsHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerLogFileHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerStdoutFileHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagersHeaders;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.WebMonitorUtils;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInboundHandler;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.ExecutorUtils;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.Preconditions;

public class WebMonitorEndpoint<T extends RestfulGateway>
extends RestServerEndpoint
implements LeaderContender,
JsonArchivist {
    protected final GatewayRetriever<? extends T> leaderRetriever;
    protected final Configuration clusterConfiguration;
    protected final RestHandlerConfiguration restConfiguration;
    private final GatewayRetriever<ResourceManagerGateway> resourceManagerRetriever;
    private final TransientBlobService transientBlobService;
    protected final ExecutorService executor;
    private final ExecutionGraphCache executionGraphCache;
    private final CheckpointStatsCache checkpointStatsCache;
    private final MetricFetcher metricFetcher;
    private final LeaderElectionService leaderElectionService;
    private final FatalErrorHandler fatalErrorHandler;
    private boolean hasWebUI = false;
    private final Collection<JsonArchivist> archivingHandlers = new ArrayList<JsonArchivist>(16);

    public WebMonitorEndpoint(RestServerEndpointConfiguration endpointConfiguration, GatewayRetriever<? extends T> leaderRetriever, Configuration clusterConfiguration, RestHandlerConfiguration restConfiguration, GatewayRetriever<ResourceManagerGateway> resourceManagerRetriever, TransientBlobService transientBlobService, ExecutorService executor, MetricFetcher metricFetcher, LeaderElectionService leaderElectionService, FatalErrorHandler fatalErrorHandler) throws IOException {
        super(endpointConfiguration);
        this.leaderRetriever = (GatewayRetriever)Preconditions.checkNotNull(leaderRetriever);
        this.clusterConfiguration = (Configuration)Preconditions.checkNotNull((Object)clusterConfiguration);
        this.restConfiguration = (RestHandlerConfiguration)Preconditions.checkNotNull((Object)restConfiguration);
        this.resourceManagerRetriever = (GatewayRetriever)Preconditions.checkNotNull(resourceManagerRetriever);
        this.transientBlobService = (TransientBlobService)Preconditions.checkNotNull((Object)transientBlobService);
        this.executor = (ExecutorService)Preconditions.checkNotNull((Object)executor);
        this.executionGraphCache = new ExecutionGraphCache(restConfiguration.getTimeout(), Time.milliseconds((long)restConfiguration.getRefreshInterval()));
        this.checkpointStatsCache = new CheckpointStatsCache(restConfiguration.getMaxCheckpointStatisticCacheEntries());
        this.metricFetcher = metricFetcher;
        this.leaderElectionService = (LeaderElectionService)Preconditions.checkNotNull((Object)leaderElectionService);
        this.fatalErrorHandler = (FatalErrorHandler)Preconditions.checkNotNull((Object)fatalErrorHandler);
    }

    @Override
    protected List<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> initializeHandlers(CompletableFuture<String> localAddressFuture) {
        Optional<StaticFileServerHandler<Object>> optWebContent;
        SavepointDisposalHandlers savepointDisposalHandlers;
        RescalingHandlers rescalingHandlers;
        SavepointHandlers savepointHandlers;
        ArrayList<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> handlers = new ArrayList<Tuple2<RestHandlerSpecification, ChannelInboundHandler>>(30);
        Time timeout = this.restConfiguration.getTimeout();
        ClusterOverviewHandler clusterOverviewHandler = new ClusterOverviewHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, ClusterOverviewHeaders.getInstance());
        DashboardConfigHandler dashboardConfigHandler = new DashboardConfigHandler(this.leaderRetriever, timeout, this.responseHeaders, DashboardConfigurationHeaders.getInstance(), this.restConfiguration.getRefreshInterval(), this.restConfiguration.isWebSubmitEnabled());
        JobIdsHandler jobIdsHandler = new JobIdsHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, JobIdsWithStatusesOverviewHeaders.getInstance());
        JobsOverviewHandler jobsOverviewHandler = new JobsOverviewHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, JobsOverviewHeaders.getInstance());
        ClusterConfigHandler clusterConfigurationHandler = new ClusterConfigHandler(this.leaderRetriever, timeout, this.responseHeaders, ClusterConfigurationInfoHeaders.getInstance(), this.clusterConfiguration);
        JobConfigHandler jobConfigHandler = new JobConfigHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, JobConfigHeaders.getInstance(), this.executionGraphCache, (Executor)this.executor);
        CheckpointConfigHandler checkpointConfigHandler = new CheckpointConfigHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, CheckpointConfigHeaders.getInstance(), this.executionGraphCache, (Executor)this.executor);
        CheckpointingStatisticsHandler checkpointStatisticsHandler = new CheckpointingStatisticsHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, CheckpointingStatisticsHeaders.getInstance(), this.executionGraphCache, (Executor)this.executor);
        CheckpointStatisticDetailsHandler checkpointStatisticDetailsHandler = new CheckpointStatisticDetailsHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, CheckpointStatisticDetailsHeaders.getInstance(), this.executionGraphCache, (Executor)this.executor, this.checkpointStatsCache);
        JobPlanHandler jobPlanHandler = new JobPlanHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, JobPlanHeaders.getInstance(), this.executionGraphCache, (Executor)this.executor);
        TaskCheckpointStatisticDetailsHandler taskCheckpointStatisticDetailsHandler = new TaskCheckpointStatisticDetailsHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, TaskCheckpointStatisticsHeaders.getInstance(), this.executionGraphCache, (Executor)this.executor, this.checkpointStatsCache);
        JobExceptionsHandler jobExceptionsHandler = new JobExceptionsHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, JobExceptionsHeaders.getInstance(), this.executionGraphCache, (Executor)this.executor);
        JobVertexAccumulatorsHandler jobVertexAccumulatorsHandler = new JobVertexAccumulatorsHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, JobVertexAccumulatorsHeaders.getInstance(), this.executionGraphCache, (Executor)this.executor);
        SubtasksAllAccumulatorsHandler subtasksAllAccumulatorsHandler = new SubtasksAllAccumulatorsHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, SubtasksAllAccumulatorsHeaders.getInstance(), this.executionGraphCache, (Executor)this.executor);
        TaskManagersHandler taskManagersHandler = new TaskManagersHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, TaskManagersHeaders.getInstance(), this.resourceManagerRetriever);
        TaskManagerDetailsHandler taskManagerDetailsHandler = new TaskManagerDetailsHandler(this.leaderRetriever, timeout, this.responseHeaders, TaskManagerDetailsHeaders.getInstance(), this.resourceManagerRetriever, this.metricFetcher);
        JobDetailsHandler jobDetailsHandler = new JobDetailsHandler(this.leaderRetriever, timeout, this.responseHeaders, JobDetailsHeaders.getInstance(), this.executionGraphCache, this.executor, this.metricFetcher);
        JobAccumulatorsHandler jobAccumulatorsHandler = new JobAccumulatorsHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, JobAccumulatorsHeaders.getInstance(), this.executionGraphCache, (Executor)this.executor);
        SubtasksTimesHandler subtasksTimesHandler = new SubtasksTimesHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, SubtasksTimesHeaders.getInstance(), this.executionGraphCache, (Executor)this.executor);
        JobVertexMetricsHandler jobVertexMetricsHandler = new JobVertexMetricsHandler(this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, this.metricFetcher);
        JobMetricsHandler jobMetricsHandler = new JobMetricsHandler(this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, this.metricFetcher);
        SubtaskMetricsHandler subtaskMetricsHandler = new SubtaskMetricsHandler(this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, this.metricFetcher);
        TaskManagerMetricsHandler taskManagerMetricsHandler = new TaskManagerMetricsHandler(this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, this.metricFetcher);
        JobManagerMetricsHandler jobManagerMetricsHandler = new JobManagerMetricsHandler(this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, this.metricFetcher);
        AggregatingTaskManagersMetricsHandler aggregatingTaskManagersMetricsHandler = new AggregatingTaskManagersMetricsHandler(this.leaderRetriever, timeout, this.responseHeaders, this.executor, this.metricFetcher);
        AggregatingJobsMetricsHandler aggregatingJobsMetricsHandler = new AggregatingJobsMetricsHandler(this.leaderRetriever, timeout, this.responseHeaders, this.executor, this.metricFetcher);
        AggregatingSubtasksMetricsHandler aggregatingSubtasksMetricsHandler = new AggregatingSubtasksMetricsHandler(this.leaderRetriever, timeout, this.responseHeaders, this.executor, this.metricFetcher);
        JobVertexTaskManagersHandler jobVertexTaskManagersHandler = new JobVertexTaskManagersHandler(this.leaderRetriever, timeout, this.responseHeaders, JobVertexTaskManagersHeaders.getInstance(), this.executionGraphCache, this.executor, this.metricFetcher);
        JobExecutionResultHandler jobExecutionResultHandler = new JobExecutionResultHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders);
        String defaultSavepointDir = this.clusterConfiguration.getString(CheckpointingOptions.SAVEPOINT_DIRECTORY);
        SavepointHandlers savepointHandlers2 = savepointHandlers = new SavepointHandlers(defaultSavepointDir);
        savepointHandlers2.getClass();
        SavepointHandlers.StopWithSavepointHandler stopWithSavepointHandler = savepointHandlers2.new SavepointHandlers.StopWithSavepointHandler(this.leaderRetriever, timeout, this.responseHeaders);
        SavepointHandlers savepointHandlers3 = savepointHandlers;
        savepointHandlers3.getClass();
        SavepointHandlers.SavepointTriggerHandler savepointTriggerHandler = savepointHandlers3.new SavepointHandlers.SavepointTriggerHandler(this.leaderRetriever, timeout, this.responseHeaders);
        SavepointHandlers savepointHandlers4 = savepointHandlers;
        savepointHandlers4.getClass();
        SavepointHandlers.SavepointStatusHandler savepointStatusHandler = savepointHandlers4.new SavepointHandlers.SavepointStatusHandler(this.leaderRetriever, timeout, this.responseHeaders);
        SubtaskExecutionAttemptDetailsHandler subtaskExecutionAttemptDetailsHandler = new SubtaskExecutionAttemptDetailsHandler(this.leaderRetriever, timeout, this.responseHeaders, SubtaskExecutionAttemptDetailsHeaders.getInstance(), this.executionGraphCache, this.executor, this.metricFetcher);
        SubtaskExecutionAttemptAccumulatorsHandler subtaskExecutionAttemptAccumulatorsHandler = new SubtaskExecutionAttemptAccumulatorsHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, SubtaskExecutionAttemptAccumulatorsHeaders.getInstance(), this.executionGraphCache, (Executor)this.executor);
        SubtaskCurrentAttemptDetailsHandler subtaskCurrentAttemptDetailsHandler = new SubtaskCurrentAttemptDetailsHandler(this.leaderRetriever, timeout, this.responseHeaders, SubtaskCurrentAttemptDetailsHeaders.getInstance(), this.executionGraphCache, this.executor, this.metricFetcher);
        RescalingHandlers rescalingHandlers2 = rescalingHandlers = new RescalingHandlers();
        rescalingHandlers2.getClass();
        RescalingHandlers.RescalingTriggerHandler rescalingTriggerHandler = rescalingHandlers2.new RescalingHandlers.RescalingTriggerHandler(this.leaderRetriever, timeout, this.responseHeaders);
        RescalingHandlers rescalingHandlers3 = rescalingHandlers;
        rescalingHandlers3.getClass();
        RescalingHandlers.RescalingStatusHandler rescalingStatusHandler = rescalingHandlers3.new RescalingHandlers.RescalingStatusHandler(this.leaderRetriever, timeout, this.responseHeaders);
        JobVertexBackPressureHandler jobVertexBackPressureHandler = new JobVertexBackPressureHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, JobVertexBackPressureHeaders.getInstance());
        JobCancellationHandler jobCancelTerminationHandler = new JobCancellationHandler(this.leaderRetriever, timeout, this.responseHeaders, JobCancellationHeaders.getInstance(), TerminationModeQueryParameter.TerminationMode.CANCEL);
        JobCancellationHandler jobStopTerminationHandler = new JobCancellationHandler(this.leaderRetriever, timeout, this.responseHeaders, JobCancellationHeaders.getInstance(), TerminationModeQueryParameter.TerminationMode.STOP);
        JobVertexDetailsHandler jobVertexDetailsHandler = new JobVertexDetailsHandler(this.leaderRetriever, timeout, this.responseHeaders, JobVertexDetailsHeaders.getInstance(), this.executionGraphCache, this.executor, this.metricFetcher);
        SavepointDisposalHandlers savepointDisposalHandlers2 = savepointDisposalHandlers = new SavepointDisposalHandlers();
        savepointDisposalHandlers2.getClass();
        SavepointDisposalHandlers.SavepointDisposalTriggerHandler savepointDisposalTriggerHandler = savepointDisposalHandlers2.new SavepointDisposalHandlers.SavepointDisposalTriggerHandler(this.leaderRetriever, timeout, this.responseHeaders);
        SavepointDisposalHandlers savepointDisposalHandlers3 = savepointDisposalHandlers;
        savepointDisposalHandlers3.getClass();
        SavepointDisposalHandlers.SavepointDisposalStatusHandler savepointDisposalStatusHandler = savepointDisposalHandlers3.new SavepointDisposalHandlers.SavepointDisposalStatusHandler(this.leaderRetriever, timeout, this.responseHeaders);
        ShutdownHandler shutdownHandler = new ShutdownHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, ShutdownHeaders.getInstance());
        File webUiDir = this.restConfiguration.getWebUiDir();
        try {
            optWebContent = WebMonitorUtils.tryLoadWebContent(this.leaderRetriever, timeout, webUiDir);
        }
        catch (IOException e) {
            this.log.warn("Could not load web content handler.", (Throwable)e);
            optWebContent = Optional.empty();
        }
        handlers.add(Tuple2.of(clusterOverviewHandler.getMessageHeaders(), (Object)((Object)clusterOverviewHandler)));
        handlers.add(Tuple2.of(clusterConfigurationHandler.getMessageHeaders(), (Object)((Object)clusterConfigurationHandler)));
        handlers.add(Tuple2.of(dashboardConfigHandler.getMessageHeaders(), (Object)((Object)dashboardConfigHandler)));
        handlers.add(Tuple2.of(jobIdsHandler.getMessageHeaders(), (Object)((Object)jobIdsHandler)));
        handlers.add(Tuple2.of(jobsOverviewHandler.getMessageHeaders(), (Object)jobsOverviewHandler));
        handlers.add(Tuple2.of(jobConfigHandler.getMessageHeaders(), (Object)jobConfigHandler));
        handlers.add(Tuple2.of(checkpointConfigHandler.getMessageHeaders(), (Object)checkpointConfigHandler));
        handlers.add(Tuple2.of(checkpointStatisticsHandler.getMessageHeaders(), (Object)checkpointStatisticsHandler));
        handlers.add(Tuple2.of(checkpointStatisticDetailsHandler.getMessageHeaders(), (Object)checkpointStatisticDetailsHandler));
        handlers.add(Tuple2.of(jobPlanHandler.getMessageHeaders(), (Object)jobPlanHandler));
        handlers.add(Tuple2.of(taskCheckpointStatisticDetailsHandler.getMessageHeaders(), (Object)taskCheckpointStatisticDetailsHandler));
        handlers.add(Tuple2.of(jobExceptionsHandler.getMessageHeaders(), (Object)jobExceptionsHandler));
        handlers.add(Tuple2.of(jobVertexAccumulatorsHandler.getMessageHeaders(), (Object)((Object)jobVertexAccumulatorsHandler)));
        handlers.add(Tuple2.of(subtasksAllAccumulatorsHandler.getMessageHeaders(), (Object)((Object)subtasksAllAccumulatorsHandler)));
        handlers.add(Tuple2.of(jobDetailsHandler.getMessageHeaders(), (Object)jobDetailsHandler));
        handlers.add(Tuple2.of(jobAccumulatorsHandler.getMessageHeaders(), (Object)jobAccumulatorsHandler));
        handlers.add(Tuple2.of(taskManagersHandler.getMessageHeaders(), (Object)((Object)taskManagersHandler)));
        handlers.add(Tuple2.of(taskManagerDetailsHandler.getMessageHeaders(), (Object)((Object)taskManagerDetailsHandler)));
        handlers.add(Tuple2.of(subtasksTimesHandler.getMessageHeaders(), (Object)subtasksTimesHandler));
        handlers.add(Tuple2.of(jobVertexMetricsHandler.getMessageHeaders(), (Object)((Object)jobVertexMetricsHandler)));
        handlers.add(Tuple2.of(jobMetricsHandler.getMessageHeaders(), (Object)((Object)jobMetricsHandler)));
        handlers.add(Tuple2.of(subtaskMetricsHandler.getMessageHeaders(), (Object)((Object)subtaskMetricsHandler)));
        handlers.add(Tuple2.of(taskManagerMetricsHandler.getMessageHeaders(), (Object)((Object)taskManagerMetricsHandler)));
        handlers.add(Tuple2.of(jobManagerMetricsHandler.getMessageHeaders(), (Object)((Object)jobManagerMetricsHandler)));
        handlers.add(Tuple2.of(aggregatingTaskManagersMetricsHandler.getMessageHeaders(), (Object)((Object)aggregatingTaskManagersMetricsHandler)));
        handlers.add(Tuple2.of(aggregatingJobsMetricsHandler.getMessageHeaders(), (Object)((Object)aggregatingJobsMetricsHandler)));
        handlers.add(Tuple2.of(aggregatingSubtasksMetricsHandler.getMessageHeaders(), (Object)((Object)aggregatingSubtasksMetricsHandler)));
        handlers.add(Tuple2.of(jobExecutionResultHandler.getMessageHeaders(), (Object)((Object)jobExecutionResultHandler)));
        handlers.add(Tuple2.of(savepointTriggerHandler.getMessageHeaders(), (Object)((Object)savepointTriggerHandler)));
        handlers.add(Tuple2.of(stopWithSavepointHandler.getMessageHeaders(), (Object)((Object)stopWithSavepointHandler)));
        handlers.add(Tuple2.of(savepointStatusHandler.getMessageHeaders(), (Object)((Object)savepointStatusHandler)));
        handlers.add(Tuple2.of(subtaskExecutionAttemptDetailsHandler.getMessageHeaders(), (Object)subtaskExecutionAttemptDetailsHandler));
        handlers.add(Tuple2.of(subtaskExecutionAttemptAccumulatorsHandler.getMessageHeaders(), (Object)subtaskExecutionAttemptAccumulatorsHandler));
        handlers.add(Tuple2.of(subtaskCurrentAttemptDetailsHandler.getMessageHeaders(), (Object)((Object)subtaskCurrentAttemptDetailsHandler)));
        handlers.add(Tuple2.of(jobVertexTaskManagersHandler.getMessageHeaders(), (Object)jobVertexTaskManagersHandler));
        handlers.add(Tuple2.of(jobVertexBackPressureHandler.getMessageHeaders(), (Object)((Object)jobVertexBackPressureHandler)));
        handlers.add(Tuple2.of(jobCancelTerminationHandler.getMessageHeaders(), (Object)((Object)jobCancelTerminationHandler)));
        handlers.add(Tuple2.of(jobVertexDetailsHandler.getMessageHeaders(), (Object)jobVertexDetailsHandler));
        handlers.add(Tuple2.of(rescalingTriggerHandler.getMessageHeaders(), (Object)((Object)rescalingTriggerHandler)));
        handlers.add(Tuple2.of(rescalingStatusHandler.getMessageHeaders(), (Object)((Object)rescalingStatusHandler)));
        handlers.add(Tuple2.of(savepointDisposalTriggerHandler.getMessageHeaders(), (Object)((Object)savepointDisposalTriggerHandler)));
        handlers.add(Tuple2.of(savepointDisposalStatusHandler.getMessageHeaders(), (Object)((Object)savepointDisposalStatusHandler)));
        handlers.add(Tuple2.of((Object)YarnCancelJobTerminationHeaders.getInstance(), (Object)((Object)jobCancelTerminationHandler)));
        handlers.add(Tuple2.of((Object)YarnStopJobTerminationHeaders.getInstance(), (Object)((Object)jobStopTerminationHandler)));
        handlers.add(Tuple2.of(shutdownHandler.getMessageHeaders(), (Object)((Object)shutdownHandler)));
        optWebContent.ifPresent(webContent -> {
            handlers.add(Tuple2.of((Object)WebContentHandlerSpecification.getInstance(), (Object)webContent));
            this.hasWebUI = true;
        });
        WebMonitorUtils.LogFileLocation logFileLocation = WebMonitorUtils.LogFileLocation.find(this.clusterConfiguration);
        ChannelInboundHandler logFileHandler = this.createStaticFileHandler(timeout, logFileLocation.logFile);
        ChannelInboundHandler stdoutFileHandler = this.createStaticFileHandler(timeout, logFileLocation.stdOutFile);
        handlers.add(Tuple2.of((Object)LogFileHandlerSpecification.getInstance(), (Object)logFileHandler));
        handlers.add(Tuple2.of((Object)StdoutFileHandlerSpecification.getInstance(), (Object)stdoutFileHandler));
        Time cacheEntryDuration = Time.milliseconds((long)this.restConfiguration.getRefreshInterval());
        TaskManagerLogFileHandler taskManagerLogFileHandler = new TaskManagerLogFileHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, TaskManagerLogFileHeaders.getInstance(), this.resourceManagerRetriever, this.transientBlobService, cacheEntryDuration);
        TaskManagerStdoutFileHandler taskManagerStdoutFileHandler = new TaskManagerStdoutFileHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, TaskManagerStdoutFileHeaders.getInstance(), this.resourceManagerRetriever, this.transientBlobService, cacheEntryDuration);
        handlers.add(Tuple2.of((Object)TaskManagerLogFileHeaders.getInstance(), (Object)((Object)taskManagerLogFileHandler)));
        handlers.add(Tuple2.of((Object)TaskManagerStdoutFileHeaders.getInstance(), (Object)((Object)taskManagerStdoutFileHandler)));
        handlers.stream().map(tuple -> (ChannelInboundHandler)tuple.f1).filter(handler -> handler instanceof JsonArchivist).forEachOrdered(handler -> this.archivingHandlers.add((JsonArchivist)handler));
        return handlers;
    }

    @Nonnull
    private ChannelInboundHandler createStaticFileHandler(Time timeout, File fileToServe) {
        if (fileToServe == null) {
            return new ConstantTextHandler("(file unavailable)");
        }
        try {
            return new StaticFileServerHandler<T>(this.leaderRetriever, timeout, fileToServe);
        }
        catch (IOException e) {
            this.log.info("Cannot load log file handler.", (Throwable)e);
            return new ConstantTextHandler("(log file unavailable)");
        }
    }

    @Override
    public void startInternal() throws Exception {
        this.leaderElectionService.start(this);
        if (this.hasWebUI) {
            this.log.info("Web frontend listening at {}.", (Object)this.getRestBaseUrl());
        }
    }

    @Override
    protected CompletableFuture<Void> shutDownInternal() {
        this.executionGraphCache.close();
        CompletableFuture<Void> shutdownFuture = FutureUtils.runAfterwards(super.shutDownInternal(), () -> ExecutorUtils.gracefulShutdown((long)10L, (TimeUnit)TimeUnit.SECONDS, (ExecutorService[])new ExecutorService[]{this.executor}));
        File webUiDir = this.restConfiguration.getWebUiDir();
        return FutureUtils.runAfterwardsAsync(shutdownFuture, () -> {
            Exception exception = null;
            try {
                this.log.info("Removing cache directory {}", (Object)webUiDir);
                FileUtils.deleteDirectory((File)webUiDir);
            }
            catch (Exception e) {
                exception = e;
            }
            try {
                this.leaderElectionService.stop();
            }
            catch (Exception e) {
                exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
            }
            if (exception != null) {
                throw exception;
            }
        });
    }

    @Override
    public void grantLeadership(UUID leaderSessionID) {
        this.log.info("{} was granted leadership with leaderSessionID={}", (Object)this.getRestBaseUrl(), (Object)leaderSessionID);
        this.leaderElectionService.confirmLeaderSessionID(leaderSessionID);
    }

    @Override
    public void revokeLeadership() {
        this.log.info("{} lost leadership", (Object)this.getRestBaseUrl());
    }

    @Override
    public String getAddress() {
        return this.getRestBaseUrl();
    }

    @Override
    public void handleError(Exception exception) {
        this.fatalErrorHandler.onFatalError(exception);
    }

    @Override
    public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
        ArrayList<ArchivedJson> archivedJson = new ArrayList<ArchivedJson>(this.archivingHandlers.size());
        for (JsonArchivist archivist : this.archivingHandlers) {
            Collection<ArchivedJson> subArchive = archivist.archiveJsonWithPath(graph);
            archivedJson.addAll(subArchive);
        }
        return archivedJson;
    }

    public static ExecutorService createExecutorService(int numThreads, int threadPriority, String componentName) {
        if (threadPriority < 1 || threadPriority > 10) {
            throw new IllegalArgumentException(String.format("The thread priority must be within (%s, %s) but it was %s.", 1, 10, threadPriority));
        }
        return Executors.newFixedThreadPool(numThreads, new ExecutorThreadFactory.Builder().setThreadPriority(threadPriority).setPoolName("Flink-" + componentName).build());
    }
}

