/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.net.InetSocketAddress;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.flink.client.cli.AbstractCustomCommandLine;
import org.apache.flink.client.cli.CliFrontend;
import org.apache.flink.client.cli.DynamicPropertiesUtil;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.NetUtils;

public class DefaultCLI
extends AbstractCustomCommandLine {
    public static final String ID = "default";
    private static final Option addressOption = new Option("m", "jobmanager", true, "Address of the JobManager to which to connect. Use this flag to connect to a different JobManager than the one specified in the configuration. Attention: This option is respected only if the high-availability configuration is NONE.");

    @Override
    public boolean isActive(CommandLine commandLine) {
        return true;
    }

    @Override
    public Configuration toConfiguration(CommandLine commandLine) throws FlinkException {
        Configuration resultingConfiguration = super.toConfiguration(commandLine);
        if (commandLine.hasOption(addressOption.getOpt())) {
            String addressWithPort = commandLine.getOptionValue(addressOption.getOpt());
            InetSocketAddress jobManagerAddress = NetUtils.parseHostPortAddress(addressWithPort);
            CliFrontend.setJobManagerAddressInConfig(resultingConfiguration, jobManagerAddress);
        }
        resultingConfiguration.setString(DeploymentOptions.TARGET, "remote");
        DynamicPropertiesUtil.encodeDynamicProperties(commandLine, resultingConfiguration);
        return resultingConfiguration;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void addGeneralOptions(Options baseOptions) {
        super.addGeneralOptions(baseOptions);
        baseOptions.addOption(addressOption);
        baseOptions.addOption(DynamicPropertiesUtil.DYNAMIC_PROPERTIES);
    }
}

