/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.client.cli.ProgramOptions;
import org.apache.flink.configuration.ConfigUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.util.Preconditions;

@Internal
public class ExecutionConfigAccessor {
    private final Configuration configuration;

    private ExecutionConfigAccessor(Configuration configuration) {
        this.configuration = Preconditions.checkNotNull(configuration);
    }

    public static ExecutionConfigAccessor fromConfiguration(Configuration configuration) {
        return new ExecutionConfigAccessor(Preconditions.checkNotNull(configuration));
    }

    public static <T> ExecutionConfigAccessor fromProgramOptions(ProgramOptions options, List<T> jobJars) {
        Preconditions.checkNotNull(options);
        Preconditions.checkNotNull(jobJars);
        Configuration configuration = new Configuration();
        options.applyToConfiguration(configuration);
        ConfigUtils.encodeCollectionToConfig(configuration, PipelineOptions.JARS, jobJars, Object::toString);
        return new ExecutionConfigAccessor(configuration);
    }

    public Configuration applyToConfiguration(Configuration baseConfiguration) {
        baseConfiguration.addAll(this.configuration);
        return baseConfiguration;
    }

    public List<URL> getJars() throws MalformedURLException {
        return ConfigUtils.decodeListFromConfig(this.configuration, PipelineOptions.JARS, URL::new);
    }

    public List<URL> getClasspaths() throws MalformedURLException {
        return ConfigUtils.decodeListFromConfig(this.configuration, PipelineOptions.CLASSPATHS, URL::new);
    }

    public int getParallelism() {
        return this.configuration.getInteger(CoreOptions.DEFAULT_PARALLELISM);
    }

    public boolean getDetachedMode() {
        return !this.configuration.getBoolean(DeploymentOptions.ATTACHED);
    }

    public SavepointRestoreSettings getSavepointRestoreSettings() {
        return SavepointRestoreSettings.fromConfiguration(this.configuration);
    }

    public boolean isShutdownOnAttachedExit() {
        return this.configuration.getBoolean(DeploymentOptions.SHUTDOWN_IF_ATTACHED);
    }
}

