/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.flink.client.ClientUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;
import org.apache.flink.runtime.minicluster.MiniClusterJobClient;
import org.apache.flink.runtime.minicluster.RpcServiceSharing;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PerJobMiniClusterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PerJobMiniClusterFactory.class);
    private final Configuration configuration;
    private final Function<? super MiniClusterConfiguration, ? extends MiniCluster> miniClusterFactory;

    public static PerJobMiniClusterFactory create() {
        return new PerJobMiniClusterFactory(new Configuration(), MiniCluster::new);
    }

    public static PerJobMiniClusterFactory createWithFactory(Configuration configuration, Function<? super MiniClusterConfiguration, ? extends MiniCluster> miniClusterFactory) {
        return new PerJobMiniClusterFactory(configuration, miniClusterFactory);
    }

    private PerJobMiniClusterFactory(Configuration configuration, Function<? super MiniClusterConfiguration, ? extends MiniCluster> miniClusterFactory) {
        this.configuration = configuration;
        this.miniClusterFactory = miniClusterFactory;
    }

    public CompletableFuture<JobClient> submitJob(JobGraph jobGraph, ClassLoader userCodeClassloader) throws Exception {
        MiniClusterConfiguration miniClusterConfig = this.getMiniClusterConfig(jobGraph.getMaximumParallelism());
        MiniCluster miniCluster = this.miniClusterFactory.apply(miniClusterConfig);
        miniCluster.start();
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)miniCluster.submitJob(jobGraph).thenApplyAsync(FunctionUtils.uncheckedFunction(submissionResult -> {
            ClientUtils.waitUntilJobInitializationFinished(() -> miniCluster.getJobStatus(submissionResult.getJobID()).get(), () -> miniCluster.requestJobResult(submissionResult.getJobID()).get(), userCodeClassloader);
            return submissionResult;
        }))).thenApply(result -> new MiniClusterJobClient(result.getJobID(), miniCluster, userCodeClassloader, MiniClusterJobClient.JobFinalizationBehavior.SHUTDOWN_CLUSTER))).whenComplete((ignored, throwable) -> {
            if (throwable != null) {
                PerJobMiniClusterFactory.shutDownCluster(miniCluster);
            }
        })).thenApply(Function.identity());
    }

    private MiniClusterConfiguration getMiniClusterConfig(int maximumParallelism) {
        Configuration configuration = new Configuration(this.configuration);
        if (!configuration.contains(RestOptions.BIND_PORT)) {
            configuration.setString(RestOptions.BIND_PORT, "0");
        }
        int numTaskManagers = configuration.getInteger("local.number-taskmanager", 1);
        Map<String, String> overwriteParallelisms = configuration.get(PipelineOptions.PARALLELISM_OVERRIDES);
        if (overwriteParallelisms != null) {
            for (String overrideParallelism : overwriteParallelisms.values()) {
                maximumParallelism = Math.max(maximumParallelism, Integer.parseInt(overrideParallelism));
            }
        }
        int finalMaximumParallelism = maximumParallelism;
        int numSlotsPerTaskManager = configuration.getOptional(TaskManagerOptions.NUM_TASK_SLOTS).orElseGet(() -> finalMaximumParallelism > 0 ? Integer.valueOf(MathUtils.divideRoundUp(finalMaximumParallelism, numTaskManagers)) : TaskManagerOptions.NUM_TASK_SLOTS.defaultValue());
        return new MiniClusterConfiguration.Builder().setConfiguration(configuration).setNumTaskManagers(numTaskManagers).setRpcServiceSharing(RpcServiceSharing.SHARED).setNumSlotsPerTaskManager(numSlotsPerTaskManager).build();
    }

    private static void shutDownCluster(MiniCluster miniCluster) {
        miniCluster.closeAsync().whenComplete((ignored, throwable) -> {
            if (throwable != null) {
                LOG.warn("Shutdown of MiniCluster failed.", throwable);
            }
        });
    }
}

