/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.JobResultStore;
import org.apache.flink.runtime.jobmanager.JobGraphStore;
import org.apache.flink.runtime.leaderelection.DefaultLeaderElectionService;
import org.apache.flink.runtime.leaderelection.LeaderElection;
import org.apache.flink.runtime.leaderelection.LeaderElectionDriverFactory;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHaServices
implements HighAvailabilityServices {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Executor ioExecutor;
    protected final Configuration configuration;
    private final BlobStoreService blobStoreService;
    private final JobResultStore jobResultStore;
    private final DefaultLeaderElectionService leaderElectionService;

    protected AbstractHaServices(Configuration config, LeaderElectionDriverFactory driverFactory, Executor ioExecutor, BlobStoreService blobStoreService, JobResultStore jobResultStore) {
        this.configuration = Preconditions.checkNotNull(config);
        this.ioExecutor = Preconditions.checkNotNull(ioExecutor);
        this.blobStoreService = Preconditions.checkNotNull(blobStoreService);
        this.jobResultStore = Preconditions.checkNotNull(jobResultStore);
        this.leaderElectionService = new DefaultLeaderElectionService(driverFactory);
    }

    @Override
    public LeaderRetrievalService getResourceManagerLeaderRetriever() {
        return this.createLeaderRetrievalService(this.getLeaderPathForResourceManager());
    }

    @Override
    public LeaderRetrievalService getDispatcherLeaderRetriever() {
        return this.createLeaderRetrievalService(this.getLeaderPathForDispatcher());
    }

    @Override
    public LeaderRetrievalService getJobManagerLeaderRetriever(JobID jobID) {
        return this.createLeaderRetrievalService(this.getLeaderPathForJobManager(jobID));
    }

    @Override
    public LeaderRetrievalService getJobManagerLeaderRetriever(JobID jobID, String defaultJobManagerAddress) {
        return this.getJobManagerLeaderRetriever(jobID);
    }

    @Override
    public LeaderRetrievalService getClusterRestEndpointLeaderRetriever() {
        return this.createLeaderRetrievalService(this.getLeaderPathForRestServer());
    }

    @Override
    public LeaderElection getResourceManagerLeaderElection() {
        return this.leaderElectionService.createLeaderElection(this.getLeaderPathForResourceManager());
    }

    @Override
    public LeaderElection getDispatcherLeaderElection() {
        return this.leaderElectionService.createLeaderElection(this.getLeaderPathForDispatcher());
    }

    @Override
    public LeaderElection getJobManagerLeaderElection(JobID jobID) {
        return this.leaderElectionService.createLeaderElection(this.getLeaderPathForJobManager(jobID));
    }

    @Override
    public LeaderElection getClusterRestEndpointLeaderElection() {
        return this.leaderElectionService.createLeaderElection(this.getLeaderPathForRestServer());
    }

    @Override
    public CheckpointRecoveryFactory getCheckpointRecoveryFactory() throws Exception {
        return this.createCheckpointRecoveryFactory();
    }

    @Override
    public JobGraphStore getJobGraphStore() throws Exception {
        return this.createJobGraphStore();
    }

    @Override
    public JobResultStore getJobResultStore() throws Exception {
        return this.jobResultStore;
    }

    @Override
    public BlobStore createBlobStore() {
        return this.blobStoreService;
    }

    @Override
    public void close() throws Exception {
        Throwable exception = null;
        try {
            this.blobStoreService.close();
        }
        catch (Throwable t) {
            exception = t;
        }
        try {
            if (this.leaderElectionService != null) {
                this.leaderElectionService.close();
            }
        }
        catch (Throwable t) {
            exception = ExceptionUtils.firstOrSuppressed(t, exception);
        }
        try {
            this.internalClose();
        }
        catch (Throwable t) {
            exception = ExceptionUtils.firstOrSuppressed(t, exception);
        }
        if (exception != null) {
            ExceptionUtils.rethrowException(exception, "Could not properly close the " + this.getClass().getSimpleName());
        }
    }

    @Override
    public void closeAndCleanupAllData() throws Exception {
        this.logger.info("Close and clean up all data for {}.", (Object)this.getClass().getSimpleName());
        Exception exception = null;
        boolean deletedHAData = false;
        try {
            this.internalCleanup();
            deletedHAData = true;
        }
        catch (Exception t) {
            exception = t;
        }
        try {
            if (this.leaderElectionService != null) {
                this.leaderElectionService.close();
            }
        }
        catch (Throwable t) {
            exception = ExceptionUtils.firstOrSuppressed(t, exception);
        }
        try {
            this.internalClose();
        }
        catch (Throwable t) {
            exception = ExceptionUtils.firstOrSuppressed(t, exception);
        }
        try {
            if (deletedHAData) {
                this.blobStoreService.closeAndCleanupAllData();
            } else {
                this.logger.info("Cannot delete HA blobs because we failed to delete the pointers in the HA store.");
                this.blobStoreService.close();
            }
        }
        catch (Throwable t) {
            exception = ExceptionUtils.firstOrSuppressed(t, exception);
        }
        if (exception != null) {
            ExceptionUtils.rethrowException(exception, "Could not properly close and clean up all data of high availability service.");
        }
        this.logger.info("Finished cleaning up the high availability data.");
    }

    @Override
    public CompletableFuture<Void> globalCleanupAsync(JobID jobID, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            this.logger.info("Clean up the high availability data for job {}.", (Object)jobID);
            try {
                this.internalCleanupJobData(jobID);
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
            this.logger.info("Finished cleaning up the high availability data for job {}.", (Object)jobID);
        }, executor);
    }

    protected abstract LeaderRetrievalService createLeaderRetrievalService(String var1);

    protected abstract CheckpointRecoveryFactory createCheckpointRecoveryFactory() throws Exception;

    protected abstract JobGraphStore createJobGraphStore() throws Exception;

    protected abstract void internalClose() throws Exception;

    protected abstract void internalCleanup() throws Exception;

    protected abstract void internalCleanupJobData(JobID var1) throws Exception;

    protected abstract String getLeaderPathForResourceManager();

    protected abstract String getLeaderPathForDispatcher();

    protected abstract String getLeaderPathForJobManager(JobID var1);

    protected abstract String getLeaderPathForRestServer();
}

