/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage;

import java.util.LinkedList;
import javax.annotation.Nullable;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.partition.BufferWithChannel;
import org.apache.flink.runtime.io.network.partition.SortBuffer;
import org.apache.flink.util.Preconditions;

public class TieredStorageSortBuffer
extends SortBuffer {
    public TieredStorageSortBuffer(LinkedList<MemorySegment> freeSegments, BufferRecycler bufferRecycler, int numSubpartitions, int bufferSize, int numGuaranteedBuffers) {
        super(freeSegments, bufferRecycler, numSubpartitions, bufferSize, numGuaranteedBuffers, null);
    }

    @Override
    public BufferWithChannel getNextBuffer(@Nullable MemorySegment transitBuffer) {
        Preconditions.checkState(this.isFinished, "Sort buffer is not ready to be read.");
        Preconditions.checkState(!this.isReleased, "Sort buffer is already released.");
        if (!this.hasRemaining()) {
            this.freeSegments.add(transitBuffer);
            return null;
        }
        int numBytesRead = 0;
        Buffer.DataType bufferDataType = Buffer.DataType.DATA_BUFFER;
        int currentReadingSubpartitionId = this.subpartitionReadOrder[this.readOrderIndex];
        do {
            int toReadBufferIndex = this.getSegmentIndexFromPointer(this.readIndexEntryAddress);
            int toReadOffsetInBuffer = this.getSegmentOffsetFromPointer(this.readIndexEntryAddress);
            MemorySegment toReadBuffer = (MemorySegment)this.segments.get(toReadBufferIndex);
            long lengthAndDataType = toReadBuffer.getLong(toReadOffsetInBuffer);
            int recordLength = this.getSegmentIndexFromPointer(lengthAndDataType);
            Buffer.DataType dataType = Buffer.DataType.values()[this.getSegmentOffsetFromPointer(lengthAndDataType)];
            if (dataType.isEvent() && numBytesRead > 0) break;
            bufferDataType = dataType;
            long nextReadIndexEntryAddress = toReadBuffer.getLong(toReadOffsetInBuffer + 8);
            toReadOffsetInBuffer += 16;
            if (bufferDataType.isEvent()) {
                this.freeSegments.add(transitBuffer);
                transitBuffer = MemorySegmentFactory.allocateUnpooledSegment(recordLength);
            }
            numBytesRead += this.copyRecordOrEvent(transitBuffer, numBytesRead, toReadBufferIndex, toReadOffsetInBuffer, recordLength);
            if (this.recordRemainingBytes != 0) continue;
            if (this.readIndexEntryAddress == this.lastIndexEntryAddresses[currentReadingSubpartitionId]) {
                this.updateReadChannelAndIndexEntryAddress();
                break;
            }
            this.readIndexEntryAddress = nextReadIndexEntryAddress;
        } while (numBytesRead < transitBuffer.size() && bufferDataType.isBuffer());
        this.numTotalBytesRead += (long)numBytesRead;
        return new BufferWithChannel(new NetworkBuffer(transitBuffer, bufferDataType == Buffer.DataType.DATA_BUFFER ? this.bufferRecycler : FreeingBufferRecycler.INSTANCE, bufferDataType, numBytesRead), currentReadingSubpartitionId);
    }
}

