/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.exceptionhistory;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.failure.FailureEnricherUtils;
import org.apache.flink.runtime.scheduler.exceptionhistory.ExceptionHistoryEntry;
import org.apache.flink.runtime.scheduler.exceptionhistory.FailureHandlingResultSnapshot;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;

public class RootExceptionHistoryEntry
extends ExceptionHistoryEntry {
    private static final long serialVersionUID = -7647332765867297434L;
    private final Iterable<ExceptionHistoryEntry> concurrentExceptions;

    public static RootExceptionHistoryEntry fromFailureHandlingResultSnapshot(FailureHandlingResultSnapshot snapshot) {
        String failingTaskName = null;
        TaskManagerLocation taskManagerLocation = null;
        if (snapshot.getRootCauseExecution().isPresent()) {
            Execution rootCauseExecution = snapshot.getRootCauseExecution().get();
            failingTaskName = rootCauseExecution.getVertexWithAttempt();
            taskManagerLocation = rootCauseExecution.getAssignedResourceLocation();
        }
        return RootExceptionHistoryEntry.createRootExceptionHistoryEntry(snapshot.getRootCause(), snapshot.getTimestamp(), snapshot.getFailureLabels(), failingTaskName, taskManagerLocation, snapshot.getConcurrentlyFailedExecution());
    }

    public static RootExceptionHistoryEntry fromGlobalFailure(Throwable cause, long timestamp, CompletableFuture<Map<String, String>> failureLabels, Iterable<Execution> executions) {
        return RootExceptionHistoryEntry.createRootExceptionHistoryEntry(cause, timestamp, failureLabels, null, null, executions);
    }

    public static RootExceptionHistoryEntry fromExceptionHistoryEntry(ExceptionHistoryEntry entry, Iterable<ExceptionHistoryEntry> entries) {
        return new RootExceptionHistoryEntry(entry.getException(), entry.getTimestamp(), entry.getFailureLabelsFuture(), null, null, entries);
    }

    public static RootExceptionHistoryEntry fromGlobalFailure(ErrorInfo errorInfo) {
        Preconditions.checkNotNull(errorInfo, "errorInfo");
        return RootExceptionHistoryEntry.fromGlobalFailure(errorInfo.getException(), errorInfo.getTimestamp(), FailureEnricherUtils.EMPTY_FAILURE_LABELS, Collections.emptyList());
    }

    private static RootExceptionHistoryEntry createRootExceptionHistoryEntry(Throwable cause, long timestamp, CompletableFuture<Map<String, String>> failureLabels, @Nullable String failingTaskName, @Nullable TaskManagerLocation taskManagerLocation, Iterable<Execution> executions) {
        return new RootExceptionHistoryEntry(cause, timestamp, failureLabels, failingTaskName, taskManagerLocation, StreamSupport.stream(executions.spliterator(), false).filter(execution -> execution.getFailureInfo().isPresent()).map(execution -> ExceptionHistoryEntry.create(execution, execution.getVertexWithAttempt(), FailureEnricherUtils.EMPTY_FAILURE_LABELS)).collect(Collectors.toList()));
    }

    @VisibleForTesting
    public RootExceptionHistoryEntry(Throwable cause, long timestamp, CompletableFuture<Map<String, String>> failureLabels, @Nullable String failingTaskName, @Nullable TaskManagerLocation taskManagerLocation, Iterable<ExceptionHistoryEntry> concurrentExceptions) {
        super(cause, timestamp, failureLabels, failingTaskName, taskManagerLocation);
        this.concurrentExceptions = concurrentExceptions;
    }

    public Iterable<ExceptionHistoryEntry> getConcurrentExceptions() {
        return this.concurrentExceptions;
    }
}

