/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.state.CheckpointBoundKeyedStateHandle;
import org.apache.flink.runtime.state.IncrementalKeyedStateHandle;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.SharedStateRegistryKey;
import org.apache.flink.runtime.state.StateHandleID;
import org.apache.flink.runtime.state.StateUtil;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalRemoteKeyedStateHandle
implements IncrementalKeyedStateHandle {
    public static final long UNKNOWN_CHECKPOINTED_SIZE = -1L;
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalRemoteKeyedStateHandle.class);
    private static final long serialVersionUID = -8328808513197388231L;
    private final UUID backendIdentifier;
    private final KeyGroupRange keyGroupRange;
    private final long checkpointId;
    private final List<IncrementalKeyedStateHandle.HandleAndLocalPath> sharedState;
    private final List<IncrementalKeyedStateHandle.HandleAndLocalPath> privateState;
    private final StreamStateHandle metaStateHandle;
    private final long persistedSizeOfThisCheckpoint;
    private final StateHandleID stateHandleId;
    private transient SharedStateRegistry sharedStateRegistry;

    @VisibleForTesting
    public IncrementalRemoteKeyedStateHandle(UUID backendIdentifier, KeyGroupRange keyGroupRange, long checkpointId, List<IncrementalKeyedStateHandle.HandleAndLocalPath> sharedState, List<IncrementalKeyedStateHandle.HandleAndLocalPath> privateState, StreamStateHandle metaStateHandle) {
        this(backendIdentifier, keyGroupRange, checkpointId, sharedState, privateState, metaStateHandle, -1L, new StateHandleID(UUID.randomUUID().toString()));
    }

    public IncrementalRemoteKeyedStateHandle(UUID backendIdentifier, KeyGroupRange keyGroupRange, long checkpointId, List<IncrementalKeyedStateHandle.HandleAndLocalPath> sharedState, List<IncrementalKeyedStateHandle.HandleAndLocalPath> privateState, StreamStateHandle metaStateHandle, long persistedSizeOfThisCheckpoint) {
        this(backendIdentifier, keyGroupRange, checkpointId, sharedState, privateState, metaStateHandle, persistedSizeOfThisCheckpoint, new StateHandleID(UUID.randomUUID().toString()));
    }

    protected IncrementalRemoteKeyedStateHandle(UUID backendIdentifier, KeyGroupRange keyGroupRange, long checkpointId, List<IncrementalKeyedStateHandle.HandleAndLocalPath> sharedState, List<IncrementalKeyedStateHandle.HandleAndLocalPath> privateState, StreamStateHandle metaStateHandle, long persistedSizeOfThisCheckpoint, StateHandleID stateHandleId) {
        this.backendIdentifier = Preconditions.checkNotNull(backendIdentifier);
        this.keyGroupRange = Preconditions.checkNotNull(keyGroupRange);
        this.checkpointId = checkpointId;
        this.sharedState = Preconditions.checkNotNull(sharedState);
        this.privateState = Preconditions.checkNotNull(privateState);
        this.metaStateHandle = Preconditions.checkNotNull(metaStateHandle);
        this.sharedStateRegistry = null;
        this.persistedSizeOfThisCheckpoint = persistedSizeOfThisCheckpoint == -1L ? this.getStateSize() : persistedSizeOfThisCheckpoint;
        this.stateHandleId = stateHandleId;
    }

    public static IncrementalRemoteKeyedStateHandle restore(UUID backendIdentifier, KeyGroupRange keyGroupRange, long checkpointId, List<IncrementalKeyedStateHandle.HandleAndLocalPath> sharedState, List<IncrementalKeyedStateHandle.HandleAndLocalPath> privateState, StreamStateHandle metaStateHandle, long persistedSizeOfThisCheckpoint, StateHandleID stateHandleId) {
        return new IncrementalRemoteKeyedStateHandle(backendIdentifier, keyGroupRange, checkpointId, sharedState, privateState, metaStateHandle, persistedSizeOfThisCheckpoint, stateHandleId);
    }

    @Override
    public KeyGroupRange getKeyGroupRange() {
        return this.keyGroupRange;
    }

    @Override
    public long getCheckpointId() {
        return this.checkpointId;
    }

    @Override
    public CheckpointBoundKeyedStateHandle rebound(long checkpointId) {
        return new IncrementalRemoteKeyedStateHandle(this.backendIdentifier, this.keyGroupRange, checkpointId, this.sharedState, this.privateState, this.metaStateHandle, this.persistedSizeOfThisCheckpoint, this.stateHandleId);
    }

    public List<IncrementalKeyedStateHandle.HandleAndLocalPath> getSharedState() {
        return this.sharedState;
    }

    public List<IncrementalKeyedStateHandle.HandleAndLocalPath> getPrivateState() {
        return this.privateState;
    }

    public StreamStateHandle getMetaStateHandle() {
        return this.metaStateHandle;
    }

    @Override
    @Nonnull
    public UUID getBackendIdentifier() {
        return this.backendIdentifier;
    }

    @Override
    @Nonnull
    public List<IncrementalKeyedStateHandle.HandleAndLocalPath> getSharedStateHandles() {
        return this.getSharedState();
    }

    public SharedStateRegistry getSharedStateRegistry() {
        return this.sharedStateRegistry;
    }

    @Override
    public KeyedStateHandle getIntersection(KeyGroupRange keyGroupRange) {
        return KeyGroupRange.EMPTY_KEY_GROUP_RANGE.equals(this.keyGroupRange.getIntersection(keyGroupRange)) ? null : this;
    }

    @Override
    public StateHandleID getStateHandleId() {
        return this.stateHandleId;
    }

    @Override
    public void discardState() throws Exception {
        SharedStateRegistry registry = this.sharedStateRegistry;
        boolean isRegistered = registry != null;
        LOG.trace("Discarding IncrementalRemoteKeyedStateHandle (registered = {}) for checkpoint {} from backend with id {}.", new Object[]{isRegistered, this.checkpointId, this.backendIdentifier});
        try {
            this.metaStateHandle.discardState();
        }
        catch (Exception e) {
            LOG.warn("Could not properly discard meta data.", (Throwable)e);
        }
        try {
            StateUtil.bestEffortDiscardAllStateObjects(this.privateState.stream().map(IncrementalKeyedStateHandle.HandleAndLocalPath::getHandle).collect(Collectors.toList()));
        }
        catch (Exception e) {
            LOG.warn("Could not properly discard misc file states.", (Throwable)e);
        }
        if (!isRegistered) {
            try {
                StateUtil.bestEffortDiscardAllStateObjects(this.sharedState.stream().map(IncrementalKeyedStateHandle.HandleAndLocalPath::getHandle).collect(Collectors.toList()));
            }
            catch (Exception e) {
                LOG.warn("Could not properly discard new sst file states.", (Throwable)e);
            }
        }
    }

    @Override
    public long getStateSize() {
        long size = StateUtil.getStateSize(this.metaStateHandle);
        for (IncrementalKeyedStateHandle.HandleAndLocalPath handleAndLocalPath : this.sharedState) {
            size += handleAndLocalPath.getStateSize();
        }
        for (IncrementalKeyedStateHandle.HandleAndLocalPath handleAndLocalPath : this.privateState) {
            size += handleAndLocalPath.getStateSize();
        }
        return size;
    }

    @Override
    public long getCheckpointedSize() {
        return this.persistedSizeOfThisCheckpoint;
    }

    @Override
    public void registerSharedStates(SharedStateRegistry stateRegistry, long checkpointID) {
        Preconditions.checkState(this.sharedStateRegistry != stateRegistry, "The state handle has already registered its shared states to the given registry.");
        this.sharedStateRegistry = Preconditions.checkNotNull(stateRegistry);
        LOG.trace("Registering IncrementalRemoteKeyedStateHandle for checkpoint {} from backend with id {}.", (Object)this.checkpointId, (Object)this.backendIdentifier);
        for (IncrementalKeyedStateHandle.HandleAndLocalPath handleAndLocalPath : this.sharedState) {
            StreamStateHandle reference = stateRegistry.registerReference(this.createSharedStateRegistryKey(handleAndLocalPath.getHandle()), handleAndLocalPath.getHandle(), checkpointID);
            handleAndLocalPath.replaceHandle(reference);
        }
    }

    @VisibleForTesting
    IncrementalRemoteKeyedStateHandle copy() {
        return new IncrementalRemoteKeyedStateHandle(this.backendIdentifier, this.keyGroupRange, this.checkpointId, this.sharedState, this.privateState, this.metaStateHandle, this.persistedSizeOfThisCheckpoint, this.stateHandleId);
    }

    @VisibleForTesting
    public SharedStateRegistryKey createSharedStateRegistryKey(StreamStateHandle handle) {
        String keyString = handle.getStreamStateHandleID().getKeyString();
        return new SharedStateRegistryKey(UUID.nameUUIDFromBytes(keyString.getBytes(StandardCharsets.UTF_8)).toString());
    }

    @VisibleForTesting
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncrementalRemoteKeyedStateHandle that = (IncrementalRemoteKeyedStateHandle)o;
        if (!this.getStateHandleId().equals(that.getStateHandleId())) {
            return false;
        }
        if (this.getCheckpointId() != that.getCheckpointId()) {
            return false;
        }
        if (!this.getBackendIdentifier().equals(that.getBackendIdentifier())) {
            return false;
        }
        if (!this.getKeyGroupRange().equals(that.getKeyGroupRange())) {
            return false;
        }
        if (!this.getSharedState().equals(that.getSharedState())) {
            return false;
        }
        if (!this.getPrivateState().equals(that.getPrivateState())) {
            return false;
        }
        return this.getMetaStateHandle().equals(that.getMetaStateHandle());
    }

    @VisibleForTesting
    public int hashCode() {
        int result = this.getBackendIdentifier().hashCode();
        result = 31 * result + this.getKeyGroupRange().hashCode();
        result = 31 * result + (int)(this.getCheckpointId() ^ this.getCheckpointId() >>> 32);
        result = 31 * result + this.getSharedState().hashCode();
        result = 31 * result + this.getPrivateState().hashCode();
        result = 31 * result + this.getMetaStateHandle().hashCode();
        result = 31 * result + this.getStateHandleId().hashCode();
        return result;
    }

    public String toString() {
        return "IncrementalRemoteKeyedStateHandle{backendIdentifier=" + this.backendIdentifier + ", stateHandleId=" + this.stateHandleId + ", keyGroupRange=" + this.keyGroupRange + ", checkpointId=" + this.checkpointId + ", sharedState=" + this.sharedState + ", privateState=" + this.privateState + ", metaStateHandle=" + this.metaStateHandle + ", registered=" + (this.sharedStateRegistry != null) + '}';
    }
}

