/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.catalog.CatalogStore;
import org.apache.flink.table.factories.CatalogStoreFactory;
import org.apache.flink.util.Preconditions;

@Internal
public class CatalogStoreHolder
implements AutoCloseable {
    private CatalogStore catalogStore;
    @Nullable
    private CatalogStoreFactory factory;
    private ReadableConfig config;
    private ClassLoader classLoader;

    private CatalogStoreHolder(CatalogStore catalogStore, @Nullable CatalogStoreFactory factory, ReadableConfig config, ClassLoader classLoader) {
        this.catalogStore = catalogStore;
        this.factory = factory;
        this.config = config;
        this.classLoader = classLoader;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public CatalogStore catalogStore() {
        return this.catalogStore;
    }

    public ReadableConfig config() {
        return this.config;
    }

    public ClassLoader classLoader() {
        return this.classLoader;
    }

    public void open() {
        this.catalogStore.open();
    }

    @Override
    public void close() throws Exception {
        this.catalogStore.close();
        if (this.factory != null) {
            this.factory.close();
        }
    }

    public static final class Builder {
        private CatalogStore catalogStore;
        private ReadableConfig config;
        @Nullable
        private ClassLoader classLoader;
        @Nullable
        private CatalogStoreFactory factory;

        public Builder catalogStore(CatalogStore catalogStore) {
            this.catalogStore = catalogStore;
            return this;
        }

        public Builder config(ReadableConfig config) {
            this.config = config;
            return this;
        }

        public Builder classloader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Builder factory(CatalogStoreFactory factory) {
            this.factory = factory;
            return this;
        }

        public CatalogStoreHolder build() {
            Preconditions.checkNotNull(this.catalogStore, "CatalogStore cannot be null");
            Preconditions.checkNotNull(this.config, "Config cannot be null");
            Preconditions.checkNotNull(this.classLoader, "Class loader cannot be null");
            return new CatalogStoreHolder(this.catalogStore, this.factory, this.config, this.classLoader);
        }
    }
}

