/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.serde;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonToRowDataConverters;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.gateway.rest.serde.ColumnInfo;
import org.apache.flink.table.gateway.rest.serde.ResultInfo;
import org.apache.flink.table.gateway.rest.util.RowFormat;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.CollectionUtil;

@Internal
public class ResultInfoDeserializer
extends StdDeserializer<ResultInfo> {
    private static final long serialVersionUID = 1L;
    private static final JsonToRowDataConverters TO_ROW_DATA_CONVERTERS = new JsonToRowDataConverters(false, false, TimestampFormat.ISO_8601);

    public ResultInfoDeserializer() {
        super(ResultInfo.class);
    }

    @Override
    public ResultInfo deserialize(JsonParser jsonParser, DeserializationContext ctx) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        List<Object> columnInfos = Arrays.asList((Object[])jsonParser.getCodec().treeToValue(node.get("columns"), ColumnInfo[].class));
        RowFormat rowFormat = RowFormat.valueOf(node.get("rowFormat").asText().toUpperCase());
        List<RowData> data = this.deserializeData((ArrayNode)node.get("data"), columnInfos, rowFormat);
        return new ResultInfo(columnInfos, data, rowFormat);
    }

    private List<RowData> deserializeData(ArrayNode serializedRows, List<ColumnInfo> columnInfos, RowFormat rowFormat) {
        List<JsonToRowDataConverters.JsonToRowDataConverter> converters = this.buildToRowDataConverters(columnInfos, rowFormat);
        ArrayList<RowData> data = new ArrayList<RowData>();
        serializedRows.forEach(rowDataNode -> data.add(this.convertToRowData((JsonNode)rowDataNode, converters)));
        return data;
    }

    private List<JsonToRowDataConverters.JsonToRowDataConverter> buildToRowDataConverters(List<ColumnInfo> columnInfos, RowFormat rowFormat) {
        if (rowFormat == RowFormat.JSON) {
            return columnInfos.stream().map(ColumnInfo::getLogicalType).map(TO_ROW_DATA_CONVERTERS::createConverter).collect(Collectors.toList());
        }
        if (rowFormat == RowFormat.PLAIN_TEXT) {
            return IntStream.range(0, columnInfos.size()).mapToObj(i -> jsonNode -> jsonNode.isNull() ? null : StringData.fromString(jsonNode.asText())).collect(Collectors.toList());
        }
        throw new UnsupportedOperationException(String.format("Unknown row format: %s.", new Object[]{rowFormat}));
    }

    private GenericRowData convertToRowData(JsonNode serializedRow, List<JsonToRowDataConverters.JsonToRowDataConverter> converters) {
        ArrayNode fieldsArrayNode = (ArrayNode)serializedRow.get("fields");
        List<JsonNode> fieldNodes = CollectionUtil.iteratorToList(fieldsArrayNode.iterator());
        return GenericRowData.ofKind(RowKind.valueOf(serializedRow.get("kind").asText()), IntStream.range(0, fieldNodes.size()).mapToObj(i -> ((JsonToRowDataConverters.JsonToRowDataConverter)converters.get(i)).convert((JsonNode)fieldNodes.get(i))).toArray());
    }
}

