/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.metrics.MinWatermarkGauge;
import org.apache.flink.streaming.runtime.metrics.WatermarkGauge;
import org.apache.flink.streaming.runtime.tasks.StreamTask;

@Internal
public abstract class AbstractTwoInputStreamTask<IN1, IN2, OUT>
extends StreamTask<OUT, TwoInputStreamOperator<IN1, IN2, OUT>> {
    protected final WatermarkGauge input1WatermarkGauge = new WatermarkGauge();
    protected final WatermarkGauge input2WatermarkGauge = new WatermarkGauge();
    protected final MinWatermarkGauge minInputWatermarkGauge = new MinWatermarkGauge(this.input1WatermarkGauge, this.input2WatermarkGauge);

    public AbstractTwoInputStreamTask(Environment env) {
        super(env);
    }

    @Override
    public void init() throws Exception {
        StreamConfig configuration = this.getConfiguration();
        ClassLoader userClassLoader = this.getUserCodeClassLoader();
        TypeSerializer inputDeserializer1 = configuration.getTypeSerializerIn1(userClassLoader);
        TypeSerializer inputDeserializer2 = configuration.getTypeSerializerIn2(userClassLoader);
        int numberOfInputs = configuration.getNumberOfInputs();
        ArrayList<InputGate> inputList1 = new ArrayList<InputGate>();
        ArrayList<InputGate> inputList2 = new ArrayList<InputGate>();
        List<StreamEdge> inEdges = configuration.getInPhysicalEdges(userClassLoader);
        block4: for (int i = 0; i < numberOfInputs; ++i) {
            int inputType = inEdges.get(i).getTypeNumber();
            InputGate reader = this.getEnvironment().getInputGate(i);
            switch (inputType) {
                case 1: {
                    inputList1.add(reader);
                    continue block4;
                }
                case 2: {
                    inputList2.add(reader);
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Invalid input type number: " + inputType);
                }
            }
        }
        this.createInputProcessor(inputList1, inputList2, inputDeserializer1, inputDeserializer2);
        ((TwoInputStreamOperator)this.headOperator).getMetricGroup().gauge("currentInputWatermark", (Gauge)this.minInputWatermarkGauge);
        ((TwoInputStreamOperator)this.headOperator).getMetricGroup().gauge("currentInput1Watermark", (Gauge)this.input1WatermarkGauge);
        ((TwoInputStreamOperator)this.headOperator).getMetricGroup().gauge("currentInput2Watermark", (Gauge)this.input2WatermarkGauge);
        this.getEnvironment().getMetricGroup().gauge("currentInputWatermark", this.minInputWatermarkGauge::getValue);
    }

    protected abstract void createInputProcessor(Collection<InputGate> var1, Collection<InputGate> var2, TypeSerializer<IN1> var3, TypeSerializer<IN2> var4) throws Exception;
}

