/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.agent.embedded;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.flume.Channel;
import org.apache.flume.ChannelException;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.FlumeException;
import org.apache.flume.SinkRunner;
import org.apache.flume.Source;
import org.apache.flume.SourceRunner;
import org.apache.flume.agent.embedded.EmbeddedAgentConfiguration;
import org.apache.flume.agent.embedded.EmbeddedSource;
import org.apache.flume.agent.embedded.MaterializedConfigurationProvider;
import org.apache.flume.annotations.InterfaceAudience;
import org.apache.flume.annotations.InterfaceStability;
import org.apache.flume.conf.LogPrivacyUtil;
import org.apache.flume.lifecycle.LifecycleAware;
import org.apache.flume.lifecycle.LifecycleState;
import org.apache.flume.lifecycle.LifecycleSupervisor;
import org.apache.flume.node.MaterializedConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class EmbeddedAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedAgent.class);
    private final MaterializedConfigurationProvider configurationProvider;
    private final String name;
    private final LifecycleSupervisor supervisor;
    private State state;
    private SourceRunner sourceRunner;
    private Channel channel;
    private SinkRunner sinkRunner;
    private EmbeddedSource embeddedSource;

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    EmbeddedAgent(MaterializedConfigurationProvider configurationProvider, String name) {
        this.configurationProvider = configurationProvider;
        this.name = name;
        this.state = State.NEW;
        this.supervisor = new LifecycleSupervisor();
    }

    public EmbeddedAgent(String name) {
        this(new MaterializedConfigurationProvider(), name);
    }

    public void configure(Map<String, String> properties) throws FlumeException {
        if (this.state == State.STARTED) {
            throw new IllegalStateException("Cannot be configured while started");
        }
        this.doConfigure(properties);
        this.state = State.STOPPED;
    }

    public void start() throws FlumeException {
        if (this.state == State.STARTED) {
            throw new IllegalStateException("Cannot be started while started");
        }
        if (this.state == State.NEW) {
            throw new IllegalStateException("Cannot be started before being configured");
        }
        Source source = (Source)Preconditions.checkNotNull((Object)this.sourceRunner.getSource(), (Object)"Source runner returned null source");
        if (!(source instanceof EmbeddedSource)) {
            throw new IllegalStateException("Unknown source type: " + source.getClass().getName());
        }
        this.embeddedSource = (EmbeddedSource)source;
        this.doStart();
        this.state = State.STARTED;
    }

    public void stop() throws FlumeException {
        if (this.state != State.STARTED) {
            throw new IllegalStateException("Cannot be stopped unless started");
        }
        this.supervisor.stop();
        this.embeddedSource = null;
        this.state = State.STOPPED;
    }

    private void doConfigure(Map<String, String> properties) {
        MaterializedConfiguration conf;
        ImmutableMap sources;
        properties = EmbeddedAgentConfiguration.configure(this.name, properties);
        if (LOGGER.isDebugEnabled() && LogPrivacyUtil.allowLogPrintConfig()) {
            LOGGER.debug("Agent configuration values");
            for (String key : new TreeSet<String>(properties.keySet())) {
                LOGGER.debug(key + " = " + properties.get(key));
            }
        }
        if ((sources = (conf = this.configurationProvider.get(this.name, properties)).getSourceRunners()).size() != 1) {
            throw new FlumeException("Expected one source and got " + sources.size());
        }
        ImmutableMap channels = conf.getChannels();
        if (channels.size() != 1) {
            throw new FlumeException("Expected one channel and got " + channels.size());
        }
        ImmutableMap sinks = conf.getSinkRunners();
        if (sinks.size() != 1) {
            throw new FlumeException("Expected one sink group and got " + sinks.size());
        }
        this.sourceRunner = (SourceRunner)sources.values().iterator().next();
        this.channel = (Channel)channels.values().iterator().next();
        this.sinkRunner = (SinkRunner)sinks.values().iterator().next();
    }

    public void put(Event event) throws EventDeliveryException {
        if (this.state != State.STARTED) {
            throw new IllegalStateException("Cannot put events unless started");
        }
        try {
            this.embeddedSource.put(event);
        }
        catch (ChannelException ex) {
            throw new EventDeliveryException("Embedded agent " + this.name + ": Unable to process event: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public void putAll(List<Event> events) throws EventDeliveryException {
        if (this.state != State.STARTED) {
            throw new IllegalStateException("Cannot put events unless started");
        }
        try {
            this.embeddedSource.putAll(events);
        }
        catch (ChannelException ex) {
            throw new EventDeliveryException("Embedded agent " + this.name + ": Unable to process event: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private void doStart() {
        boolean error = true;
        try {
            this.channel.start();
            this.sinkRunner.start();
            this.sourceRunner.start();
            this.supervisor.supervise((LifecycleAware)this.channel, (LifecycleSupervisor.SupervisorPolicy)new LifecycleSupervisor.SupervisorPolicy.AlwaysRestartPolicy(), LifecycleState.START);
            this.supervisor.supervise((LifecycleAware)this.sinkRunner, (LifecycleSupervisor.SupervisorPolicy)new LifecycleSupervisor.SupervisorPolicy.AlwaysRestartPolicy(), LifecycleState.START);
            this.supervisor.supervise((LifecycleAware)this.sourceRunner, (LifecycleSupervisor.SupervisorPolicy)new LifecycleSupervisor.SupervisorPolicy.AlwaysRestartPolicy(), LifecycleState.START);
            error = false;
        }
        finally {
            if (error) {
                this.stopLogError((LifecycleAware)this.sourceRunner);
                this.stopLogError((LifecycleAware)this.channel);
                this.stopLogError((LifecycleAware)this.sinkRunner);
                this.supervisor.stop();
            }
        }
    }

    private void stopLogError(LifecycleAware lifeCycleAware) {
        try {
            if (LifecycleState.START.equals((Object)lifeCycleAware.getLifecycleState())) {
                lifeCycleAware.stop();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Exception while stopping " + lifeCycleAware, (Throwable)e);
        }
    }

    private static enum State {
        NEW,
        STOPPED,
        STARTED;

    }
}

