/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal.data;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.management.remote.JMXConnector;
import org.apache.commons.collections.buffer.CircularFifoBuffer;
import org.apache.geode.tools.pulse.internal.data.Cluster;
import org.apache.geode.tools.pulse.internal.data.DataBrowser;
import org.apache.geode.tools.pulse.internal.data.IClusterUpdater;
import org.apache.geode.tools.pulse.internal.data.JMXDataUpdater;
import org.apache.geode.tools.pulse.internal.data.Repository;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Cluster
extends Thread {
    private static final int POLL_INTERVAL = 5000;
    public static final int MAX_SAMPLE_SIZE = 180;
    public static final int ALERTS_MAX_SIZE = 1000;
    public static final int PAGE_ALERTS_MAX_SIZE = 100;
    private static final Logger logger = LogManager.getLogger();
    private final ResourceBundle resourceBundle = Repository.get().getResourceBundle();
    private String jmxUserName;
    private String serverName;
    private String port;
    private JMXConnector jmxConnector;
    private int stale = 0;
    private double loadPerSec;
    private CountDownLatch clusterHasBeenInitialized;
    private IClusterUpdater updater = null;
    private DataBrowser dataBrowser = null;
    private int memberCount;
    private long clientConnectionCount;
    private int locatorCount;
    private int totalRegionCount;
    private long totalHeapSize = 0L;
    private long totalRegionEntryCount;
    private int currentQueryCount;
    private long totalBytesOnDisk;
    private double diskReadsRate;
    private double diskWritesRate;
    private double writePerSec;
    private double readPerSec;
    private double queriesPerSec;
    private int avgDiskStorage;
    private int avgDiskWritesRate;
    private int runningFunctionCount;
    private long registeredCQCount;
    private int subscriptionCount;
    private int serverCount;
    private int txnCommittedCount;
    private int txnRollbackCount;
    private long usedHeapSize = 0L;
    private long garbageCollectionCount = 0L;
    private int clusterId;
    private int notificationPageNumber = 1;
    private volatile boolean connectedFlag;
    private String connectionErrorMsg = "";
    private Set<String> deletedMembers = new HashSet();
    private Map<String, List<Member>> physicalToMember = new HashMap();
    private Map<String, Member> membersHMap = new HashMap();
    private Set<String> deletedRegions = new HashSet();
    private Map<String, Region> clusterRegionMap = new ConcurrentHashMap();
    private List<Alert> alertsList = new ArrayList();
    private CircularFifoBuffer totalBytesOnDiskTrend = new CircularFifoBuffer(180);
    private CircularFifoBuffer throughoutWritesTrend = new CircularFifoBuffer(180);
    private CircularFifoBuffer throughoutReadsTrend = new CircularFifoBuffer(180);
    private CircularFifoBuffer writePerSecTrend = new CircularFifoBuffer(180);
    private CircularFifoBuffer readPerSecTrend = new CircularFifoBuffer(180);
    private CircularFifoBuffer queriesPerSecTrend = new CircularFifoBuffer(180);
    private CircularFifoBuffer memoryUsageTrend = new CircularFifoBuffer(180);
    private CircularFifoBuffer garbageCollectionTrend = new CircularFifoBuffer(180);
    private long previousJVMPauseCount = 0L;
    private HashMap<String, Boolean> wanInformation = new HashMap();
    private Map<String, Statement> clusterStatementMap = new ConcurrentHashMap();
    public static final int CLUSTER_STAT_TOTAL_BYTES_ON_DISK = 0;
    public static final int CLUSTER_STAT_THROUGHPUT_WRITES = 1;
    public static final int CLUSTER_STAT_THROUGHPUT_READS = 2;
    public static final int CLUSTER_STAT_WRITES_PER_SECOND = 3;
    public static final int CLUSTER_STAT_READ_PER_SECOND = 4;
    public static final int CLUSTER_STAT_QUERIES_PER_SECOND = 5;
    public static final int CLUSTER_STAT_MEMORY_USAGE = 6;
    public static final int CLUSTER_STAT_GARBAGE_COLLECTION = 7;
    public static long LAST_UPDATE_TIME = 0L;
    private boolean stopUpdates = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getStatisticTrend(int trendId) {
        Object[] returnArray = null;
        switch (trendId) {
            case 0: {
                CircularFifoBuffer circularFifoBuffer = this.totalBytesOnDiskTrend;
                synchronized (circularFifoBuffer) {
                    returnArray = this.totalBytesOnDiskTrend.toArray();
                    break;
                }
            }
            case 2: {
                CircularFifoBuffer circularFifoBuffer = this.throughoutReadsTrend;
                synchronized (circularFifoBuffer) {
                    returnArray = this.throughoutReadsTrend.toArray();
                    break;
                }
            }
            case 1: {
                CircularFifoBuffer circularFifoBuffer = this.throughoutWritesTrend;
                synchronized (circularFifoBuffer) {
                    returnArray = this.throughoutWritesTrend.toArray();
                    break;
                }
            }
            case 3: {
                CircularFifoBuffer circularFifoBuffer = this.writePerSecTrend;
                synchronized (circularFifoBuffer) {
                    returnArray = this.writePerSecTrend.toArray();
                    break;
                }
            }
            case 4: {
                CircularFifoBuffer circularFifoBuffer = this.readPerSecTrend;
                synchronized (circularFifoBuffer) {
                    returnArray = this.readPerSecTrend.toArray();
                    break;
                }
            }
            case 5: {
                CircularFifoBuffer circularFifoBuffer = this.queriesPerSecTrend;
                synchronized (circularFifoBuffer) {
                    returnArray = this.queriesPerSecTrend.toArray();
                    break;
                }
            }
            case 6: {
                CircularFifoBuffer circularFifoBuffer = this.memoryUsageTrend;
                synchronized (circularFifoBuffer) {
                    returnArray = this.memoryUsageTrend.toArray();
                    break;
                }
            }
            case 7: {
                CircularFifoBuffer circularFifoBuffer = this.garbageCollectionTrend;
                synchronized (circularFifoBuffer) {
                    returnArray = this.garbageCollectionTrend.toArray();
                    break;
                }
            }
        }
        return returnArray;
    }

    public Cluster() {
    }

    public Cluster(String host, String port, String userName) {
        this.serverName = host;
        this.port = port;
        this.jmxUserName = userName;
        this.updater = new JMXDataUpdater(this.serverName, port, this);
        this.clusterHasBeenInitialized = new CountDownLatch(1);
        if (Boolean.getBoolean("pulse.embedded")) {
            this.setDaemon(true);
        }
    }

    public void waitForInitialization(long timeout, TimeUnit unit) throws InterruptedException {
        this.clusterHasBeenInitialized.await(timeout, unit);
    }

    @Override
    public void run() {
        try {
            while (!this.stopUpdates && this.isConnectedFlag()) {
                try {
                    this.stale = !this.updateData() ? ++this.stale : 0;
                }
                catch (Exception e) {
                    logger.info("Exception Occurred while updating cluster data : ", (Throwable)e);
                }
                this.clusterHasBeenInitialized.countDown();
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    logger.info("InterruptedException Occurred : ", (Throwable)e);
                }
            }
            logger.info("{} :: {}:{}", (Object)this.resourceBundle.getString("LOG_MSG_STOP_THREAD_UPDATES"), (Object)this.serverName, (Object)this.port);
        }
        finally {
            this.clusterHasBeenInitialized.countDown();
        }
    }

    private boolean updateData() {
        logger.debug("{} :: {}:{}", (Object)this.resourceBundle.getString("LOG_MSG_CLUSTER_DATA_IS_UPDATING"), (Object)this.serverName, (Object)this.port);
        return this.updater.updateData();
    }

    public void stopThread() {
        this.stopUpdates = true;
        try {
            this.join();
        }
        catch (InterruptedException e) {
            logger.info("InterruptedException occurred while stoping cluster thread : ", (Throwable)e);
        }
    }

    public Map<String, Member> getMembersHMap() {
        return this.membersHMap;
    }

    public void setMembersHMap(HashMap<String, Member> membersHMap) {
        this.membersHMap = membersHMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Boolean> getWanInformation() {
        Map wanMap = null;
        HashMap hashMap = this.wanInformation;
        synchronized (hashMap) {
            wanMap = (Map)this.wanInformation.clone();
        }
        return wanMap;
    }

    public Map<String, Boolean> getWanInformationObject() {
        return this.wanInformation;
    }

    public void setWanInformation(HashMap<String, Boolean> wanInformation) {
        this.wanInformation = wanInformation;
    }

    public String getJmxUserName() {
        return this.jmxUserName;
    }

    public String getConnectionErrorMsg() {
        return this.connectionErrorMsg;
    }

    public void setConnectionErrorMsg(String connectionErrorMsg) {
        this.connectionErrorMsg = connectionErrorMsg;
    }

    public String getServerName() {
        return this.serverName;
    }

    public boolean isConnectedFlag() {
        return this.connectedFlag;
    }

    public void setConnectedFlag(boolean connectedFlag) {
        this.connectedFlag = connectedFlag;
    }

    public String getPort() {
        return this.port;
    }

    public int getStale() {
        return this.stale;
    }

    public double getWritePerSec() {
        return this.writePerSec;
    }

    public void setWritePerSec(double writePerSec) {
        this.writePerSec = writePerSec;
    }

    public double getReadPerSec() {
        return this.readPerSec;
    }

    public void setReadPerSec(double readPerSec) {
        this.readPerSec = readPerSec;
    }

    public double getQueriesPerSec() {
        return this.queriesPerSec;
    }

    public void setQueriesPerSec(double queriesPerSec) {
        this.queriesPerSec = queriesPerSec;
    }

    public double getLoadPerSec() {
        return this.loadPerSec;
    }

    public void setLoadPerSec(double loadPerSec) {
        this.loadPerSec = loadPerSec;
    }

    public int getNotificationPageNumber() {
        return this.notificationPageNumber;
    }

    public void setNotificationPageNumber(int notificationPageNumber) {
        this.notificationPageNumber = notificationPageNumber;
    }

    public void setStale(int stale) {
        this.stale = stale;
    }

    public boolean isStopUpdates() {
        return this.stopUpdates;
    }

    public void setStopUpdates(boolean stopUpdates) {
        this.stopUpdates = stopUpdates;
    }

    public long getUsedHeapSize() {
        return this.usedHeapSize;
    }

    public void setUsedHeapSize(long usedHeapSize) {
        this.usedHeapSize = usedHeapSize;
    }

    public int getServerCount() {
        return this.serverCount;
    }

    public void setServerCount(int serverCount) {
        this.serverCount = serverCount;
    }

    public int getTxnCommittedCount() {
        return this.txnCommittedCount;
    }

    public void setTxnCommittedCount(int txnCommittedCount) {
        this.txnCommittedCount = txnCommittedCount;
    }

    public int getTxnRollbackCount() {
        return this.txnRollbackCount;
    }

    public void setTxnRollbackCount(int txnRollbackCount) {
        this.txnRollbackCount = txnRollbackCount;
    }

    public int getRunningFunctionCount() {
        return this.runningFunctionCount;
    }

    public long getRegisteredCQCount() {
        return this.registeredCQCount;
    }

    public int getSubscriptionCount() {
        return this.subscriptionCount;
    }

    public void setSubscriptionCount(int subscriptionCount) {
        this.subscriptionCount = subscriptionCount;
    }

    public void setRegisteredCQCount(long registeredCQCount) {
        this.registeredCQCount = registeredCQCount;
    }

    public void setRunningFunctionCount(int runningFunctionCount) {
        this.runningFunctionCount = runningFunctionCount;
    }

    public Map<String, Region> getClusterRegions() {
        return this.clusterRegionMap;
    }

    public Region getClusterRegion(String regionFullPath) {
        return (Region)this.clusterRegionMap.get(regionFullPath);
    }

    public void setClusterRegions(Map<String, Region> clusterRegionMap) {
        this.clusterRegionMap = clusterRegionMap;
    }

    public Map<String, Statement> getClusterStatements() {
        return this.clusterStatementMap;
    }

    public void setClusterStatements(Map<String, Statement> clusterStatementMap) {
        this.clusterStatementMap = clusterStatementMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Alert[] getAlertsList() {
        Alert[] list = null;
        List list2 = this.alertsList;
        synchronized (list2) {
            list = new Alert[this.alertsList.size()];
            list = this.alertsList.toArray(list);
        }
        return list;
    }

    public void setAlertsList(List<Alert> alertsList) {
        this.alertsList = alertsList;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public Set<String> getDeletedMembers() {
        return this.deletedMembers;
    }

    public void setDeletedMembers(Set<String> deletedMembers) {
        this.deletedMembers = deletedMembers;
    }

    public Set<String> getDeletedRegions() {
        return this.deletedRegions;
    }

    public void setDeletedRegions(Set<String> deletedRegions) {
        this.deletedRegions = deletedRegions;
    }

    public Map<String, List<Member>> getPhysicalToMember() {
        Map ptom = null;
        ptom = this.physicalToMember;
        return ptom;
    }

    public void setPhysicalToMember(HashMap<String, List<Member>> physicalToMember) {
        this.physicalToMember = physicalToMember;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public void setMemberCount(int memberCount) {
        this.memberCount = memberCount;
    }

    public long getClientConnectionCount() {
        return this.clientConnectionCount;
    }

    public void setClientConnectionCount(long clientConnectionCount) {
        this.clientConnectionCount = clientConnectionCount;
    }

    public int getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(int clusterId) {
        this.clusterId = clusterId;
    }

    public int getLocatorCount() {
        return this.locatorCount;
    }

    public void setLocatorCount(int locatorCount) {
        this.locatorCount = locatorCount;
    }

    public int getTotalRegionCount() {
        return this.totalRegionCount;
    }

    public void setTotalRegionCount(int totalRegionCount) {
        this.totalRegionCount = totalRegionCount;
    }

    public long getTotalHeapSize() {
        return this.totalHeapSize;
    }

    public void setTotalHeapSize(long totalHeapSize) {
        this.totalHeapSize = totalHeapSize;
    }

    public long getTotalRegionEntryCount() {
        return this.totalRegionEntryCount;
    }

    public void setTotalRegionEntryCount(long totalRegionEntryCount) {
        this.totalRegionEntryCount = totalRegionEntryCount;
    }

    public int getCurrentQueryCount() {
        return this.currentQueryCount;
    }

    public void setCurrentQueryCount(int currentQueryCount) {
        this.currentQueryCount = currentQueryCount;
    }

    public long getTotalBytesOnDisk() {
        return this.totalBytesOnDisk;
    }

    public void setTotalBytesOnDisk(long totalBytesOnDisk) {
        this.totalBytesOnDisk = totalBytesOnDisk;
    }

    public double getDiskReadsRate() {
        return this.diskReadsRate;
    }

    public void setDiskReadsRate(double diskReadsRate) {
        this.diskReadsRate = diskReadsRate;
    }

    public double getDiskWritesRate() {
        return this.diskWritesRate;
    }

    public void setDiskWritesRate(double diskWritesRate) {
        this.diskWritesRate = diskWritesRate;
    }

    public int getAvgDiskStorage() {
        return this.avgDiskStorage;
    }

    public void setAvgDiskStorage(int avgDiskStorage) {
        this.avgDiskStorage = avgDiskStorage;
    }

    public int getAvgDiskWritesRate() {
        return this.avgDiskWritesRate;
    }

    public void setAvgDiskWritesRate(int avgDiskWritesRate) {
        this.avgDiskWritesRate = avgDiskWritesRate;
    }

    public CircularFifoBuffer getWritePerSecTrend() {
        return this.writePerSecTrend;
    }

    public void setWritePerSecTrend(CircularFifoBuffer writePerSecTrend) {
        this.writePerSecTrend = writePerSecTrend;
    }

    public long getGarbageCollectionCount() {
        return this.garbageCollectionCount;
    }

    public void setGarbageCollectionCount(long garbageCollectionCount) {
        this.garbageCollectionCount = garbageCollectionCount;
    }

    public CircularFifoBuffer getTotalBytesOnDiskTrend() {
        return this.totalBytesOnDiskTrend;
    }

    public void setTotalBytesOnDiskTrend(CircularFifoBuffer totalBytesOnDiskTrend) {
        this.totalBytesOnDiskTrend = totalBytesOnDiskTrend;
    }

    public CircularFifoBuffer getThroughoutWritesTrend() {
        return this.throughoutWritesTrend;
    }

    public void setThroughoutWritesTrend(CircularFifoBuffer throughoutWritesTrend) {
        this.throughoutWritesTrend = throughoutWritesTrend;
    }

    public CircularFifoBuffer getThroughoutReadsTrend() {
        return this.throughoutReadsTrend;
    }

    public void setThroughoutReadsTrend(CircularFifoBuffer throughoutReadsTrend) {
        this.throughoutReadsTrend = throughoutReadsTrend;
    }

    public CircularFifoBuffer getReadPerSecTrend() {
        return this.readPerSecTrend;
    }

    public void setReadPerSecTrend(CircularFifoBuffer readPerSecTrend) {
        this.readPerSecTrend = readPerSecTrend;
    }

    public CircularFifoBuffer getQueriesPerSecTrend() {
        return this.queriesPerSecTrend;
    }

    public void setQueriesPerSecTrend(CircularFifoBuffer queriesPerSecTrend) {
        this.queriesPerSecTrend = queriesPerSecTrend;
    }

    public CircularFifoBuffer getMemoryUsageTrend() {
        return this.memoryUsageTrend;
    }

    public void setMemoryUsageTrend(CircularFifoBuffer memoryUsageTrend) {
        this.memoryUsageTrend = memoryUsageTrend;
    }

    public CircularFifoBuffer getGarbageCollectionTrend() {
        return this.garbageCollectionTrend;
    }

    public void setGarbageCollectionTrend(CircularFifoBuffer garbageCollectionSamples) {
        this.garbageCollectionTrend = garbageCollectionSamples;
    }

    public long getPreviousJVMPauseCount() {
        return this.previousJVMPauseCount;
    }

    public void setPreviousJVMPauseCount(long previousJVMPauseCount) {
        this.previousJVMPauseCount = previousJVMPauseCount;
    }

    public DataBrowser getDataBrowser() {
        if (this.dataBrowser == null) {
            this.dataBrowser = new DataBrowser();
        }
        return this.dataBrowser;
    }

    public void setDataBrowser(DataBrowser dataBrowser) {
        this.dataBrowser = dataBrowser;
    }

    public ObjectNode executeQuery(String queryText, String members, int limit) {
        return this.updater.executeQuery(queryText, members, limit);
    }

    public ArrayNode getQueryHistoryByUserId(String userId) {
        return this.getDataBrowser().getQueryHistoryByUserId(userId);
    }

    public boolean addQueryInHistory(String queryText, String userName) {
        return this.getDataBrowser().addQueryInHistory(queryText, userName);
    }

    public boolean deleteQueryById(String userId, String queryId) {
        return this.getDataBrowser().deleteQueryById(userId, queryId);
    }

    public void connectToGemFire(String password) {
        this.jmxConnector = this.updater.connect(this.getJmxUserName(), password);
        if (this.jmxConnector != null) {
            this.start();
            try {
                this.waitForInitialization(15L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public JMXConnector getJMXConnector() {
        return this.jmxConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAlerts(int alertType, boolean isClearAll) {
        ArrayList<Alert> toDelete = new ArrayList<Alert>();
        if (alertType == -1) {
            List list = this.alertsList;
            synchronized (list) {
                if (isClearAll) {
                    this.alertsList.clear();
                    this.setNotificationPageNumber(1);
                } else {
                    for (int i = 0; i < this.alertsList.size(); ++i) {
                        Alert alert = (Alert)this.alertsList.get(i);
                        if (!alert.isAcknowledged()) continue;
                        toDelete.add(alert);
                    }
                    this.alertsList.removeAll(toDelete);
                    toDelete.clear();
                }
            }
        }
        List list = this.alertsList;
        synchronized (list) {
            for (int i = 0; i < this.alertsList.size(); ++i) {
                Alert alert = (Alert)this.alertsList.get(i);
                if (alert.getSeverity() != alertType) continue;
                if (isClearAll) {
                    toDelete.add(alert);
                    continue;
                }
                if (!alert.isAcknowledged()) continue;
                toDelete.add(alert);
            }
            this.alertsList.removeAll(toDelete);
            toDelete.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeAlert(int alertId) {
        List list = this.alertsList;
        synchronized (list) {
            for (Alert alert : this.alertsList) {
                if (alert.getId() != alertId) continue;
                alert.setAcknowledged(true);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAlert(Alert alert) {
        List list = this.alertsList;
        synchronized (list) {
            this.alertsList.add(alert);
            if (this.alertsList.size() > 1000) {
                this.alertsList.remove(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Member getMember(String memberKey) {
        Member member = null;
        Map map = this.membersHMap;
        synchronized (map) {
            member = (Member)this.membersHMap.get(memberKey);
        }
        return member;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Member[] getMembers() {
        Member[] members = null;
        Map map = this.membersHMap;
        synchronized (map) {
            members = new Member[this.membersHMap.size()];
            members = this.membersHMap.values().toArray(members);
        }
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement[] getStatements() {
        Statement[] statements = null;
        Map map = this.clusterStatementMap;
        synchronized (map) {
            statements = new Statement[this.clusterStatementMap.size()];
            statements = this.clusterStatementMap.values().toArray(statements);
        }
        return statements;
    }

    public void removeClusterRegion(String regionFullPath) {
        this.clusterRegionMap.remove(regionFullPath);
    }

    public void addClusterRegion(String regionFullPath, Region region) {
        this.clusterRegionMap.put(regionFullPath, region);
    }

    public void removeClusterStatement(String name) {
        this.clusterStatementMap.remove(name);
    }

    public void addClusterStatement(String name, Statement stmt) {
        this.clusterStatementMap.put(name, stmt);
    }
}

