/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal.data;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.geode.tools.pulse.internal.data.Cluster;
import org.apache.geode.tools.pulse.internal.data.PulseConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class Repository {
    private static final Logger logger = LogManager.getLogger();
    private static Repository instance = new Repository();
    private HashMap<String, Cluster> clusterMap = new HashMap();
    private Boolean jmxUseLocator;
    private String host;
    private String port;
    private boolean useSSLLocator = false;
    private boolean useSSLManager = false;
    private Properties javaSslProperties;
    Locale locale = new Locale("en", "US");
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("LogMessages", this.locale);
    private PulseConfig pulseConfig = new PulseConfig();

    private Repository() {
    }

    public static Repository get() {
        return instance;
    }

    public Boolean getJmxUseLocator() {
        return this.jmxUseLocator;
    }

    public void setJmxUseLocator(Boolean jmxUseLocator) {
        this.jmxUseLocator = jmxUseLocator;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String jmxHost) {
        this.host = jmxHost;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String jmxPort) {
        this.port = jmxPort;
    }

    public boolean isUseSSLLocator() {
        return this.useSSLLocator;
    }

    public void setUseSSLLocator(boolean useSSLLocator) {
        this.useSSLLocator = useSSLLocator;
    }

    public boolean isUseSSLManager() {
        return this.useSSLManager;
    }

    public void setUseSSLManager(boolean useSSLManager) {
        this.useSSLManager = useSSLManager;
    }

    public PulseConfig getPulseConfig() {
        return this.pulseConfig;
    }

    public Properties getJavaSslProperties() {
        return this.javaSslProperties;
    }

    public void setJavaSslProperties(Properties javaSslProperties) {
        this.javaSslProperties = javaSslProperties;
    }

    public Cluster getCluster() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth == null) {
            return null;
        }
        return this.getCluster(auth.getName(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cluster getCluster(String username, String password) {
        HashMap hashMap = this.clusterMap;
        synchronized (hashMap) {
            Cluster data = (Cluster)this.clusterMap.get(username);
            if (data == null) {
                logger.info(this.resourceBundle.getString("LOG_MSG_CREATE_NEW_THREAD") + " : " + username);
                data = new Cluster(this.host, this.port, username);
                data.setName("PULSE-" + this.host + ":" + this.port + ":" + username);
                data.connectToGemFire(password);
                if (data.isConnectedFlag()) {
                    this.clusterMap.put(username, data);
                }
            }
            return data;
        }
    }

    public void logoutUser(String username) {
        Cluster data = (Cluster)this.clusterMap.remove(username);
        if (data != null) {
            try {
                data.setStopUpdates(true);
                data.getJMXConnector().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void removeAllClusters() {
        Iterator iter = this.clusterMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Cluster c = (Cluster)entry.getValue();
            String clusterKey = (String)entry.getKey();
            c.stopThread();
            iter.remove();
            logger.info("{} : {}", (Object)this.resourceBundle.getString("LOG_MSG_REMOVE_THREAD"), (Object)clusterKey);
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }
}

