/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.servlet.http.HttpServletRequest;
import org.apache.geode.tools.pulse.internal.data.Cluster;
import org.apache.geode.tools.pulse.internal.data.Repository;
import org.apache.geode.tools.pulse.internal.service.PulseService;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
@Service(value="MembersList")
@Scope(value="singleton")
public class MembersListService
implements PulseService {
    private final ObjectMapper mapper = new ObjectMapper();

    public ObjectNode execute(HttpServletRequest request) throws Exception {
        Cluster.Member[] memberSet;
        Cluster cluster = Repository.get().getCluster();
        ObjectNode responseJSON = this.mapper.createObjectNode();
        ArrayNode memberListJson = this.mapper.createArrayNode();
        for (Cluster.Member member : memberSet = cluster.getMembers()) {
            ObjectNode memberJSON = this.mapper.createObjectNode();
            memberJSON.put("memberId", member.getId());
            memberJSON.put("name", member.getName());
            memberJSON.put("host", member.getHost());
            memberListJson.add((JsonNode)memberJSON);
        }
        responseJSON.put("clusterMembers", (JsonNode)memberListJson);
        responseJSON.put("clusterName", cluster.getServerName());
        return responseJSON;
    }
}

