/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClient;
import org.apache.hadoop.hbase.replication.ReplicationStateZKBase;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.data.Stat;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

@InterfaceAudience.Private
public class ReplicationQueuesClientZKImpl
extends ReplicationStateZKBase
implements ReplicationQueuesClient {
    public ReplicationQueuesClientZKImpl(ZooKeeperWatcher zk, Configuration conf, Abortable abortable) {
        super(zk, conf, abortable);
    }

    @Override
    public void init() throws ReplicationException {
        try {
            ZKUtil.createWithParents(this.zookeeper, this.queuesZNode);
        }
        catch (KeeperException e) {
            throw new ReplicationException("Internal error while initializing a queues client", e);
        }
    }

    @Override
    public List<String> getListOfReplicators() throws KeeperException {
        return super.getListOfReplicatorsZK();
    }

    @Override
    public List<String> getLogsInQueue(String serverName, String queueId) throws KeeperException {
        String znode = ZKUtil.joinZNode(this.queuesZNode, serverName);
        znode = ZKUtil.joinZNode(znode, queueId);
        List<String> result = null;
        try {
            result = ZKUtil.listChildrenNoWatch(this.zookeeper, znode);
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed to get list of wals for queueId=" + queueId + " and serverName=" + serverName, e);
            throw e;
        }
        return result;
    }

    @Override
    public List<String> getAllQueues(String serverName) throws KeeperException {
        String znode = ZKUtil.joinZNode(this.queuesZNode, serverName);
        List<String> result = null;
        try {
            result = ZKUtil.listChildrenNoWatch(this.zookeeper, znode);
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed to get list of queues for serverName=" + serverName, e);
            throw e;
        }
        return result;
    }

    @Override
    public int getQueuesZNodeCversion() throws KeeperException {
        try {
            Stat stat = new Stat();
            ZKUtil.getDataNoWatch(this.zookeeper, this.queuesZNode, stat);
            return stat.getCversion();
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed to get stat of replication rs node", e);
            throw e;
        }
    }
}

