/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.com.jcraft.jsch.jce;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;

public class KeyPairGenDSA
implements org.apache.hadoop.hbase.shaded.com.jcraft.jsch.KeyPairGenDSA {
    byte[] x;
    byte[] y;
    byte[] p;
    byte[] q;
    byte[] g;

    public void init(int n) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DSA");
        keyPairGenerator.initialize(n, new SecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        this.x = ((DSAPrivateKey)privateKey).getX().toByteArray();
        this.y = ((DSAPublicKey)publicKey).getY().toByteArray();
        DSAParams dSAParams = ((DSAKey)((Object)privateKey)).getParams();
        this.p = dSAParams.getP().toByteArray();
        this.q = dSAParams.getQ().toByteArray();
        this.g = dSAParams.getG().toByteArray();
    }

    public byte[] getX() {
        return this.x;
    }

    public byte[] getY() {
        return this.y;
    }

    public byte[] getP() {
        return this.p;
    }

    public byte[] getQ() {
        return this.q;
    }

    public byte[] getG() {
        return this.g;
    }
}

