/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.codehaus.jackson.map.ext;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.apache.hadoop.hbase.shaded.org.codehaus.jackson.JsonGenerationException;
import org.apache.hadoop.hbase.shaded.org.codehaus.jackson.JsonGenerator;
import org.apache.hadoop.hbase.shaded.org.codehaus.jackson.JsonNode;
import org.apache.hadoop.hbase.shaded.org.codehaus.jackson.map.JsonMappingException;
import org.apache.hadoop.hbase.shaded.org.codehaus.jackson.map.JsonSerializer;
import org.apache.hadoop.hbase.shaded.org.codehaus.jackson.map.SerializerProvider;
import org.apache.hadoop.hbase.shaded.org.codehaus.jackson.map.ser.std.CalendarSerializer;
import org.apache.hadoop.hbase.shaded.org.codehaus.jackson.map.ser.std.SerializerBase;
import org.apache.hadoop.hbase.shaded.org.codehaus.jackson.map.ser.std.ToStringSerializer;
import org.apache.hadoop.hbase.shaded.org.codehaus.jackson.map.util.Provider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreXMLSerializers
implements Provider<Map.Entry<Class<?>, JsonSerializer<?>>> {
    static final HashMap<Class<?>, JsonSerializer<?>> _serializers = new HashMap();

    @Override
    public Collection<Map.Entry<Class<?>, JsonSerializer<?>>> provide() {
        return _serializers.entrySet();
    }

    static {
        ToStringSerializer tss = ToStringSerializer.instance;
        _serializers.put(Duration.class, tss);
        _serializers.put(XMLGregorianCalendar.class, new XMLGregorianCalendarSerializer());
        _serializers.put(QName.class, tss);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XMLGregorianCalendarSerializer
    extends SerializerBase<XMLGregorianCalendar> {
        public XMLGregorianCalendarSerializer() {
            super(XMLGregorianCalendar.class);
        }

        @Override
        public void serialize(XMLGregorianCalendar value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            CalendarSerializer.instance.serialize(value.toGregorianCalendar(), jgen, provider);
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
            return CalendarSerializer.instance.getSchema(provider, typeHint);
        }
    }
}

