/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.hbase.shaded.org.apache.http.NameValuePair;
import org.apache.hadoop.hbase.shaded.org.apache.http.client.utils.URLEncodedUtils;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationHandler;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;

public class PseudoAuthenticationHandler
implements AuthenticationHandler {
    public static final String TYPE = "simple";
    public static final String ANONYMOUS_ALLOWED = "simple.anonymous.allowed";
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private boolean acceptAnonymous;

    @Override
    public void init(Properties config) throws ServletException {
        this.acceptAnonymous = Boolean.parseBoolean(config.getProperty(ANONYMOUS_ALLOWED, "false"));
    }

    protected boolean getAcceptAnonymous() {
        return this.acceptAnonymous;
    }

    @Override
    public void destroy() {
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean managementOperation(AuthenticationToken token, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        return true;
    }

    private String getUserName(HttpServletRequest request) {
        List<NameValuePair> list = URLEncodedUtils.parse(request.getQueryString(), UTF8_CHARSET);
        if (list != null) {
            for (NameValuePair nv : list) {
                if (!"user.name".equals(nv.getName())) continue;
                return nv.getValue();
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AuthenticationToken authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        String userName = this.getUserName(request);
        if (userName != null) return new AuthenticationToken(userName, userName, this.getType());
        if (!this.getAcceptAnonymous()) throw new AuthenticationException("Anonymous requests are disallowed");
        return AuthenticationToken.ANONYMOUS;
    }
}

