/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security.client;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class TimelineDelegationTokenSelector
implements TokenSelector<TimelineDelegationTokenIdentifier> {
    private static final Log LOG = LogFactory.getLog(TimelineDelegationTokenSelector.class);

    @Override
    public Token<TimelineDelegationTokenIdentifier> selectToken(Text service, Collection<Token<? extends TokenIdentifier>> tokens) {
        if (service == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Looking for a token with service " + service.toString()));
        }
        for (Token<? extends TokenIdentifier> token : tokens) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Token kind is " + token.getKind().toString() + " and the token's service name is " + token.getService()));
            }
            if (!TimelineDelegationTokenIdentifier.KIND_NAME.equals(token.getKind()) || !service.equals(token.getService())) continue;
            return token;
        }
        return null;
    }
}

