/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.metrics.Interns;
import org.apache.hadoop.hbase.regionserver.MetricsTableAggregateSource;
import org.apache.hadoop.hbase.regionserver.MetricsTableAggregateSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsTableSource;
import org.apache.hadoop.hbase.regionserver.MetricsTableWrapperAggregate;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.DynamicMetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MetricsTableSourceImpl
implements MetricsTableSource {
    private static final String _COLUMNFAMILY = "_columnfamily_";
    private static final Logger LOG = LoggerFactory.getLogger(MetricsTableSourceImpl.class);
    private AtomicBoolean closed = new AtomicBoolean(false);
    private MetricsTableWrapperAggregate tableWrapperAgg;
    private final MetricsTableAggregateSourceImpl agg;
    private final DynamicMetricsRegistry registry;
    private final String tableNamePrefix;
    private final String tableNamePrefixPart1;
    private final String tableNamePrefixPart2;
    private final TableName tableName;
    private final int hashCode;
    private MutableFastCounter splitRequest;
    private MutableFastCounter splitSuccess;
    private MetricHistogram splitTimeHisto;
    private MetricHistogram flushTimeHisto;
    private MetricHistogram flushMemstoreSizeHisto;
    private MetricHistogram flushOutputSizeHisto;
    private MutableFastCounter flushedMemstoreBytes;
    private MutableFastCounter flushedOutputBytes;
    private MetricHistogram compactionTimeHisto;
    private MetricHistogram compactionInputFileCountHisto;
    private MetricHistogram compactionInputSizeHisto;
    private MetricHistogram compactionOutputFileCountHisto;
    private MetricHistogram compactionOutputSizeHisto;
    private MutableFastCounter compactedInputBytes;
    private MutableFastCounter compactedOutputBytes;
    private MetricHistogram majorCompactionTimeHisto;
    private MetricHistogram majorCompactionInputFileCountHisto;
    private MetricHistogram majorCompactionInputSizeHisto;
    private MetricHistogram majorCompactionOutputFileCountHisto;
    private MetricHistogram majorCompactionOutputSizeHisto;
    private MutableFastCounter majorCompactedInputBytes;
    private MutableFastCounter majorCompactedOutputBytes;

    public MetricsTableSourceImpl(String tblName, MetricsTableAggregateSourceImpl aggregate, MetricsTableWrapperAggregate tblWrapperAgg) {
        LOG.debug("Creating new MetricsTableSourceImpl for table '{}'", (Object)tblName);
        this.tableName = TableName.valueOf(tblName);
        this.agg = aggregate;
        this.tableWrapperAgg = tblWrapperAgg;
        this.registry = this.agg.getMetricsRegistry();
        this.tableNamePrefixPart1 = "Namespace_" + this.tableName.getNamespaceAsString() + "_table_" + this.tableName.getQualifierAsString();
        this.tableNamePrefixPart2 = "_metric_";
        this.tableNamePrefix = this.tableNamePrefixPart1 + this.tableNamePrefixPart2;
        this.hashCode = this.tableName.hashCode();
    }

    @Override
    public synchronized void registerMetrics() {
        this.flushTimeHisto = this.registry.newTimeHistogram(this.tableNamePrefix + "flushTime", "Histogram for the time in millis for memstore flush");
        this.flushMemstoreSizeHisto = this.registry.newSizeHistogram(this.tableNamePrefix + "flushMemstoreSize", "Histogram for number of bytes in the memstore for a flush");
        this.flushOutputSizeHisto = this.registry.newSizeHistogram(this.tableNamePrefix + "flushOutputSize", "Histogram for number of bytes in the resulting file for a flush");
        this.flushedOutputBytes = this.registry.newCounter(this.tableNamePrefix + "flushedOutputBytes", "Total number of bytes written from flush", 0L);
        this.flushedMemstoreBytes = this.registry.newCounter(this.tableNamePrefix + "flushedMemstoreBytes", "Total number of bytes of cells in memstore from flush", 0L);
        this.compactionTimeHisto = this.registry.newTimeHistogram(this.tableNamePrefix + "compactionTime", "Histogram for the time in millis for compaction, both major and minor");
        this.compactionInputFileCountHisto = this.registry.newHistogram(this.tableNamePrefix + "compactionInputFileCount", "Histogram for the compaction input number of files, both major and minor");
        this.compactionInputSizeHisto = this.registry.newSizeHistogram(this.tableNamePrefix + "compactionInputSize", "Histogram for the compaction total input file sizes, both major and minor");
        this.compactionOutputFileCountHisto = this.registry.newHistogram(this.tableNamePrefix + "compactionOutputFileCount", "Histogram for the compaction output number of files, both major and minor");
        this.compactionOutputSizeHisto = this.registry.newSizeHistogram(this.tableNamePrefix + "compactionOutputSize", "Histogram for the compaction total output file sizes, both major and minor");
        this.compactedInputBytes = this.registry.newCounter(this.tableNamePrefix + "compactedInputBytes", "Total number of bytes that is read for compaction, both major and minor", 0L);
        this.compactedOutputBytes = this.registry.newCounter(this.tableNamePrefix + "compactedOutputBytes", "Total number of bytes that is output from compaction, both major and minor", 0L);
        this.majorCompactionTimeHisto = this.registry.newTimeHistogram(this.tableNamePrefix + "majorCompactionTime", "Histogram for the time in millis for compaction, major only");
        this.majorCompactionInputFileCountHisto = this.registry.newHistogram(this.tableNamePrefix + "majorCompactionInputFileCount", "Histogram for the compaction input number of files, major only");
        this.majorCompactionInputSizeHisto = this.registry.newSizeHistogram(this.tableNamePrefix + "majorCompactionInputSize", "Histogram for the compaction total input file sizes, major only");
        this.majorCompactionOutputFileCountHisto = this.registry.newHistogram(this.tableNamePrefix + "majorCompactionOutputFileCount", "Histogram for the compaction output number of files, major only");
        this.majorCompactionOutputSizeHisto = this.registry.newSizeHistogram(this.tableNamePrefix + "majorCompactionOutputSize", "Histogram for the compaction total output file sizes, major only");
        this.majorCompactedInputBytes = this.registry.newCounter(this.tableNamePrefix + "majorCompactedInputBytes", "Total number of bytes that is read for compaction, major only", 0L);
        this.majorCompactedOutputBytes = this.registry.newCounter(this.tableNamePrefix + "majorCompactedOutputBytes", "Total number of bytes that is output from compaction, major only", 0L);
        this.splitTimeHisto = this.registry.newTimeHistogram(this.tableNamePrefix + "splitTime");
        this.splitRequest = this.registry.newCounter(this.tableNamePrefix + "splitRequestCount", "Number of splits requested", 0L);
        this.splitSuccess = this.registry.newCounter(this.tableNamePrefix + "splitSuccessCount", "Number of successfully executed splits", 0L);
    }

    private void deregisterMetrics() {
        this.registry.removeHistogramMetrics(this.tableNamePrefix + "flushTime");
        this.registry.removeHistogramMetrics(this.tableNamePrefix + "flushMemstoreSize");
        this.registry.removeHistogramMetrics(this.tableNamePrefix + "flushOutputSize");
        this.registry.removeMetric(this.tableNamePrefix + "flushedOutputBytes");
        this.registry.removeMetric(this.tableNamePrefix + "flushedMemstoreBytes");
        this.registry.removeHistogramMetrics(this.tableNamePrefix + "compactionTime");
        this.registry.removeHistogramMetrics(this.tableNamePrefix + "compactionInputFileCount");
        this.registry.removeHistogramMetrics(this.tableNamePrefix + "compactionInputSize");
        this.registry.removeHistogramMetrics(this.tableNamePrefix + "compactionOutputFileCount");
        this.registry.removeHistogramMetrics(this.tableNamePrefix + "compactionOutputSize");
        this.registry.removeMetric(this.tableNamePrefix + "compactedInputBytes");
        this.registry.removeMetric(this.tableNamePrefix + "compactedOutputBytes");
        this.registry.removeHistogramMetrics(this.tableNamePrefix + "majorCompactionTime");
        this.registry.removeHistogramMetrics(this.tableNamePrefix + "majorCompactionInputFileCount");
        this.registry.removeHistogramMetrics(this.tableNamePrefix + "majorCompactionInputSize");
        this.registry.removeHistogramMetrics(this.tableNamePrefix + "majorCompactionOutputFileCount");
        this.registry.removeHistogramMetrics(this.tableNamePrefix + "majorCompactionOutputSize");
        this.registry.removeMetric(this.tableNamePrefix + "majorCompactedInputBytes");
        this.registry.removeMetric(this.tableNamePrefix + "majorCompactedOutputBytes");
        this.registry.removeHistogramMetrics(this.tableNamePrefix + "splitTime");
        this.registry.removeMetric(this.tableNamePrefix + "splitRequestCount");
        this.registry.removeMetric(this.tableNamePrefix + "splitSuccessCount");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        boolean wasClosed = this.closed.getAndSet(true);
        if (wasClosed) {
            return;
        }
        this.agg.deleteTableSource(this.tableName.getNameAsString());
        MetricsTableSourceImpl metricsTableSourceImpl = this;
        synchronized (metricsTableSourceImpl) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Removing table Metrics for table ");
            }
            this.deregisterMetrics();
            this.tableWrapperAgg = null;
        }
    }

    @Override
    public MetricsTableAggregateSource getAggregateSource() {
        return this.agg;
    }

    @Override
    public int compareTo(MetricsTableSource source) {
        if (!(source instanceof MetricsTableSourceImpl)) {
            return -1;
        }
        MetricsTableSourceImpl impl = (MetricsTableSourceImpl)source;
        return Long.compare(this.hashCode, impl.hashCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void snapshot(MetricsRecordBuilder mrb, boolean ignored) {
        if (this.closed.get()) {
            return;
        }
        MetricsTableSourceImpl metricsTableSourceImpl = this;
        synchronized (metricsTableSourceImpl) {
            if (this.closed.get()) {
                return;
            }
            if (this.tableWrapperAgg != null) {
                mrb.addCounter(Interns.info(this.tableNamePrefix + "readRequestCount", "Number of read requests with non-empty Results that this RegionServer has answered."), this.tableWrapperAgg.getReadRequestCount(this.tableName.getNameAsString()));
                mrb.addCounter(Interns.info(this.tableNamePrefix + "filteredReadRequestCount", "Number of read requests this region server has answered."), this.tableWrapperAgg.getFilteredReadRequestCount(this.tableName.getNameAsString()));
                mrb.addCounter(Interns.info(this.tableNamePrefix + "writeRequestCount", "Number of mutation requests this RegionServer has answered."), this.tableWrapperAgg.getWriteRequestCount(this.tableName.getNameAsString()));
                mrb.addCounter(Interns.info(this.tableNamePrefix + "totalRequestCount", "Total number of requests this RegionServer has answered; increments the count once for EVERY access whether an admin operation, a Scan, a Put or Put of 1M rows, or a Get of a non-existent row"), this.tableWrapperAgg.getTotalRequestsCount(this.tableName.getNameAsString()));
                mrb.addGauge(Interns.info(this.tableNamePrefix + "memStoreSize", "Size of the memstore"), this.tableWrapperAgg.getMemStoreSize(this.tableName.getNameAsString()));
                mrb.addGauge(Interns.info(this.tableNamePrefix + "storeFileCount", "Number of Store Files"), this.tableWrapperAgg.getNumStoreFiles(this.tableName.getNameAsString()));
                mrb.addGauge(Interns.info(this.tableNamePrefix + "maxStoreFileCount", "Max store file count across all regions"), this.tableWrapperAgg.getMaxStoreFiles(this.tableName.getNameAsString()));
                mrb.addGauge(Interns.info(this.tableNamePrefix + "storeFileSize", "Size of storefiles being served."), this.tableWrapperAgg.getStoreFileSize(this.tableName.getNameAsString()));
                mrb.addGauge(Interns.info(this.tableNamePrefix + "tableSize", "Total size of the table in the region server"), this.tableWrapperAgg.getTableSize(this.tableName.getNameAsString()));
                mrb.addGauge(Interns.info(this.tableNamePrefix + "averageRegionSize", "Average region size over the RegionServer including memstore and storefile sizes."), this.tableWrapperAgg.getAvgRegionSize(this.tableName.getNameAsString()));
                mrb.addGauge(Interns.info(this.tableNamePrefix + "regionCount", "Number of regions"), this.tableWrapperAgg.getNumRegions(this.tableName.getNameAsString()));
                mrb.addGauge(Interns.info(this.tableNamePrefix + "storeCount", "Number of Stores"), this.tableWrapperAgg.getNumStores(this.tableName.getNameAsString()));
                mrb.addGauge(Interns.info(this.tableNamePrefix + "maxStoreFileAge", "Max age of store files hosted on this RegionServer"), this.tableWrapperAgg.getMaxStoreFileAge(this.tableName.getNameAsString()));
                mrb.addGauge(Interns.info(this.tableNamePrefix + "minStoreFileAge", "Min age of store files hosted on this RegionServer"), this.tableWrapperAgg.getMinStoreFileAge(this.tableName.getNameAsString()));
                mrb.addGauge(Interns.info(this.tableNamePrefix + "avgStoreFileAge", "Average age of store files hosted on this RegionServer"), this.tableWrapperAgg.getAvgStoreFileAge(this.tableName.getNameAsString()));
                mrb.addGauge(Interns.info(this.tableNamePrefix + "numReferenceFiles", "Number of reference file on this RegionServer"), this.tableWrapperAgg.getNumReferenceFiles(this.tableName.getNameAsString()));
                this.addGauge(mrb, this.tableWrapperAgg.getMemstoreOnlyRowReadsCount(this.tableName.getNameAsString()), "memstoreOnlyRowReadsCount", "Row reads happening completely out of memstore");
                this.addGauge(mrb, this.tableWrapperAgg.getMixedRowReadsCount(this.tableName.getNameAsString()), "mixedRowReadsCount", "Row reads happening out of files and memstore on store");
            }
        }
    }

    private void addGauge(MetricsRecordBuilder mrb, Map<String, Long> metricMap, String metricName, String metricDesc) {
        if (metricMap != null) {
            for (Map.Entry<String, Long> entry : metricMap.entrySet()) {
                mrb.addGauge(Interns.info(this.tableNamePrefixPart1 + _COLUMNFAMILY + entry.getKey().split("#")[1] + this.tableNamePrefixPart2 + metricName, metricDesc), entry.getValue());
            }
        }
    }

    @Override
    public String getTableName() {
        return this.tableName.getNameAsString();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.compareTo((MetricsTableSourceImpl)o) == 0;
    }

    public MetricsTableWrapperAggregate getTableWrapper() {
        return this.tableWrapperAgg;
    }

    public String getTableNamePrefix() {
        return this.tableNamePrefix;
    }

    @Override
    public void incrSplitRequest() {
        this.splitRequest.incr();
    }

    @Override
    public void incrSplitSuccess() {
        this.splitSuccess.incr();
    }

    @Override
    public void updateSplitTime(long t) {
        this.splitTimeHisto.add(t);
    }

    @Override
    public void updateFlushTime(long t) {
        this.flushTimeHisto.add(t);
    }

    @Override
    public synchronized void updateFlushMemstoreSize(long bytes) {
        this.flushMemstoreSizeHisto.add(bytes);
        this.flushedMemstoreBytes.incr(bytes);
    }

    @Override
    public synchronized void updateFlushOutputSize(long bytes) {
        this.flushOutputSizeHisto.add(bytes);
        this.flushedOutputBytes.incr(bytes);
    }

    @Override
    public synchronized void updateCompactionTime(boolean isMajor, long t) {
        this.compactionTimeHisto.add(t);
        if (isMajor) {
            this.majorCompactionTimeHisto.add(t);
        }
    }

    @Override
    public synchronized void updateCompactionInputFileCount(boolean isMajor, long c) {
        this.compactionInputFileCountHisto.add(c);
        if (isMajor) {
            this.majorCompactionInputFileCountHisto.add(c);
        }
    }

    @Override
    public synchronized void updateCompactionInputSize(boolean isMajor, long bytes) {
        this.compactionInputSizeHisto.add(bytes);
        this.compactedInputBytes.incr(bytes);
        if (isMajor) {
            this.majorCompactionInputSizeHisto.add(bytes);
            this.majorCompactedInputBytes.incr(bytes);
        }
    }

    @Override
    public synchronized void updateCompactionOutputFileCount(boolean isMajor, long c) {
        this.compactionOutputFileCountHisto.add(c);
        if (isMajor) {
            this.majorCompactionOutputFileCountHisto.add(c);
        }
    }

    @Override
    public synchronized void updateCompactionOutputSize(boolean isMajor, long bytes) {
        this.compactionOutputSizeHisto.add(bytes);
        this.compactedOutputBytes.incr(bytes);
        if (isMajor) {
            this.majorCompactionOutputSizeHisto.add(bytes);
            this.majorCompactedOutputBytes.incr(bytes);
        }
    }
}

