/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http;

import java.util.Objects;
import org.apache.hc.core5.http.NameValuePair;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class NameValuePairMatcher
extends BaseMatcher<NameValuePair> {
    private final String name;
    private final String value;

    public NameValuePairMatcher(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public boolean matches(Object item) {
        if (item instanceof NameValuePair) {
            NameValuePair nvp = (NameValuePair)item;
            return Objects.equals(nvp.getName(), this.name) && Objects.equals(nvp.getValue(), this.value);
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("equals ").appendValue((Object)this.name).appendText("=").appendValue((Object)this.value);
    }

    public static Matcher<NameValuePair> equals(String name, String value) {
        return new NameValuePairMatcher(name, value);
    }

    public static Matcher<NameValuePair> same(String name, String value) {
        return new NameValuePairMatcher(name, value);
    }
}

