/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.net.ssl.SSLException;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.util.TimeValue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestDefaultHttpRequestRetryStrategy {
    private DefaultHttpRequestRetryStrategy retryStrategy;

    TestDefaultHttpRequestRetryStrategy() {
    }

    @BeforeEach
    void setup() {
        this.retryStrategy = new DefaultHttpRequestRetryStrategy(3, TimeValue.ofMilliseconds((long)1234L));
    }

    @Test
    void testBasics() {
        BasicHttpResponse response1 = new BasicHttpResponse(503, "Oopsie");
        Assertions.assertTrue((boolean)this.retryStrategy.retryRequest((HttpResponse)response1, 1, null));
        Assertions.assertTrue((boolean)this.retryStrategy.retryRequest((HttpResponse)response1, 2, null));
        Assertions.assertTrue((boolean)this.retryStrategy.retryRequest((HttpResponse)response1, 3, null));
        Assertions.assertFalse((boolean)this.retryStrategy.retryRequest((HttpResponse)response1, 4, null));
        BasicHttpResponse response2 = new BasicHttpResponse(500, "Big Time Oopsie");
        Assertions.assertFalse((boolean)this.retryStrategy.retryRequest((HttpResponse)response2, 1, null));
        BasicHttpResponse response3 = new BasicHttpResponse(429, "Oopsie");
        Assertions.assertTrue((boolean)this.retryStrategy.retryRequest((HttpResponse)response3, 1, null));
        Assertions.assertTrue((boolean)this.retryStrategy.retryRequest((HttpResponse)response3, 2, null));
        Assertions.assertTrue((boolean)this.retryStrategy.retryRequest((HttpResponse)response3, 3, null));
        Assertions.assertFalse((boolean)this.retryStrategy.retryRequest((HttpResponse)response3, 4, null));
        Assertions.assertEquals((Object)TimeValue.ofMilliseconds((long)1234L), (Object)this.retryStrategy.getRetryInterval((HttpResponse)response1, 1, null));
    }

    @Test
    void testRetryAfterHeaderAsLong() {
        BasicHttpResponse response = new BasicHttpResponse(503, "Oopsie");
        response.setHeader("Retry-After", (Object)"321");
        Assertions.assertEquals((Object)TimeValue.ofSeconds((long)321L), (Object)this.retryStrategy.getRetryInterval((HttpResponse)response, 3, null));
    }

    @Test
    void testRetryAfterHeaderAsDate() {
        this.retryStrategy = new DefaultHttpRequestRetryStrategy(3, TimeValue.ZERO_MILLISECONDS);
        BasicHttpResponse response = new BasicHttpResponse(503, "Oopsie");
        response.setHeader("Retry-After", (Object)DateUtils.formatStandardDate((Instant)Instant.now().plus(100L, ChronoUnit.SECONDS)));
        Assertions.assertTrue((this.retryStrategy.getRetryInterval((HttpResponse)response, 3, null).compareTo(TimeValue.ZERO_MILLISECONDS) > 0 ? 1 : 0) != 0);
    }

    @Test
    void testRetryAfterHeaderAsPastDate() {
        BasicHttpResponse response = new BasicHttpResponse(503, "Oopsie");
        response.setHeader("Retry-After", (Object)DateUtils.formatStandardDate((Instant)Instant.now().minus(100L, ChronoUnit.SECONDS)));
        Assertions.assertEquals((Object)TimeValue.ofMilliseconds((long)1234L), (Object)this.retryStrategy.getRetryInterval((HttpResponse)response, 3, null));
    }

    @Test
    void testInvalidRetryAfterHeader() {
        BasicHttpResponse response = new BasicHttpResponse(503, "Oopsie");
        response.setHeader("Retry-After", (Object)"Stuff");
        Assertions.assertEquals((Object)TimeValue.ofMilliseconds((long)1234L), (Object)this.retryStrategy.getRetryInterval((HttpResponse)response, 3, null));
    }

    @Test
    void noRetryOnConnectTimeout() {
        HttpGet request = new HttpGet("/");
        Assertions.assertFalse((boolean)this.retryStrategy.retryRequest((HttpRequest)request, (IOException)new SocketTimeoutException(), 1, null));
    }

    @Test
    void noRetryOnConnect() {
        HttpGet request = new HttpGet("/");
        Assertions.assertFalse((boolean)this.retryStrategy.retryRequest((HttpRequest)request, (IOException)new ConnectException(), 1, null));
    }

    @Test
    void noRetryOnConnectionClosed() {
        HttpGet request = new HttpGet("/");
        Assertions.assertFalse((boolean)this.retryStrategy.retryRequest((HttpRequest)request, (IOException)new ConnectionClosedException(), 1, null));
    }

    @Test
    void noRetryForNoRouteToHostException() {
        HttpGet request = new HttpGet("/");
        Assertions.assertFalse((boolean)this.retryStrategy.retryRequest((HttpRequest)request, (IOException)new NoRouteToHostException(), 1, null));
    }

    @Test
    void noRetryOnSSLFailure() {
        HttpGet request = new HttpGet("/");
        Assertions.assertFalse((boolean)this.retryStrategy.retryRequest((HttpRequest)request, (IOException)new SSLException("encryption failed"), 1, null));
    }

    @Test
    void noRetryOnUnknownHost() {
        HttpGet request = new HttpGet("/");
        Assertions.assertFalse((boolean)this.retryStrategy.retryRequest((HttpRequest)request, (IOException)new UnknownHostException(), 1, null));
    }

    @Test
    void noRetryOnAbortedRequests() {
        HttpGet request = new HttpGet("/");
        request.cancel();
        Assertions.assertFalse((boolean)this.retryStrategy.retryRequest((HttpRequest)request, new IOException(), 1, null));
    }

    @Test
    void retryOnNonAbortedRequests() {
        HttpGet request = new HttpGet("/");
        Assertions.assertTrue((boolean)this.retryStrategy.retryRequest((HttpRequest)request, new IOException(), 1, null));
    }
}

