/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.SingleCredentialsProvider;
import org.apache.hc.core5.http.HttpHost;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestCredentialsProviders {
    public static final Credentials CREDS1 = new UsernamePasswordCredentials("user1", "pass1".toCharArray());
    public static final Credentials CREDS2 = new UsernamePasswordCredentials("user2", "pass2".toCharArray());
    public static final AuthScope SCOPE1 = new AuthScope(null, null, -1, "realm1", null);
    public static final AuthScope SCOPE2 = new AuthScope(null, null, -1, "realm2", null);
    public static final AuthScope BOGUS = new AuthScope(null, null, -1, "bogus", null);
    public static final AuthScope DEFSCOPE = new AuthScope(null, "host", -1, "realm", null);

    TestCredentialsProviders() {
    }

    @Test
    void testBasicCredentialsProviderCredentials() {
        BasicCredentialsProvider state = new BasicCredentialsProvider();
        state.setCredentials(SCOPE1, CREDS1);
        state.setCredentials(SCOPE2, CREDS2);
        Assertions.assertEquals((Object)CREDS1, (Object)state.getCredentials(SCOPE1, null));
        Assertions.assertEquals((Object)CREDS2, (Object)state.getCredentials(SCOPE2, null));
    }

    @Test
    void testBasicCredentialsProviderNoCredentials() {
        BasicCredentialsProvider state = new BasicCredentialsProvider();
        Assertions.assertNull((Object)state.getCredentials(BOGUS, null));
    }

    @Test
    void testBasicCredentialsProviderDefaultCredentials() {
        BasicCredentialsProvider state = new BasicCredentialsProvider();
        state.setCredentials(new AuthScope(null, null, -1, null, null), CREDS1);
        state.setCredentials(SCOPE2, CREDS2);
        Assertions.assertEquals((Object)CREDS1, (Object)state.getCredentials(BOGUS, null));
    }

    @Test
    void testDefaultCredentials() {
        BasicCredentialsProvider state = new BasicCredentialsProvider();
        UsernamePasswordCredentials expected = new UsernamePasswordCredentials("name", "pass".toCharArray());
        state.setCredentials(new AuthScope(null, null, -1, null, null), (Credentials)expected);
        Credentials got = state.getCredentials(DEFSCOPE, null);
        Assertions.assertEquals((Object)got, (Object)expected);
    }

    @Test
    void testRealmCredentials() {
        BasicCredentialsProvider state = new BasicCredentialsProvider();
        UsernamePasswordCredentials expected = new UsernamePasswordCredentials("name", "pass".toCharArray());
        state.setCredentials(DEFSCOPE, (Credentials)expected);
        Credentials got = state.getCredentials(DEFSCOPE, null);
        Assertions.assertEquals((Object)expected, (Object)got);
    }

    @Test
    void testHostCredentials() {
        BasicCredentialsProvider state = new BasicCredentialsProvider();
        UsernamePasswordCredentials expected = new UsernamePasswordCredentials("name", "pass".toCharArray());
        state.setCredentials(new AuthScope(null, "host", -1, null, null), (Credentials)expected);
        Credentials got = state.getCredentials(DEFSCOPE, null);
        Assertions.assertEquals((Object)expected, (Object)got);
    }

    @Test
    void testWrongHostCredentials() {
        BasicCredentialsProvider state = new BasicCredentialsProvider();
        UsernamePasswordCredentials expected = new UsernamePasswordCredentials("name", "pass".toCharArray());
        state.setCredentials(new AuthScope(null, "host1", -1, "realm", null), (Credentials)expected);
        Credentials got = state.getCredentials(new AuthScope(null, "host2", -1, "realm", null), null);
        Assertions.assertNotSame((Object)expected, (Object)got);
    }

    @Test
    void testWrongRealmCredentials() {
        BasicCredentialsProvider state = new BasicCredentialsProvider();
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials("name", "pass".toCharArray());
        state.setCredentials(new AuthScope(null, "host", -1, "realm1", null), (Credentials)cred);
        Credentials got = state.getCredentials(new AuthScope(null, "host", -1, "realm2", null), null);
        Assertions.assertNotSame((Object)cred, (Object)got);
    }

    @Test
    void testMixedCaseHostname() {
        HttpHost httpHost = new HttpHost("hOsT", 80);
        BasicCredentialsProvider state = new BasicCredentialsProvider();
        UsernamePasswordCredentials expected = new UsernamePasswordCredentials("name", "pass".toCharArray());
        state.setCredentials(new AuthScope(httpHost), (Credentials)expected);
        Credentials got = state.getCredentials(DEFSCOPE, null);
        Assertions.assertEquals((Object)expected, (Object)got);
    }

    @Test
    void testCredentialsMatching() {
        UsernamePasswordCredentials creds1 = new UsernamePasswordCredentials("name1", "pass1".toCharArray());
        UsernamePasswordCredentials creds2 = new UsernamePasswordCredentials("name2", "pass2".toCharArray());
        UsernamePasswordCredentials creds3 = new UsernamePasswordCredentials("name3", "pass3".toCharArray());
        AuthScope scope1 = new AuthScope(null, null, -1, null, null);
        AuthScope scope2 = new AuthScope(null, null, -1, "somerealm", null);
        AuthScope scope3 = new AuthScope(null, "somehost", -1, null, null);
        BasicCredentialsProvider state = new BasicCredentialsProvider();
        state.setCredentials(scope1, (Credentials)creds1);
        state.setCredentials(scope2, (Credentials)creds2);
        state.setCredentials(scope3, (Credentials)creds3);
        Credentials got = state.getCredentials(new AuthScope("http", "someotherhost", 80, "someotherrealm", "Basic"), null);
        UsernamePasswordCredentials expected = creds1;
        Assertions.assertEquals((Object)expected, (Object)got);
        got = state.getCredentials(new AuthScope("http", "someotherhost", 80, "somerealm", "Basic"), null);
        expected = creds2;
        Assertions.assertEquals((Object)expected, (Object)got);
        got = state.getCredentials(new AuthScope("http", "somehost", 80, "someotherrealm", "Basic"), null);
        expected = creds3;
        Assertions.assertEquals((Object)expected, (Object)got);
    }

    @Test
    void testSingleCredentialsProvider() {
        UsernamePasswordCredentials creds1 = new UsernamePasswordCredentials("name1", "pass1".toCharArray());
        SingleCredentialsProvider credentialsProvider1 = new SingleCredentialsProvider(new AuthScope(null, null, -1, null, null), (Credentials)creds1);
        Assertions.assertEquals((Object)creds1, (Object)credentialsProvider1.getCredentials(new AuthScope(null, null, -1, null, null), null));
        Assertions.assertEquals((Object)creds1, (Object)credentialsProvider1.getCredentials(new AuthScope("http", "someotherhost", 80, "somerealm", "Basic"), null));
        SingleCredentialsProvider credentialsProvider2 = new SingleCredentialsProvider(new AuthScope(null, "somehost", 80, null, null), (Credentials)creds1);
        Assertions.assertEquals((Object)creds1, (Object)credentialsProvider2.getCredentials(new AuthScope(null, null, -1, null, null), null));
        Assertions.assertEquals((Object)creds1, (Object)credentialsProvider2.getCredentials(new AuthScope(null, "somehost", 80, null, null), null));
        Assertions.assertEquals((Object)creds1, (Object)credentialsProvider2.getCredentials(new AuthScope("http", "somehost", 80, "somerealm", "Basic"), null));
        Assertions.assertNull((Object)credentialsProvider2.getCredentials(new AuthScope(null, "someotherhost", 80, null, null), null));
        Assertions.assertNull((Object)credentialsProvider2.getCredentials(new AuthScope(null, "somehost", 8080, null, null), null));
    }
}

