/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.client5.http.impl.classic.AbstractHttpClientResponseHandler;
import org.apache.hc.client5.http.impl.classic.BasicHttpClientResponseHandler;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class TestAbstractHttpClientResponseHandler {
    TestAbstractHttpClientResponseHandler() {
    }

    @Test
    void testSuccessfulResponse() throws Exception {
        ClassicHttpResponse response = (ClassicHttpResponse)Mockito.mock(ClassicHttpResponse.class);
        StringEntity entity = new StringEntity("42");
        Mockito.when((Object)response.getCode()).thenReturn((Object)200);
        Mockito.when((Object)response.getEntity()).thenReturn((Object)entity);
        AbstractHttpClientResponseHandler<Integer> handler = new AbstractHttpClientResponseHandler<Integer>(){

            public Integer handleEntity(HttpEntity entity) throws IOException {
                return Integer.valueOf(new String(EntityUtils.toByteArray((HttpEntity)entity)));
            }
        };
        Integer number = (Integer)handler.handleResponse(response);
        Assertions.assertEquals((int)42, (int)number);
    }

    @Test
    void testUnsuccessfulResponse() throws Exception {
        InputStream inStream = (InputStream)Mockito.mock(InputStream.class);
        HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)entity.isStreaming()).thenReturn((Object)true);
        Mockito.when((Object)entity.getContent()).thenReturn((Object)inStream);
        ClassicHttpResponse response = (ClassicHttpResponse)Mockito.mock(ClassicHttpResponse.class);
        Mockito.when((Object)response.getCode()).thenReturn((Object)404);
        Mockito.when((Object)response.getReasonPhrase()).thenReturn((Object)"NOT FOUND");
        Mockito.when((Object)response.getEntity()).thenReturn((Object)entity);
        BasicHttpClientResponseHandler handler = new BasicHttpClientResponseHandler();
        HttpResponseException exception = (HttpResponseException)Assertions.assertThrows(HttpResponseException.class, () -> handler.handleResponse(response));
        Assertions.assertEquals((int)404, (int)exception.getStatusCode());
        Assertions.assertEquals((Object)"NOT FOUND", (Object)exception.getReasonPhrase());
        Assertions.assertEquals((Object)"status code: 404, reason phrase: NOT FOUND", (Object)exception.getMessage());
        ((HttpEntity)Mockito.verify((Object)entity)).getContent();
        ((InputStream)Mockito.verify((Object)inStream)).close();
    }

    @Test
    void testUnsuccessfulResponseEmptyReason() throws Exception {
        InputStream inStream = (InputStream)Mockito.mock(InputStream.class);
        HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)entity.isStreaming()).thenReturn((Object)true);
        Mockito.when((Object)entity.getContent()).thenReturn((Object)inStream);
        ClassicHttpResponse response = (ClassicHttpResponse)Mockito.mock(ClassicHttpResponse.class);
        Mockito.when((Object)response.getCode()).thenReturn((Object)404);
        Mockito.when((Object)response.getEntity()).thenReturn((Object)entity);
        BasicHttpClientResponseHandler handler = new BasicHttpClientResponseHandler();
        HttpResponseException exception = (HttpResponseException)Assertions.assertThrows(HttpResponseException.class, () -> handler.handleResponse(response));
        Assertions.assertEquals((int)404, (int)exception.getStatusCode());
        Assertions.assertNull((Object)exception.getReasonPhrase());
        Assertions.assertEquals((Object)"status code: 404", (Object)exception.getMessage());
        ((HttpEntity)Mockito.verify((Object)entity)).getContent();
        ((InputStream)Mockito.verify((Object)inStream)).close();
    }
}

