/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.routing;

import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class TestDefaultProxyRoutePlanner {
    private HttpHost defaultProxy;
    private SchemePortResolver schemePortResolver;
    private DefaultProxyRoutePlanner routePlanner;

    TestDefaultProxyRoutePlanner() {
    }

    @BeforeEach
    void setup() {
        this.defaultProxy = new HttpHost("default.proxy.host", 8888);
        this.schemePortResolver = (SchemePortResolver)Mockito.mock(SchemePortResolver.class);
        this.routePlanner = new DefaultProxyRoutePlanner(this.defaultProxy, this.schemePortResolver);
    }

    @Test
    void testDefaultProxyDirect() throws Exception {
        HttpHost target = new HttpHost("http", "somehost", 80);
        HttpClientContext context = HttpClientContext.create();
        HttpRoute route = this.routePlanner.determineRoute(target, (HttpContext)context);
        Assertions.assertEquals((Object)target, (Object)route.getTargetHost());
        Assertions.assertEquals((Object)this.defaultProxy, (Object)route.getProxyHost());
        Assertions.assertEquals((int)2, (int)route.getHopCount());
        Assertions.assertFalse((boolean)route.isSecure());
    }

    @Test
    void testViaProxy() throws Exception {
        HttpHost target = new HttpHost("http", "somehost", 80);
        HttpHost proxy = new HttpHost("custom.proxy.host", 8080);
        HttpClientContext context = HttpClientContext.create();
        context.setRequestConfig(RequestConfig.custom().setProxy(proxy).build());
        HttpRoute route = this.routePlanner.determineRoute(target, (HttpContext)context);
        Assertions.assertEquals((Object)target, (Object)route.getTargetHost());
        Assertions.assertEquals((Object)proxy, (Object)route.getProxyHost());
        Assertions.assertEquals((int)2, (int)route.getHopCount());
        Assertions.assertFalse((boolean)route.isSecure());
    }
}

