/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.utils;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.hc.client5.http.utils.ByteArrayBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestByteArrayBuilder {
    TestByteArrayBuilder() {
    }

    @Test
    void testEmptyBuffer() {
        ByteArrayBuilder buffer = new ByteArrayBuilder();
        ByteBuffer byteBuffer = buffer.toByteBuffer();
        Assertions.assertNotNull((Object)byteBuffer);
        Assertions.assertEquals((int)0, (int)byteBuffer.capacity());
        byte[] bytes = buffer.toByteArray();
        Assertions.assertNotNull((Object)bytes);
        Assertions.assertEquals((int)0, (int)bytes.length);
    }

    @Test
    void testAppendBytes() {
        ByteArrayBuilder buffer = new ByteArrayBuilder();
        buffer.append(new byte[]{1, 2, 3, 4, 5});
        buffer.append(new byte[]{3, 4, 5, 6, 7, 8, 9, 10, 11}, 3, 5);
        buffer.append((byte[])null);
        byte[] bytes = buffer.toByteArray();
        Assertions.assertNotNull((Object)bytes);
        Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, (byte[])bytes);
    }

    @Test
    void testInvalidAppendBytes() {
        ByteArrayBuilder buffer = new ByteArrayBuilder();
        buffer.append((byte[])null, 0, 0);
        byte[] tmp = new byte[]{1, 2, 3, 4};
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.append(tmp, -1, 0));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.append(tmp, 0, -1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.append(tmp, 0, 8));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.append(tmp, 10, Integer.MAX_VALUE));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.append(tmp, 2, 4));
    }

    @Test
    void testEnsureCapacity() {
        ByteArrayBuilder buffer = new ByteArrayBuilder();
        buffer.ensureFreeCapacity(10);
        Assertions.assertEquals((int)10, (int)buffer.capacity());
        buffer.ensureFreeCapacity(5);
        Assertions.assertEquals((int)10, (int)buffer.capacity());
        buffer.append(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        buffer.ensureFreeCapacity(5);
        Assertions.assertEquals((int)13, (int)buffer.capacity());
        buffer.ensureFreeCapacity(15);
        Assertions.assertEquals((int)23, (int)buffer.capacity());
    }

    @Test
    void testAppendText() {
        ByteArrayBuilder buffer = new ByteArrayBuilder();
        buffer.append(new char[]{'1', '2', '3', '4', '5'});
        buffer.append(new char[]{'3', '4', '5', '6', '7', '8', '9', 'a', 'b'}, 3, 5);
        buffer.append("bcd");
        buffer.append("e");
        buffer.append("f");
        buffer.append("");
        buffer.append((String)null);
        buffer.append((char[])null);
        byte[] bytes = buffer.toByteArray();
        Assertions.assertNotNull((Object)bytes);
        Assertions.assertEquals((Object)"123456789abcdef", (Object)new String(bytes, StandardCharsets.US_ASCII));
    }

    @Test
    void testInvalidAppendChars() {
        ByteArrayBuilder buffer = new ByteArrayBuilder();
        buffer.append((char[])null, 0, 0);
        char[] tmp = new char[]{'\u0001', '\u0002', '\u0003', '\u0004'};
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.append(tmp, -1, 0));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.append(tmp, 0, -1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.append(tmp, 0, 8));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.append(tmp, 10, Integer.MAX_VALUE));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.append(tmp, 2, 4));
    }

    @Test
    void testReset() {
        ByteArrayBuilder buffer = new ByteArrayBuilder();
        buffer.append("abcd");
        buffer.append("e");
        buffer.append("f");
        byte[] bytes1 = buffer.toByteArray();
        Assertions.assertNotNull((Object)bytes1);
        Assertions.assertEquals((Object)"abcdef", (Object)new String(bytes1, StandardCharsets.US_ASCII));
        buffer.reset();
        byte[] bytes2 = buffer.toByteArray();
        Assertions.assertNotNull((Object)bytes2);
        Assertions.assertEquals((Object)"", (Object)new String(bytes2, StandardCharsets.US_ASCII));
    }

    @Test
    void testNonAsciiCharset() {
        int[] germanChars = new int[]{228, 45, 246, 45, 252};
        StringBuilder tmp = new StringBuilder();
        for (int germanChar : germanChars) {
            tmp.append((char)germanChar);
        }
        String umlauts = tmp.toString();
        ByteArrayBuilder buffer = new ByteArrayBuilder();
        buffer.append(umlauts);
        byte[] bytes1 = buffer.toByteArray();
        Assertions.assertNotNull((Object)bytes1);
        Assertions.assertEquals((Object)"?-?-?", (Object)new String(bytes1, StandardCharsets.US_ASCII));
        buffer.reset();
        buffer.charset(StandardCharsets.UTF_8);
        buffer.append(umlauts);
        byte[] bytes2 = buffer.toByteArray();
        Assertions.assertNotNull((Object)bytes2);
        Assertions.assertEquals((Object)umlauts, (Object)new String(bytes2, StandardCharsets.UTF_8));
    }
}

