/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.HeaderGroup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestDateUtils {
    TestDateUtils() {
    }

    private static Instant createInstant(int year, Month month, int day) {
        return LocalDate.of(year, month, day).atStartOfDay(ZoneId.of("GMT")).toInstant();
    }

    @Test
    void testBasicDateParse() {
        Instant instant = TestDateUtils.createInstant(2005, Month.OCTOBER, 14);
        Assertions.assertEquals((Object)instant, (Object)DateUtils.parseDate((String)"Fri, 14 Oct 2005 00:00:00 GMT", (DateTimeFormatter[])new DateTimeFormatter[]{DateUtils.FORMATTER_RFC1123}));
        Assertions.assertEquals((Object)instant, (Object)DateUtils.parseDate((String)"Friday, 14 Oct 2005 00:00:00 GMT", (DateTimeFormatter[])new DateTimeFormatter[]{DateUtils.FORMATTER_RFC1123}));
        Assertions.assertEquals((Object)instant, (Object)DateUtils.parseDate((String)"Fri, 14-Oct-2005 00:00:00 GMT", (DateTimeFormatter[])new DateTimeFormatter[]{DateUtils.FORMATTER_RFC1036}));
        Assertions.assertEquals((Object)instant, (Object)DateUtils.parseDate((String)"Friday, 14-Oct-2005 00:00:00 GMT", (DateTimeFormatter[])new DateTimeFormatter[]{DateUtils.FORMATTER_RFC1036}));
        Assertions.assertEquals((Object)instant.minus(2L, ChronoUnit.HOURS), (Object)DateUtils.parseDate((String)"Fri, 14 Oct 2005 00:00:00 CET", (DateTimeFormatter[])new DateTimeFormatter[]{DateUtils.FORMATTER_RFC1123}));
        Assertions.assertEquals((Object)instant.minus(2L, ChronoUnit.HOURS), (Object)DateUtils.parseDate((String)"Fri, 14-Oct-05 00:00:00 CET", (DateTimeFormatter[])new DateTimeFormatter[]{DateUtils.FORMATTER_RFC1036}));
        Assertions.assertEquals((Object)instant, (Object)DateUtils.parseStandardDate((String)"Fri, 14 Oct 2005 00:00:00 GMT"));
    }

    @Test
    void testDateParseMessage() {
        HeaderGroup message1 = new HeaderGroup();
        message1.setHeader((Header)new BasicHeader("Date", (Object)"Fri, 14 Oct 2005 00:00:00 GMT"));
        Assertions.assertEquals((Object)TestDateUtils.createInstant(2005, Month.OCTOBER, 14), (Object)DateUtils.parseStandardDate((MessageHeaders)message1, (String)"Date"));
        HeaderGroup message2 = new HeaderGroup();
        message2.addHeader((Header)new BasicHeader("Date", (Object)"Fri, 14 Oct 2005 00:00:00 GMT"));
        message2.addHeader((Header)new BasicHeader("Date", (Object)"Fri, 21 Oct 2005 00:00:00 GMT"));
        Assertions.assertEquals((Object)TestDateUtils.createInstant(2005, Month.OCTOBER, 14), (Object)DateUtils.parseStandardDate((MessageHeaders)message2, (String)"Date"));
    }

    @Test
    void testMalformedDate() {
        Assertions.assertNull((Object)DateUtils.parseDate((String)"Fri, 14 Oct 2005 00:00:00 GMT", (DateTimeFormatter[])new DateTimeFormatter[0]));
        Assertions.assertNull((Object)DateUtils.parseDate((String)"Thu Feb 22 17:20:18 2024", (DateTimeFormatter[])new DateTimeFormatter[0]));
    }

    @Test
    void testInvalidInput() {
        Assertions.assertThrows(NullPointerException.class, () -> DateUtils.parseStandardDate(null));
        Assertions.assertThrows(NullPointerException.class, () -> DateUtils.formatStandardDate(null));
    }

    @Test
    void testTwoDigitYearDateParse() {
        Assertions.assertEquals((Object)TestDateUtils.createInstant(2005, Month.OCTOBER, 14), (Object)DateUtils.parseDate((String)"Friday, 14-Oct-05 00:00:00 GMT", (DateTimeFormatter[])new DateTimeFormatter[]{DateUtils.FORMATTER_RFC1036}));
    }

    @Test
    void testParseQuotedDate() {
        Assertions.assertEquals((Object)TestDateUtils.createInstant(2005, Month.OCTOBER, 14), (Object)DateUtils.parseDate((String)"'Fri, 14 Oct 2005 00:00:00 GMT'", (DateTimeFormatter[])new DateTimeFormatter[]{DateUtils.FORMATTER_RFC1123}));
    }

    @Test
    void testBasicDateFormat() {
        Instant instant = TestDateUtils.createInstant(2005, Month.OCTOBER, 14);
        Assertions.assertEquals((Object)"Fri, 14 Oct 2005 00:00:00 GMT", (Object)DateUtils.formatStandardDate((Instant)instant));
        Assertions.assertEquals((Object)"Fri, 14 Oct 2005 00:00:00 GMT", (Object)DateUtils.formatDate((Instant)instant, (DateTimeFormatter)DateUtils.FORMATTER_RFC1123));
        Assertions.assertEquals((Object)"Fri, 14-Oct-05 00:00:00 GMT", (Object)DateUtils.formatDate((Instant)instant, (DateTimeFormatter)DateUtils.FORMATTER_RFC1036));
        Assertions.assertEquals((Object)"Fri Oct 14 00:00:00 2005", (Object)DateUtils.formatDate((Instant)instant, (DateTimeFormatter)DateUtils.FORMATTER_ASCTIME));
    }
}

