/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http;

import org.apache.hc.core5.http.ContentType;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class ContentTypeMatcher
extends BaseMatcher<ContentType> {
    private final ContentType expectedContentType;

    public ContentTypeMatcher(ContentType contentType) {
        this.expectedContentType = contentType;
    }

    public boolean matches(Object item) {
        if (item instanceof ContentType) {
            ContentType contentType = (ContentType)item;
            return contentType.isSameMimeType(this.expectedContentType);
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("same MIME type as ").appendValue((Object)this.expectedContentType);
    }

    public static Matcher<ContentType> sameMimeType(ContentType contentType) {
        return new ContentTypeMatcher(contentType);
    }
}

