/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.classic.methods;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpOptions;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpTrace;
import org.apache.hc.client5.http.entity.EntityBuilder;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

class TestHttpRequestBase {
    private static final String HOT_URL = "http://host/path";

    TestHttpRequestBase() {
    }

    @Test
    void testBasicGetMethodProperties() throws Exception {
        HttpGet httpget = new HttpGet(HOT_URL);
        Assertions.assertEquals((Object)"GET", (Object)httpget.getMethod());
        Assertions.assertEquals((Object)new URI(HOT_URL), (Object)httpget.getUri());
    }

    @Test
    void testBasicHttpPostMethodProperties() throws Exception {
        HttpPost HttpPost2 = new HttpPost(HOT_URL);
        Assertions.assertEquals((Object)"POST", (Object)HttpPost2.getMethod());
        Assertions.assertEquals((Object)new URI(HOT_URL), (Object)HttpPost2.getUri());
    }

    @Test
    void testBasicHttpHeadMethodProperties() throws Exception {
        HttpHead httpHead = new HttpHead(HOT_URL);
        Assertions.assertEquals((Object)"HEAD", (Object)httpHead.getMethod());
        Assertions.assertEquals((Object)new URI(HOT_URL), (Object)httpHead.getUri());
    }

    @Test
    void testBasicHttpOptionMethodProperties() throws Exception {
        HttpOptions httpOption = new HttpOptions(HOT_URL);
        Assertions.assertEquals((Object)"OPTIONS", (Object)httpOption.getMethod());
        Assertions.assertEquals((Object)new URI(HOT_URL), (Object)httpOption.getUri());
    }

    @Test
    void testBasicHttpPatchMethodProperties() throws Exception {
        HttpPatch httpPatch = new HttpPatch(HOT_URL);
        Assertions.assertEquals((Object)"PATCH", (Object)httpPatch.getMethod());
        Assertions.assertEquals((Object)new URI(HOT_URL), (Object)httpPatch.getUri());
    }

    @Test
    void testBasicHttpPutMethodProperties() throws Exception {
        HttpPut httpPut = new HttpPut(HOT_URL);
        Assertions.assertEquals((Object)"PUT", (Object)httpPut.getMethod());
        Assertions.assertEquals((Object)new URI(HOT_URL), (Object)httpPut.getUri());
    }

    @Test
    void testBasicHttpTraceMethodProperties() throws Exception {
        HttpTrace httpTrace = new HttpTrace(HOT_URL);
        Assertions.assertEquals((Object)"TRACE", (Object)httpTrace.getMethod());
        Assertions.assertEquals((Object)new URI(HOT_URL), (Object)httpTrace.getUri());
    }

    @Test
    void testBasicHttpDeleteMethodProperties() throws Exception {
        HttpDelete httpDelete = new HttpDelete(HOT_URL);
        Assertions.assertEquals((Object)"DELETE", (Object)httpDelete.getMethod());
        Assertions.assertEquals((Object)new URI(HOT_URL), (Object)httpDelete.getUri());
    }

    @Test
    void testGetMethodEmptyURI() throws Exception {
        HttpGet httpget = new HttpGet("");
        Assertions.assertEquals((Object)new URI("/"), (Object)httpget.getUri());
    }

    @Test
    void testPostMethodEmptyURI() throws Exception {
        HttpPost HttpPost2 = new HttpPost("");
        Assertions.assertEquals((Object)new URI("/"), (Object)HttpPost2.getUri());
    }

    @Test
    void testHeadMethodEmptyURI() throws Exception {
        HttpHead httpHead = new HttpHead("");
        Assertions.assertEquals((Object)new URI("/"), (Object)httpHead.getUri());
    }

    @Test
    void testOptionMethodEmptyURI() throws Exception {
        HttpOptions httpOption = new HttpOptions("");
        Assertions.assertEquals((Object)new URI("/"), (Object)httpOption.getUri());
    }

    @Test
    void testPatchMethodEmptyURI() throws Exception {
        HttpPatch httpPatch = new HttpPatch("");
        Assertions.assertEquals((Object)new URI("/"), (Object)httpPatch.getUri());
    }

    @Test
    void testPutMethodEmptyURI() throws Exception {
        HttpPut httpPut = new HttpPut("");
        Assertions.assertEquals((Object)new URI("/"), (Object)httpPut.getUri());
    }

    @Test
    void testTraceMethodEmptyURI() throws Exception {
        HttpTrace httpTrace = new HttpTrace("");
        Assertions.assertEquals((Object)new URI("/"), (Object)httpTrace.getUri());
    }

    @Test
    void testDeleteMethodEmptyURI() throws Exception {
        HttpDelete httpDelete = new HttpDelete("");
        Assertions.assertEquals((Object)new URI("/"), (Object)httpDelete.getUri());
    }

    @Test
    void testTraceMethodSetEntity() {
        HttpTrace httpTrace = new HttpTrace(HOT_URL);
        HttpEntity entity = EntityBuilder.create().setText("stuff").build();
        Assertions.assertThrows(IllegalStateException.class, () -> httpTrace.setEntity(entity));
    }

    @Test
    void testOptionMethodGetAllowedMethods() {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        response.addHeader("Allow", (Object)"GET, HEAD");
        response.addHeader("Allow", (Object)"DELETE");
        response.addHeader("Content-Length", (Object)"128");
        HttpOptions httpOptions = new HttpOptions("");
        Set methods = httpOptions.getAllowedMethods((HttpResponse)response);
        Assertions.assertAll((String)"Must all pass", (Executable[])new Executable[]{() -> Assertions.assertFalse((boolean)methods.isEmpty()), () -> Assertions.assertEquals((int)3, (int)methods.size()), () -> Assertions.assertTrue((boolean)methods.containsAll(Stream.of("HEAD", "DELETE", "GET").collect(Collectors.toCollection(HashSet::new))))});
    }
}

