/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.apache.hc.client5.http.entity.DecompressingEntity;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestDecompressingEntity {
    TestDecompressingEntity() {
    }

    @Test
    void testNonStreaming() throws Exception {
        CRC32 crc32 = new CRC32();
        StringEntity wrapped = new StringEntity("1234567890", StandardCharsets.US_ASCII);
        ChecksumEntity entity = new ChecksumEntity((HttpEntity)wrapped, crc32);
        Assertions.assertFalse((boolean)entity.isStreaming());
        String s = EntityUtils.toString((HttpEntity)entity);
        Assertions.assertEquals((Object)"1234567890", (Object)s);
        Assertions.assertEquals((long)639479525L, (long)crc32.getValue());
        InputStream in1 = entity.getContent();
        InputStream in2 = entity.getContent();
        Assertions.assertNotSame((Object)in1, (Object)in2);
    }

    @Test
    void testStreaming() throws Exception {
        CRC32 crc32 = new CRC32();
        ByteArrayInputStream in = new ByteArrayInputStream("1234567890".getBytes(StandardCharsets.US_ASCII));
        InputStreamEntity wrapped = new InputStreamEntity((InputStream)in, -1L, ContentType.DEFAULT_TEXT);
        ChecksumEntity entity = new ChecksumEntity((HttpEntity)wrapped, crc32);
        Assertions.assertTrue((boolean)entity.isStreaming());
        String s = EntityUtils.toString((HttpEntity)entity);
        Assertions.assertEquals((Object)"1234567890", (Object)s);
        Assertions.assertEquals((long)639479525L, (long)crc32.getValue());
        InputStream in1 = entity.getContent();
        InputStream in2 = entity.getContent();
        Assertions.assertSame((Object)in1, (Object)in2);
        EntityUtils.consume((HttpEntity)entity);
        EntityUtils.consume((HttpEntity)entity);
    }

    @Test
    void testStreamingMarking() throws Exception {
        CRC32 crc32 = new CRC32();
        ByteArrayInputStream in = new ByteArrayInputStream("1234567890".getBytes(StandardCharsets.US_ASCII));
        InputStreamEntity wrapped = new InputStreamEntity((InputStream)in, -1L, ContentType.DEFAULT_TEXT);
        ChecksumEntity entity = new ChecksumEntity((HttpEntity)wrapped, crc32);
        InputStream in1 = entity.getContent();
        Assertions.assertEquals((int)49, (int)in1.read());
        Assertions.assertEquals((int)50, (int)in1.read());
        in1.mark(1);
        Assertions.assertEquals((int)51, (int)in1.read());
        in1.reset();
        Assertions.assertEquals((int)51, (int)in1.read());
        EntityUtils.consume((HttpEntity)entity);
    }

    @Test
    void testWriteToStream() throws Exception {
        CRC32 crc32 = new CRC32();
        StringEntity wrapped = new StringEntity("1234567890", StandardCharsets.US_ASCII);
        try (ChecksumEntity entity = new ChecksumEntity((HttpEntity)wrapped, crc32);){
            Assertions.assertFalse((boolean)entity.isStreaming());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            entity.writeTo(out);
            String s = new String(out.toByteArray(), StandardCharsets.US_ASCII);
            Assertions.assertEquals((Object)"1234567890", (Object)s);
            Assertions.assertEquals((long)639479525L, (long)crc32.getValue());
        }
    }

    static class ChecksumEntity
    extends DecompressingEntity {
        public ChecksumEntity(HttpEntity wrapped, Checksum checksum) {
            super(wrapped, inStream -> new CheckedInputStream(inStream, checksum));
        }
    }
}

