/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.examples;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.concurrent.Future;
import org.apache.hc.client5.http.async.methods.AbstractBinPushConsumer;
import org.apache.hc.client5.http.async.methods.AbstractCharResponseConsumer;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.impl.routing.RequestRouter;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.support.BasicRequestProducer;
import org.apache.hc.core5.http.support.BasicRequestBuilder;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.io.CloseMode;

public class AsyncClientH2ServerPush {
    public static void main(String[] args) throws Exception {
        CloseableHttpAsyncClient client = HttpAsyncClients.custom().setH2Config(H2Config.custom().setPushEnabled(true).build()).setConnectionManager((AsyncClientConnectionManager)PoolingAsyncClientConnectionManagerBuilder.create().setDefaultTlsConfig(TlsConfig.custom().setVersionPolicy(HttpVersionPolicy.FORCE_HTTP_2).build()).build()).build();
        client.start();
        RequestRouter pushRequestRouter = RequestRouter.builder().resolveAuthority(RequestRouter.LOCAL_AUTHORITY_RESOLVER).addRoute(RequestRouter.LOCAL_AUTHORITY, "*", () -> new AbstractBinPushConsumer(){

            protected void start(HttpRequest promise, HttpResponse response, ContentType contentType) {
                System.out.println(promise.getPath() + " (push)->" + new StatusLine(response));
            }

            protected int capacityIncrement() {
                return Integer.MAX_VALUE;
            }

            protected void data(ByteBuffer data, boolean endOfStream) {
            }

            protected void completed() {
            }

            public void failed(Exception cause) {
                System.out.println("(push)->" + cause);
            }

            public void releaseResources() {
            }
        }).build();
        HttpHost target = new HttpHost("https", "nghttp2.org");
        final BasicHttpRequest request = BasicRequestBuilder.get().setHttpHost(target).setPath("/httpbin/").build();
        System.out.println("Executing request " + request);
        Future future = client.execute((AsyncRequestProducer)new BasicRequestProducer((HttpRequest)request, null), (AsyncResponseConsumer)new AbstractCharResponseConsumer<Void>(){

            protected void start(HttpResponse response, ContentType contentType) {
                System.out.println(request + "->" + new StatusLine(response));
            }

            protected int capacityIncrement() {
                return Integer.MAX_VALUE;
            }

            protected void data(CharBuffer data, boolean endOfStream) {
            }

            protected Void buildResult() {
                return null;
            }

            public void failed(Exception cause) {
                System.out.println(request + "->" + cause);
            }

            public void releaseResources() {
            }
        }, HttpAsyncClients.pushRouter((RequestRouter)pushRequestRouter), null, null);
        future.get();
        System.out.println("Shutting down");
        client.close(CloseMode.GRACEFUL);
    }
}

