/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.examples;

import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.protocol.HttpContext;

public class ClientSNI {
    public static final void main(String[] args) throws Exception {
        try (CloseableHttpClient httpclient = HttpClients.createSystem();){
            HttpHost target = new HttpHost("https", "www.google.com");
            HttpGet httpget = new HttpGet("https://www.google.ch/");
            System.out.println("Executing request " + httpget.getMethod() + " " + httpget.getUri());
            HttpClientContext clientContext = HttpClientContext.create();
            httpclient.execute(target, (ClassicHttpRequest)httpget, (HttpContext)clientContext, response -> {
                System.out.println("----------------------------------------");
                System.out.println(httpget + "->" + new StatusLine((HttpResponse)response));
                EntityUtils.consume((HttpEntity)response.getEntity());
                SSLSession sslSession = clientContext.getSSLSession();
                if (sslSession != null) {
                    try {
                        System.out.println("Peer: " + sslSession.getPeerPrincipal());
                        System.out.println("TLS protocol: " + sslSession.getProtocol());
                        System.out.println("TLS cipher suite: " + sslSession.getCipherSuite());
                    }
                    catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                        // empty catch block
                    }
                }
                return null;
            });
        }
    }
}

