/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.hc.client5.http.impl.InMemoryDnsResolver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class InMemoryDnsResolverTest {
    InMemoryDnsResolverTest() {
    }

    @Test
    void resolve() throws UnknownHostException {
        InMemoryDnsResolver resolver = new InMemoryDnsResolver();
        String hostString = "127.0.0.1";
        byte[] address = new byte[]{127, 0, 0, 1};
        resolver.add("127.0.0.1", new InetAddress[]{InetAddress.getByAddress("127.0.0.1", address)});
        InetAddress[] result1 = resolver.resolve("127.0.0.1");
        Assertions.assertEquals((int)1, (int)result1.length);
        Assertions.assertArrayEquals((byte[])address, (byte[])result1[0].getAddress());
    }

    @Test
    void resolveIPv6ZoneId() throws UnknownHostException {
        InMemoryDnsResolver resolver = new InMemoryDnsResolver();
        String hostStr = "[fe80::221:b7ff:fe8a:57d5%en4]";
        byte[] address = new byte[]{-2, -128, 0, 0, 0, 0, 0, 0, 2, 33, -73, -1, -2, -118, 87, -43};
        resolver.add("[fe80::221:b7ff:fe8a:57d5%en4]", new InetAddress[]{InetAddress.getByAddress("[fe80::221:b7ff:fe8a:57d5%en4]", address)});
        InetAddress[] result = resolver.resolve("[fe80::221:b7ff:fe8a:57d5%en4]");
        Assertions.assertEquals((int)1, (int)result.length);
        Assertions.assertArrayEquals((byte[])address, (byte[])result[0].getAddress());
    }
}

