/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.time.Instant;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.classic.BackoffManager;
import org.apache.hc.client5.http.impl.classic.AIMDBackoffManager;
import org.apache.hc.client5.http.impl.classic.MockConnPoolControl;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.pool.ConnPoolControl;
import org.apache.hc.core5.util.TimeValue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestAIMDBackoffManager {
    private AIMDBackoffManager impl;
    private MockConnPoolControl connPerRoute;
    private HttpRoute route;
    private static final long DEFAULT_COOL_DOWN_MS = 10L;

    TestAIMDBackoffManager() {
    }

    @BeforeEach
    void setUp() {
        this.connPerRoute = new MockConnPoolControl();
        this.route = new HttpRoute(new HttpHost("localhost", 80));
        this.impl = new AIMDBackoffManager((ConnPoolControl)this.connPerRoute);
        this.impl.setPerHostConnectionCap(10);
        this.impl.setCoolDown(TimeValue.ofMilliseconds((long)10L));
    }

    @Test
    void isABackoffManager() {
        Assertions.assertTrue((boolean)(this.impl instanceof BackoffManager));
    }

    @Test
    void halvesConnectionsOnBackoff() {
        this.connPerRoute.setMaxPerRoute(this.route, 4);
        this.impl.backOff(this.route);
        Assertions.assertEquals((int)2, (int)this.connPerRoute.getMaxPerRoute(this.route));
    }

    @Test
    void doesNotBackoffBelowOneConnection() {
        this.connPerRoute.setMaxPerRoute(this.route, 1);
        this.impl.backOff(this.route);
        Assertions.assertEquals((int)1, (int)this.connPerRoute.getMaxPerRoute(this.route));
    }

    @Test
    void increasesByOneOnProbe() {
        this.connPerRoute.setMaxPerRoute(this.route, 2);
        this.impl.probe(this.route);
        Assertions.assertEquals((int)3, (int)this.connPerRoute.getMaxPerRoute(this.route));
    }

    @Test
    void doesNotIncreaseBeyondPerHostMaxOnProbe() {
        this.connPerRoute.setDefaultMaxPerRoute(5);
        this.connPerRoute.setMaxPerRoute(this.route, 5);
        this.impl.setPerHostConnectionCap(5);
        this.impl.probe(this.route);
        Assertions.assertEquals((int)5, (int)this.connPerRoute.getMaxPerRoute(this.route));
    }

    @Test
    void backoffDoesNotAdjustDuringCoolDownPeriod() {
        this.connPerRoute.setMaxPerRoute(this.route, 4);
        this.impl.backOff(this.route);
        long max1 = this.connPerRoute.getMaxPerRoute(this.route);
        Map lastRouteBackoffs = this.impl.getLastRouteBackoffs();
        lastRouteBackoffs.put(this.route, Instant.now().minusMillis(1L));
        this.impl.backOff(this.route);
        long max2 = this.connPerRoute.getMaxPerRoute(this.route);
        Assertions.assertEquals((long)max1, (long)max2);
    }

    @Test
    void backoffStillAdjustsAfterCoolDownPeriod() {
        this.connPerRoute.setMaxPerRoute(this.route, 8);
        this.impl.backOff(this.route);
        long initialMax = this.connPerRoute.getMaxPerRoute(this.route);
        Map lastRouteBackoffs = this.impl.getLastRouteBackoffs();
        lastRouteBackoffs.put(this.route, Instant.now().minusMillis(11L));
        this.impl.backOff(this.route);
        long finalMax = this.connPerRoute.getMaxPerRoute(this.route);
        if (initialMax != 1L) {
            Assertions.assertTrue((finalMax < initialMax ? 1 : 0) != 0, (String)"Max connections should decrease after cooldown");
        } else {
            Assertions.assertEquals((long)1L, (long)finalMax, (String)"Max connections should remain 1 if it's already at the minimum");
        }
    }

    @Test
    void probeDoesNotAdjustDuringCooldownPeriod() {
        this.connPerRoute.setMaxPerRoute(this.route, 4);
        this.impl.probe(this.route);
        long max1 = this.connPerRoute.getMaxPerRoute(this.route);
        Map lastRouteProbes = this.impl.getLastRouteProbes();
        lastRouteProbes.put(this.route, Instant.now().minusMillis(1L));
        this.impl.probe(this.route);
        long max2 = this.connPerRoute.getMaxPerRoute(this.route);
        Assertions.assertEquals((long)max1, (long)max2);
    }

    @Test
    void probeStillAdjustsAfterCoolDownPeriod() {
        this.connPerRoute.setMaxPerRoute(this.route, 8);
        this.impl.probe(this.route);
        long max = this.connPerRoute.getMaxPerRoute(this.route);
        Map lastRouteProbes = this.impl.getLastRouteProbes();
        lastRouteProbes.put(this.route, Instant.now().minusMillis(11L));
        this.impl.probe(this.route);
        Assertions.assertTrue((max < (long)this.connPerRoute.getMaxPerRoute(this.route) ? 1 : 0) != 0);
    }

    @Test
    void willBackoffImmediatelyEvenAfterAProbe() {
        this.connPerRoute.setMaxPerRoute(this.route, 8);
        this.impl.probe(this.route);
        long max = this.connPerRoute.getMaxPerRoute(this.route);
        this.impl.backOff(this.route);
        Assertions.assertTrue(((long)this.connPerRoute.getMaxPerRoute(this.route) < max ? 1 : 0) != 0);
    }

    @Test
    void backOffFactorIsConfigurable() {
        this.connPerRoute.setMaxPerRoute(this.route, 10);
        this.impl.setBackoffFactor(0.9);
        this.impl.backOff(this.route);
        Assertions.assertEquals((int)9, (int)this.connPerRoute.getMaxPerRoute(this.route));
    }

    @Test
    void coolDownPeriodIsConfigurable() {
        long cd = new Random().nextInt(500) + 500;
        this.impl.setCoolDown(TimeValue.ofMilliseconds((long)cd));
        this.impl.probe(this.route);
        int max0 = this.connPerRoute.getMaxPerRoute(this.route);
        Map lastRouteProbes = this.impl.getLastRouteProbes();
        lastRouteProbes.put(this.route, Instant.now().minusMillis(cd / 2L));
        this.impl.probe(this.route);
        Assertions.assertEquals((int)max0, (int)this.connPerRoute.getMaxPerRoute(this.route));
        lastRouteProbes.put(this.route, Instant.now().minusMillis(cd + 1L));
        this.impl.probe(this.route);
        Assertions.assertTrue((max0 < this.connPerRoute.getMaxPerRoute(this.route) ? 1 : 0) != 0);
    }

    @Test
    void testConcurrency() throws InterruptedException {
        HttpRoute threadRoute;
        int i;
        int initialMaxPerRoute = 10;
        int numberOfThreads = 20;
        int numberOfOperationsPerThread = 100;
        CyclicBarrier barrier = new CyclicBarrier(20);
        CountDownLatch latch = new CountDownLatch(20);
        for (i = 0; i < 20; ++i) {
            threadRoute = new HttpRoute(new HttpHost("localhost", 8080 + i));
            this.connPerRoute.setMaxPerRoute(threadRoute, 10);
            new Thread(() -> {
                try {
                    barrier.await();
                    for (int j = 0; j < 100; ++j) {
                        if (Math.random() < 0.5) {
                            this.impl.backOff(threadRoute);
                            continue;
                        }
                        this.impl.probe(threadRoute);
                    }
                }
                catch (InterruptedException | BrokenBarrierException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    latch.countDown();
                }
            }).start();
        }
        latch.await();
        for (i = 0; i < 20; ++i) {
            threadRoute = new HttpRoute(new HttpHost("localhost", 8080 + i));
            int finalMaxPerRoute = this.connPerRoute.getMaxPerRoute(threadRoute);
            Assertions.assertTrue((finalMaxPerRoute >= 1 && finalMaxPerRoute <= 17 ? 1 : 0) != 0);
        }
    }
}

