/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.protocol;

import java.nio.charset.StandardCharsets;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.protocol.RequestExpectContinue;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestRequestExpectContinue {
    TestRequestExpectContinue() {
    }

    @Test
    void testRequestExpectContinueGenerated() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        RequestConfig config = RequestConfig.custom().setExpectContinueEnabled(true).build();
        context.setRequestConfig(config);
        BasicClassicHttpRequest request = new BasicClassicHttpRequest("POST", "/");
        String s = "whatever";
        StringEntity entity = new StringEntity("whatever", StandardCharsets.US_ASCII);
        request.setEntity((HttpEntity)entity);
        RequestExpectContinue interceptor = new RequestExpectContinue();
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Header header = request.getFirstHeader("Expect");
        Assertions.assertNotNull((Object)header);
        Assertions.assertEquals((Object)"100-continue", (Object)header.getValue());
    }

    @Test
    void testRequestExpectContinueNotGenerated() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        RequestConfig config = RequestConfig.custom().setExpectContinueEnabled(false).build();
        context.setRequestConfig(config);
        BasicClassicHttpRequest request = new BasicClassicHttpRequest("POST", "/");
        String s = "whatever";
        StringEntity entity = new StringEntity("whatever", StandardCharsets.US_ASCII);
        request.setEntity((HttpEntity)entity);
        RequestExpectContinue interceptor = new RequestExpectContinue();
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        Header header = request.getFirstHeader("100-continue");
        Assertions.assertNull((Object)header);
    }

    @Test
    void testRequestExpectContinueHTTP10() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        RequestConfig config = RequestConfig.custom().setExpectContinueEnabled(true).build();
        context.setRequestConfig(config);
        BasicClassicHttpRequest request = new BasicClassicHttpRequest("POST", "/");
        request.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        String s = "whatever";
        StringEntity entity = new StringEntity("whatever", StandardCharsets.US_ASCII);
        request.setEntity((HttpEntity)entity);
        RequestExpectContinue interceptor = new RequestExpectContinue();
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        Header header = request.getFirstHeader("100-continue");
        Assertions.assertNull((Object)header);
    }

    @Test
    void testRequestExpectContinueZeroContent() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        RequestConfig config = RequestConfig.custom().setExpectContinueEnabled(true).build();
        context.setRequestConfig(config);
        BasicClassicHttpRequest request = new BasicClassicHttpRequest("POST", "/");
        String s = "";
        StringEntity entity = new StringEntity("", StandardCharsets.US_ASCII);
        request.setEntity((HttpEntity)entity);
        RequestExpectContinue interceptor = new RequestExpectContinue();
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        Header header = request.getFirstHeader("100-continue");
        Assertions.assertNull((Object)header);
    }

    @Test
    void testRequestExpectContinueInvalidInput() {
        RequestExpectContinue interceptor = new RequestExpectContinue();
        Assertions.assertThrows(NullPointerException.class, () -> interceptor.process(null, null, null));
    }

    @Test
    void testRequestExpectContinueIgnoreNonenclosingRequests() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest("POST", "/");
        RequestExpectContinue interceptor = new RequestExpectContinue();
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        Assertions.assertEquals((int)0, (int)request.getHeaders().length);
    }
}

