/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.api.domain;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.client.api.domain.ClientAnnotatable;
import org.apache.olingo.client.api.domain.ClientAnnotation;
import org.apache.olingo.client.api.domain.ClientInlineEntity;
import org.apache.olingo.client.api.domain.ClientInlineEntitySet;
import org.apache.olingo.client.api.domain.ClientItem;
import org.apache.olingo.client.api.domain.ClientLinkType;

public class ClientLink
extends ClientItem
implements ClientAnnotatable {
    private final ClientLinkType type;
    private final String rel;
    private String mediaETag;
    private final List<ClientAnnotation> annotations = new ArrayList<ClientAnnotation>();

    private static URI getURI(URI base, String href) {
        if (href == null) {
            throw new IllegalArgumentException("Null link provided");
        }
        URI uri = URI.create(href);
        if (!uri.isAbsolute() && base != null) {
            uri = URI.create(base.toASCIIString() + "/" + href);
        }
        return uri.normalize();
    }

    public ClientLink(URI uri, ClientLinkType type, String title) {
        super(title);
        this.type = type;
        this.setLink(uri);
        switch (this.type) {
            case ASSOCIATION: {
                this.rel = "http://docs.oasis-open.org/odata/ns/relatedlinks/" + title;
                break;
            }
            case ENTITY_NAVIGATION: 
            case ENTITY_SET_NAVIGATION: {
                this.rel = "http://docs.oasis-open.org/odata/ns/related/" + title;
                break;
            }
            default: {
                this.rel = "http://docs.oasis-open.org/odata/ns/edit-media/" + title;
            }
        }
    }

    protected ClientLink(URI baseURI, String href, ClientLinkType type, String title) {
        this(ClientLink.getURI(baseURI, href), type, title);
    }

    public ClientLinkType getType() {
        return this.type;
    }

    public ClientInlineEntity asInlineEntity() {
        return this instanceof ClientInlineEntity ? (ClientInlineEntity)this : null;
    }

    public ClientInlineEntitySet asInlineEntitySet() {
        return this instanceof ClientInlineEntitySet ? (ClientInlineEntitySet)this : null;
    }

    public String getRel() {
        return this.rel;
    }

    public String getMediaETag() {
        return this.mediaETag;
    }

    @Override
    public List<ClientAnnotation> getAnnotations() {
        return this.annotations;
    }

    public static class Builder {
        private URI uri;
        private ClientLinkType type;
        private String title;

        public Builder setURI(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder setURI(URI baseURI, String href) {
            this.uri = ClientLink.getURI(baseURI, href);
            return this;
        }

        public Builder setType(ClientLinkType type) {
            this.type = type;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public ClientLink build() {
            return new ClientLink(this.uri, this.type, this.title);
        }
    }
}

