/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.data;

import java.net.URI;
import java.util.Map;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmType;

public class ContextURL {
    private URI serviceRoot;
    private String entitySetOrSingletonOrType;
    private boolean isCollection = false;
    private String derivedEntity;
    private String selectList;
    private String navOrPropertyPath;
    private String keyPath;
    private Suffix suffix;

    private ContextURL() {
    }

    public URI getServiceRoot() {
        return this.serviceRoot;
    }

    public String getEntitySetOrSingletonOrType() {
        return this.entitySetOrSingletonOrType;
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public String getDerivedEntity() {
        return this.derivedEntity;
    }

    public String getSelectList() {
        return this.selectList;
    }

    public String getNavOrPropertyPath() {
        return this.navOrPropertyPath;
    }

    public String getKeyPath() {
        return this.keyPath;
    }

    public Suffix getSuffix() {
        return this.suffix;
    }

    public boolean isEntity() {
        return this.suffix == Suffix.ENTITY;
    }

    public boolean isReference() {
        return this.suffix == Suffix.REFERENCE;
    }

    public boolean isDelta() {
        return this.suffix == Suffix.DELTA;
    }

    public boolean isDeltaDeletedEntity() {
        return this.suffix == Suffix.DELTA_DELETED_ENTITY;
    }

    public boolean isDeltaLink() {
        return this.suffix == Suffix.DELTA_LINK;
    }

    public boolean isDeltaDeletedLink() {
        return this.suffix == Suffix.DELTA_DELETED_LINK;
    }

    public static Builder with() {
        return new Builder();
    }

    public static final class Builder {
        private ContextURL contextURL = new ContextURL();

        public Builder serviceRoot(URI serviceRoot) {
            this.contextURL.serviceRoot = serviceRoot;
            return this;
        }

        public Builder entitySet(EdmEntitySet entitySet) {
            this.contextURL.entitySetOrSingletonOrType = entitySet.getName();
            return this;
        }

        public Builder keySegment(Object value) {
            if (value != null) {
                this.contextURL.keyPath = String.valueOf(value);
            }
            return this;
        }

        public Builder keySegment(Map<String, Object> values) {
            if (values != null && !values.isEmpty()) {
                if (values.size() == 1) {
                    return this.keySegment(values.values().iterator().next());
                }
                StringBuilder sb = new StringBuilder();
                for (String key : values.keySet()) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(key).append("=").append(values.get(key));
                }
                this.contextURL.keyPath = sb.toString();
            }
            return this;
        }

        public Builder entitySetOrSingletonOrType(String entitySetOrSingletonOrType) {
            this.contextURL.entitySetOrSingletonOrType = entitySetOrSingletonOrType;
            return this;
        }

        public Builder propertyType(EdmType type) {
            this.contextURL.entitySetOrSingletonOrType = type.getFullQualifiedName().toString();
            return this;
        }

        public Builder asCollection() {
            this.contextURL.isCollection = true;
            return this;
        }

        public Builder derived(EdmEntityType derivedType) {
            this.contextURL.derivedEntity = derivedType.getFullQualifiedName().getFullQualifiedNameAsString();
            return this;
        }

        public Builder derivedEntity(String derivedEntity) {
            this.contextURL.derivedEntity = derivedEntity;
            return this;
        }

        public Builder navOrPropertyPath(String navOrPropertyPath) {
            this.contextURL.navOrPropertyPath = navOrPropertyPath;
            return this;
        }

        public Builder selectList(String selectList) {
            this.contextURL.selectList = selectList;
            return this;
        }

        public Builder suffix(Suffix suffix) {
            this.contextURL.suffix = suffix;
            return this;
        }

        public ContextURL build() {
            return this.contextURL;
        }
    }

    public static enum Suffix {
        ENTITY("$entity"),
        REFERENCE("$ref"),
        DELTA("$delta"),
        DELTA_DELETED_ENTITY("$deletedEntity"),
        DELTA_LINK("$link"),
        DELTA_DELETED_LINK("$deletedLink");

        private final String representation;

        private Suffix(String representation) {
            this.representation = representation;
        }

        public String getRepresentation() {
            return this.representation;
        }
    }
}

