/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.edm.geo;

import java.util.List;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.geo.ComposedGeospatial;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.api.edm.geo.MultiPoint;
import org.apache.olingo.commons.api.edm.geo.Point;
import org.apache.olingo.commons.api.edm.geo.SRID;

public class Polygon
extends Geospatial {
    final ComposedGeospatial<Point> interior;
    final ComposedGeospatial<Point> exterior;

    public Polygon(Geospatial.Dimension dimension, SRID srid, List<Point> interior, List<Point> exterior) {
        super(dimension, Geospatial.Type.POLYGON, srid);
        this.interior = new MultiPoint(dimension, srid, interior);
        this.exterior = new MultiPoint(dimension, srid, exterior);
    }

    public ComposedGeospatial<Point> getInterior() {
        return this.interior;
    }

    public ComposedGeospatial<Point> getExterior() {
        return this.exterior;
    }

    @Override
    public EdmPrimitiveTypeKind getEdmPrimitiveTypeKind() {
        return this.dimension == Geospatial.Dimension.GEOGRAPHY ? EdmPrimitiveTypeKind.GeographyPolygon : EdmPrimitiveTypeKind.GeometryPolygon;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Polygon polygon = (Polygon)o;
        return this.dimension == polygon.dimension && (this.srid == null ? polygon.srid == null : this.srid.equals(polygon.srid)) && (this.interior == null ? polygon.interior == null : this.interior.equals(polygon.interior)) && (this.exterior == null ? polygon.exterior == null : this.exterior.equals(polygon.exterior));
    }

    public int hashCode() {
        int result = this.dimension == null ? 0 : this.dimension.hashCode();
        result = 31 * result + (this.srid == null ? 0 : this.srid.hashCode());
        result = 31 * result + (this.interior == null ? 0 : this.interior.hashCode());
        result = 31 * result + (this.exterior == null ? 0 : this.exterior.hashCode());
        return result;
    }
}

