/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.edm.constants;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum ODataServiceVersion {
    V10("1.0"),
    V20("2.0"),
    V30("3.0"),
    V40("4.0");

    private static final Map<NamespaceKey, String> V30_NAMESPACES;
    private static final Map<NamespaceKey, String> V40_NAMESPACES;
    private static final Map<JsonKey, String> V30_JSON;
    private static final Map<JsonKey, String> V40_JSON;
    private static final Pattern DATASERVICEVERSIONPATTERN;
    private final String version;

    public static boolean validateDataServiceVersion(String version) {
        Matcher matcher = DATASERVICEVERSIONPATTERN.matcher(version);
        if (matcher.matches()) {
            String possibleDataServiceVersion = matcher.group(1);
            return V10.toString().equals(possibleDataServiceVersion) || V20.toString().equals(possibleDataServiceVersion) || V30.toString().equals(possibleDataServiceVersion) || V40.toString().equals(possibleDataServiceVersion);
        }
        throw new IllegalArgumentException(version);
    }

    public static boolean isBiggerThan(String actual, String comparedTo) {
        double other;
        if (!ODataServiceVersion.validateDataServiceVersion(comparedTo) || !ODataServiceVersion.validateDataServiceVersion(actual)) {
            throw new IllegalArgumentException("Illegal arguments: " + comparedTo + " and " + actual);
        }
        double me = Double.parseDouble(ODataServiceVersion.extractDataServiceVersionString(actual));
        return me > (other = Double.parseDouble(ODataServiceVersion.extractDataServiceVersionString(comparedTo)));
    }

    private static String extractDataServiceVersionString(String rawDataServiceVersion) {
        if (rawDataServiceVersion != null) {
            String[] pattern = rawDataServiceVersion.split(";");
            return pattern[0];
        }
        return null;
    }

    private ODataServiceVersion(String version) {
        this.version = version;
    }

    public String getNamespace(NamespaceKey key) {
        return this == V10 || this == V20 ? null : (this == V30 ? V30_NAMESPACES.get((Object)key) : V40_NAMESPACES.get((Object)key));
    }

    public String getJsonName(JsonKey key) {
        return this == V10 || this == V20 ? null : (this == V30 ? V30_JSON.get((Object)key) : V40_JSON.get((Object)key));
    }

    public String toString() {
        return this.version;
    }

    static {
        V30_NAMESPACES = new HashMap<NamespaceKey, String>(){
            private static final long serialVersionUID = 3109256773218160485L;
            private static final String BASE = "http://schemas.microsoft.com/ado/2007/08/dataservices";
            {
                this.put(NamespaceKey.DATASERVICES, BASE);
                this.put(NamespaceKey.METADATA, "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata");
                this.put(NamespaceKey.SCHEME, "http://schemas.microsoft.com/ado/2007/08/dataservices/scheme");
                this.put(NamespaceKey.NAVIGATION_LINK_REL, "http://schemas.microsoft.com/ado/2007/08/dataservices/related/");
                this.put(NamespaceKey.ASSOCIATION_LINK_REL, "http://schemas.microsoft.com/ado/2007/08/dataservices/relatedlinks/");
                this.put(NamespaceKey.MEDIA_EDIT_LINK_REL, "http://schemas.microsoft.com/ado/2007/08/dataservices/edit-media/");
            }
        };
        V40_NAMESPACES = new HashMap<NamespaceKey, String>(){
            private static final long serialVersionUID = 3109256773218160485L;
            private static final String BASE = "http://docs.oasis-open.org/odata/ns/";
            {
                this.put(NamespaceKey.DATASERVICES, "http://docs.oasis-open.org/odata/ns/data");
                this.put(NamespaceKey.METADATA, "http://docs.oasis-open.org/odata/ns/metadata");
                this.put(NamespaceKey.SCHEME, "http://docs.oasis-open.org/odata/ns/scheme");
                this.put(NamespaceKey.NAVIGATION_LINK_REL, "http://docs.oasis-open.org/odata/ns/related/");
                this.put(NamespaceKey.ASSOCIATION_LINK_REL, "http://docs.oasis-open.org/odata/ns/relatedlinks/");
                this.put(NamespaceKey.MEDIA_EDIT_LINK_REL, "http://docs.oasis-open.org/odata/ns/edit-media/");
                this.put(NamespaceKey.DELTA_LINK_REL, "http://docs.oasis-open.org/odata/ns/delta");
            }
        };
        V30_JSON = new HashMap<JsonKey, String>(){
            private static final long serialVersionUID = 3109256773218160485L;
            {
                this.put(JsonKey.TYPE, "odata.type");
                this.put(JsonKey.ID, "odata.id");
                this.put(JsonKey.ETAG, "odata.etag");
                this.put(JsonKey.READ_LINK, "odata.readLink");
                this.put(JsonKey.EDIT_LINK, "odata.editLink");
                this.put(JsonKey.MEDIA_READ_LINK, "odata.mediaReadLink");
                this.put(JsonKey.MEDIA_EDIT_LINK, "odata.mediaEditLink");
                this.put(JsonKey.MEDIA_CONTENT_TYPE, "odata.mediaContentType");
                this.put(JsonKey.MEDIA_ETAG, "odata.mediaEtag");
                this.put(JsonKey.ASSOCIATION_LINK, "@odata.associationLinkUrl");
                this.put(JsonKey.NAVIGATION_LINK, "@odata.navigationLinkUrl");
                this.put(JsonKey.COUNT, "odata.count");
                this.put(JsonKey.NEXT_LINK, "odata.nextLink");
                this.put(JsonKey.ERROR, "odata.error");
            }
        };
        V40_JSON = new HashMap<JsonKey, String>(){
            private static final long serialVersionUID = 3109256773218160485L;
            {
                this.put(JsonKey.TYPE, "@odata.type");
                this.put(JsonKey.ID, "@odata.id");
                this.put(JsonKey.ETAG, "@odata.etag");
                this.put(JsonKey.READ_LINK, "@odata.readLink");
                this.put(JsonKey.EDIT_LINK, "@odata.editLink");
                this.put(JsonKey.MEDIA_READ_LINK, "@odata.mediaReadLink");
                this.put(JsonKey.MEDIA_EDIT_LINK, "@odata.mediaEditLink");
                this.put(JsonKey.MEDIA_CONTENT_TYPE, "@odata.mediaContentType");
                this.put(JsonKey.MEDIA_ETAG, "@odata.mediaEtag");
                this.put(JsonKey.ASSOCIATION_LINK, "@odata.associationLink");
                this.put(JsonKey.NAVIGATION_LINK, "@odata.navigationLink");
                this.put(JsonKey.COUNT, "@odata.count");
                this.put(JsonKey.NEXT_LINK, "@odata.nextLink");
                this.put(JsonKey.DELTA_LINK, "@odata.deltaLink");
                this.put(JsonKey.ERROR, "error");
            }
        };
        DATASERVICEVERSIONPATTERN = Pattern.compile("(\\p{Digit}+\\.\\p{Digit}+)(:?;.*)?");
    }

    public static enum JsonKey {
        TYPE,
        ID,
        ETAG,
        READ_LINK,
        EDIT_LINK,
        MEDIA_READ_LINK,
        MEDIA_EDIT_LINK,
        MEDIA_CONTENT_TYPE,
        MEDIA_ETAG,
        ASSOCIATION_LINK,
        NAVIGATION_LINK,
        COUNT,
        NEXT_LINK,
        DELTA_LINK,
        ERROR;

    }

    public static enum NamespaceKey {
        DATASERVICES,
        METADATA,
        SCHEME,
        NAVIGATION_LINK_REL,
        ASSOCIATION_LINK_REL,
        MEDIA_EDIT_LINK_REL,
        DELTA_LINK_REL;

    }
}

